# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServerArgs', 'Server']

@pulumi.input_type
class ServerArgs:
    def __init__(__self__, *,
                 fdw_name: pulumi.Input[str],
                 server_name: pulumi.Input[str],
                 drop_cascade: Optional[pulumi.Input[bool]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 server_owner: Optional[pulumi.Input[str]] = None,
                 server_type: Optional[pulumi.Input[str]] = None,
                 server_version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Server resource.
        :param pulumi.Input[str] fdw_name: The name of the foreign-data wrapper that manages the server.
               Changing this value
               will force the creation of a new resource as this value can only be set
               when the foreign server is created.
        :param pulumi.Input[str] server_name: The name of the foreign server to be created.
        :param pulumi.Input[bool] drop_cascade: When true, will drop objects that depend on the server (such as user mappings), and in turn all objects that depend on those objects . (Default: false)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] options: This clause specifies the options for the server. The options typically define the connection details of the server, but the actual names and values are dependent on the server's foreign-data wrapper.
        :param pulumi.Input[str] server_owner: By default, the user who defines the server becomes its owner. Set this value to configure the new owner of the foreign server.
        :param pulumi.Input[str] server_type: Optional server type, potentially useful to foreign-data wrappers.
               Changing this value
               will force the creation of a new resource as this value can only be set
               when the foreign server is created.
        :param pulumi.Input[str] server_version: Optional server version, potentially useful to foreign-data wrappers.
        """
        pulumi.set(__self__, "fdw_name", fdw_name)
        pulumi.set(__self__, "server_name", server_name)
        if drop_cascade is not None:
            pulumi.set(__self__, "drop_cascade", drop_cascade)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if server_owner is not None:
            pulumi.set(__self__, "server_owner", server_owner)
        if server_type is not None:
            pulumi.set(__self__, "server_type", server_type)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)

    @property
    @pulumi.getter(name="fdwName")
    def fdw_name(self) -> pulumi.Input[str]:
        """
        The name of the foreign-data wrapper that manages the server.
        Changing this value
        will force the creation of a new resource as this value can only be set
        when the foreign server is created.
        """
        return pulumi.get(self, "fdw_name")

    @fdw_name.setter
    def fdw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "fdw_name", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The name of the foreign server to be created.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="dropCascade")
    def drop_cascade(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, will drop objects that depend on the server (such as user mappings), and in turn all objects that depend on those objects . (Default: false)
        """
        return pulumi.get(self, "drop_cascade")

    @drop_cascade.setter
    def drop_cascade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drop_cascade", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        This clause specifies the options for the server. The options typically define the connection details of the server, but the actual names and values are dependent on the server's foreign-data wrapper.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="serverOwner")
    def server_owner(self) -> Optional[pulumi.Input[str]]:
        """
        By default, the user who defines the server becomes its owner. Set this value to configure the new owner of the foreign server.
        """
        return pulumi.get(self, "server_owner")

    @server_owner.setter
    def server_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_owner", value)

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional server type, potentially useful to foreign-data wrappers.
        Changing this value
        will force the creation of a new resource as this value can only be set
        when the foreign server is created.
        """
        return pulumi.get(self, "server_type")

    @server_type.setter
    def server_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_type", value)

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional server version, potentially useful to foreign-data wrappers.
        """
        return pulumi.get(self, "server_version")

    @server_version.setter
    def server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_version", value)


@pulumi.input_type
class _ServerState:
    def __init__(__self__, *,
                 drop_cascade: Optional[pulumi.Input[bool]] = None,
                 fdw_name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 server_owner: Optional[pulumi.Input[str]] = None,
                 server_type: Optional[pulumi.Input[str]] = None,
                 server_version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Server resources.
        :param pulumi.Input[bool] drop_cascade: When true, will drop objects that depend on the server (such as user mappings), and in turn all objects that depend on those objects . (Default: false)
        :param pulumi.Input[str] fdw_name: The name of the foreign-data wrapper that manages the server.
               Changing this value
               will force the creation of a new resource as this value can only be set
               when the foreign server is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] options: This clause specifies the options for the server. The options typically define the connection details of the server, but the actual names and values are dependent on the server's foreign-data wrapper.
        :param pulumi.Input[str] server_name: The name of the foreign server to be created.
        :param pulumi.Input[str] server_owner: By default, the user who defines the server becomes its owner. Set this value to configure the new owner of the foreign server.
        :param pulumi.Input[str] server_type: Optional server type, potentially useful to foreign-data wrappers.
               Changing this value
               will force the creation of a new resource as this value can only be set
               when the foreign server is created.
        :param pulumi.Input[str] server_version: Optional server version, potentially useful to foreign-data wrappers.
        """
        if drop_cascade is not None:
            pulumi.set(__self__, "drop_cascade", drop_cascade)
        if fdw_name is not None:
            pulumi.set(__self__, "fdw_name", fdw_name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if server_owner is not None:
            pulumi.set(__self__, "server_owner", server_owner)
        if server_type is not None:
            pulumi.set(__self__, "server_type", server_type)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)

    @property
    @pulumi.getter(name="dropCascade")
    def drop_cascade(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, will drop objects that depend on the server (such as user mappings), and in turn all objects that depend on those objects . (Default: false)
        """
        return pulumi.get(self, "drop_cascade")

    @drop_cascade.setter
    def drop_cascade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drop_cascade", value)

    @property
    @pulumi.getter(name="fdwName")
    def fdw_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the foreign-data wrapper that manages the server.
        Changing this value
        will force the creation of a new resource as this value can only be set
        when the foreign server is created.
        """
        return pulumi.get(self, "fdw_name")

    @fdw_name.setter
    def fdw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fdw_name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        This clause specifies the options for the server. The options typically define the connection details of the server, but the actual names and values are dependent on the server's foreign-data wrapper.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the foreign server to be created.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="serverOwner")
    def server_owner(self) -> Optional[pulumi.Input[str]]:
        """
        By default, the user who defines the server becomes its owner. Set this value to configure the new owner of the foreign server.
        """
        return pulumi.get(self, "server_owner")

    @server_owner.setter
    def server_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_owner", value)

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional server type, potentially useful to foreign-data wrappers.
        Changing this value
        will force the creation of a new resource as this value can only be set
        when the foreign server is created.
        """
        return pulumi.get(self, "server_type")

    @server_type.setter
    def server_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_type", value)

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional server version, potentially useful to foreign-data wrappers.
        """
        return pulumi.get(self, "server_version")

    @server_version.setter
    def server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_version", value)


class Server(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 drop_cascade: Optional[pulumi.Input[bool]] = None,
                 fdw_name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 server_owner: Optional[pulumi.Input[str]] = None,
                 server_type: Optional[pulumi.Input[str]] = None,
                 server_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The ``Server`` resource creates and manages a foreign server on a PostgreSQL server.

        ## Usage

        ```python
        import pulumi
        import pulumi_postgresql as postgresql

        ext_postgres_fdw = postgresql.Extension("ext_postgres_fdw", name="postgres_fdw")
        myserver_postgres = postgresql.Server("myserver_postgres",
            server_name="myserver_postgres",
            fdw_name="postgres_fdw",
            options={
                "host": "foo",
                "dbname": "foodb",
                "port": "5432",
            },
            opts = pulumi.ResourceOptions(depends_on=[ext_postgres_fdw]))
        ```

        ```python
        import pulumi
        import pulumi_postgresql as postgresql

        ext_file_fdw = postgresql.Extension("ext_file_fdw", name="file_fdw")
        myserver_file = postgresql.Server("myserver_file",
            server_name="myserver_file",
            fdw_name="file_fdw",
            opts = pulumi.ResourceOptions(depends_on=[ext_file_fdw]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] drop_cascade: When true, will drop objects that depend on the server (such as user mappings), and in turn all objects that depend on those objects . (Default: false)
        :param pulumi.Input[str] fdw_name: The name of the foreign-data wrapper that manages the server.
               Changing this value
               will force the creation of a new resource as this value can only be set
               when the foreign server is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] options: This clause specifies the options for the server. The options typically define the connection details of the server, but the actual names and values are dependent on the server's foreign-data wrapper.
        :param pulumi.Input[str] server_name: The name of the foreign server to be created.
        :param pulumi.Input[str] server_owner: By default, the user who defines the server becomes its owner. Set this value to configure the new owner of the foreign server.
        :param pulumi.Input[str] server_type: Optional server type, potentially useful to foreign-data wrappers.
               Changing this value
               will force the creation of a new resource as this value can only be set
               when the foreign server is created.
        :param pulumi.Input[str] server_version: Optional server version, potentially useful to foreign-data wrappers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``Server`` resource creates and manages a foreign server on a PostgreSQL server.

        ## Usage

        ```python
        import pulumi
        import pulumi_postgresql as postgresql

        ext_postgres_fdw = postgresql.Extension("ext_postgres_fdw", name="postgres_fdw")
        myserver_postgres = postgresql.Server("myserver_postgres",
            server_name="myserver_postgres",
            fdw_name="postgres_fdw",
            options={
                "host": "foo",
                "dbname": "foodb",
                "port": "5432",
            },
            opts = pulumi.ResourceOptions(depends_on=[ext_postgres_fdw]))
        ```

        ```python
        import pulumi
        import pulumi_postgresql as postgresql

        ext_file_fdw = postgresql.Extension("ext_file_fdw", name="file_fdw")
        myserver_file = postgresql.Server("myserver_file",
            server_name="myserver_file",
            fdw_name="file_fdw",
            opts = pulumi.ResourceOptions(depends_on=[ext_file_fdw]))
        ```

        :param str resource_name: The name of the resource.
        :param ServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 drop_cascade: Optional[pulumi.Input[bool]] = None,
                 fdw_name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 server_owner: Optional[pulumi.Input[str]] = None,
                 server_type: Optional[pulumi.Input[str]] = None,
                 server_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerArgs.__new__(ServerArgs)

            __props__.__dict__["drop_cascade"] = drop_cascade
            if fdw_name is None and not opts.urn:
                raise TypeError("Missing required property 'fdw_name'")
            __props__.__dict__["fdw_name"] = fdw_name
            __props__.__dict__["options"] = options
            if server_name is None and not opts.urn:
                raise TypeError("Missing required property 'server_name'")
            __props__.__dict__["server_name"] = server_name
            __props__.__dict__["server_owner"] = server_owner
            __props__.__dict__["server_type"] = server_type
            __props__.__dict__["server_version"] = server_version
        super(Server, __self__).__init__(
            'postgresql:index/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            drop_cascade: Optional[pulumi.Input[bool]] = None,
            fdw_name: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            server_name: Optional[pulumi.Input[str]] = None,
            server_owner: Optional[pulumi.Input[str]] = None,
            server_type: Optional[pulumi.Input[str]] = None,
            server_version: Optional[pulumi.Input[str]] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] drop_cascade: When true, will drop objects that depend on the server (such as user mappings), and in turn all objects that depend on those objects . (Default: false)
        :param pulumi.Input[str] fdw_name: The name of the foreign-data wrapper that manages the server.
               Changing this value
               will force the creation of a new resource as this value can only be set
               when the foreign server is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] options: This clause specifies the options for the server. The options typically define the connection details of the server, but the actual names and values are dependent on the server's foreign-data wrapper.
        :param pulumi.Input[str] server_name: The name of the foreign server to be created.
        :param pulumi.Input[str] server_owner: By default, the user who defines the server becomes its owner. Set this value to configure the new owner of the foreign server.
        :param pulumi.Input[str] server_type: Optional server type, potentially useful to foreign-data wrappers.
               Changing this value
               will force the creation of a new resource as this value can only be set
               when the foreign server is created.
        :param pulumi.Input[str] server_version: Optional server version, potentially useful to foreign-data wrappers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerState.__new__(_ServerState)

        __props__.__dict__["drop_cascade"] = drop_cascade
        __props__.__dict__["fdw_name"] = fdw_name
        __props__.__dict__["options"] = options
        __props__.__dict__["server_name"] = server_name
        __props__.__dict__["server_owner"] = server_owner
        __props__.__dict__["server_type"] = server_type
        __props__.__dict__["server_version"] = server_version
        return Server(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dropCascade")
    def drop_cascade(self) -> pulumi.Output[Optional[bool]]:
        """
        When true, will drop objects that depend on the server (such as user mappings), and in turn all objects that depend on those objects . (Default: false)
        """
        return pulumi.get(self, "drop_cascade")

    @property
    @pulumi.getter(name="fdwName")
    def fdw_name(self) -> pulumi.Output[str]:
        """
        The name of the foreign-data wrapper that manages the server.
        Changing this value
        will force the creation of a new resource as this value can only be set
        when the foreign server is created.
        """
        return pulumi.get(self, "fdw_name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        This clause specifies the options for the server. The options typically define the connection details of the server, but the actual names and values are dependent on the server's foreign-data wrapper.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Output[str]:
        """
        The name of the foreign server to be created.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="serverOwner")
    def server_owner(self) -> pulumi.Output[str]:
        """
        By default, the user who defines the server becomes its owner. Set this value to configure the new owner of the foreign server.
        """
        return pulumi.get(self, "server_owner")

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> pulumi.Output[Optional[str]]:
        """
        Optional server type, potentially useful to foreign-data wrappers.
        Changing this value
        will force the creation of a new resource as this value can only be set
        when the foreign server is created.
        """
        return pulumi.get(self, "server_type")

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> pulumi.Output[Optional[str]]:
        """
        Optional server version, potentially useful to foreign-data wrappers.
        """
        return pulumi.get(self, "server_version")

