# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.timestamp import Timestamp
from ...base.types.url_string import UrlString
from .certificate import Certificate
from .sso_auth_protocol_id import SsoAuthProtocolId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Sso(pydantic.BaseModel):
    """
    The Single Sign-On (SSO) object provides a structure for normalizing SSO attributes, configuration, and/or settings from Identity Providers.
    """

    auth_protocol: typing.Optional[str] = pydantic.Field(default=None)
    """
    The authorization protocol as defined by the caption of <code>auth_protocol_id</code>. In the case of <code>Other</code>, it is defined by the event source.
    """

    auth_protocol_id: typing.Optional[SsoAuthProtocolId] = pydantic.Field(default=None)
    """
    The normalized identifier of the authentication protocol used by the SSO resource.
    """

    certificate: typing.Optional[Certificate] = pydantic.Field(default=None)
    """
    Digital Signature associated with the SSO resource, e.g., SAML X.509 certificate details.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    When the SSO resource was created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the SSO resource was created.
    """

    duration_mins: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration (in minutes) for an SSO session, after which re-authentication is required.
    """

    idle_timeout: typing.Optional[int] = pydantic.Field(default=None)
    """
    Duration (in minutes) of allowed inactivity before Single Sign-On (SSO) session expiration.
    """

    login_endpoint: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    URL for initiating an SSO login request.
    """

    logout_endpoint: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    URL for initiating an SSO logout request, allowing sessions to be terminated across applications.
    """

    metadata_endpoint: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    URL where metadata about the SSO configuration is available (e.g., for SAML configurations).
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The most recent time when the SSO resource was updated.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The most recent time when the SSO resource was updated.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the SSO resource.
    """

    protocol_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The supported protocol for the SSO resource. E.g., <code>SAML</code> or <code>OIDC</code>.
    """

    scopes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Scopes define the specific permissions or actions that the client is allowed to perform on behalf of the user. Each scope represents a different set of permissions, and the user can selectively grant or deny access to specific scopes during the authorization process.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier for a SSO resource.
    """

    vendor_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the vendor or service provider implementing SSO. E.g., <code>Okta</code>, <code>Auth0</code>, <code>Microsoft</code>.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
