# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ......core.datetime_utils import serialize_datetime
from ...common.types.common_properties import CommonProperties
from ...common.types.kill_chain_phase import KillChainPhase
from ...common.types.software import Software
from ...open_vocab.types.implementation_language_ov import ImplementationLanguageOv
from ...open_vocab.types.malware_capabilities_ov import MalwareCapabilitiesOv
from ...open_vocab.types.malware_type_ov import MalwareTypeOv
from ...open_vocab.types.processor_architecture_ov import ProcessorArchitectureOv

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Malware(CommonProperties):
    type: typing.Literal["malware"]
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A description that provides more details and context about the Malware, potentially including its purpose and its key characteristics.
    """

    malware_types: typing.Optional[typing.List[MalwareTypeOv]] = pydantic.Field(default=None)
    """
    A set of categorizations for this malware.
    """

    is_family: bool = pydantic.Field()
    """
    Whether the object represents a malware family (if true) or a malware instance (if false).
    """

    aliases: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Alternative names used to identify this malware or malware family.
    """

    kill_chain_phases: typing.Optional[typing.List[KillChainPhase]] = None
    first_seen: typing.Optional[dt.datetime] = None
    last_seen: typing.Optional[dt.datetime] = None
    operating_system_refs: typing.Optional[typing.List[Software]] = pydantic.Field(default=None)
    """
    The operating systems that the malware family or malware instance is executable on. This applies to virtualized operating systems as well as those running on bare metal.
    """

    architecture_execution_envs: typing.Optional[typing.List[ProcessorArchitectureOv]] = None
    implementation_languages: typing.Optional[typing.List[ImplementationLanguageOv]] = None
    capabilities: typing.Optional[typing.List[MalwareCapabilitiesOv]] = None

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
