# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .teams_credential import TeamsCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class NotificationsTeams(pydantic.BaseModel):
    """
    Configuration for Microsoft Teams.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/teams-notification-setup)
    """

    channel_id: str = pydantic.Field()
    """
    Identifier of the channel to send messages to.
    """

    credential: TeamsCredential
    endpoint: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL of the endpoint to send messages to. Only required if OAuth Client Credentials are used for authentication.
    """

    team_id: str = pydantic.Field()
    """
    Identifier of the team to send messages to.
    """

    tenant_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Azure Directory (tenant) ID. Only required if OAuth Client Credentials are used for authentication.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
