# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .crowd_strike_credential import CrowdStrikeCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class VulnerabilitiesCrowdStrike(pydantic.BaseModel):
    """
    Configuration for CrowdStrike Falcon® Spotlight.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/crowdstrike-vulns-setup)
    """

    credential: CrowdStrikeCredential = pydantic.Field()
    """
    The credential to use for the CrowdStrike Falcon tenant.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the CrowdStrike Falcon® Spotlight API.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
