# Generated by ariadne-codegen
# Source: src/queries

from typing import Any, List, Literal, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    Existence,
    ProgramType,
    ProposalStatus,
    ScienceBand,
    ScienceSubtype,
    TimeAccountingCategory,
)


class GetPrograms(BaseModel):
    programs: "GetProgramsPrograms"


class GetProgramsPrograms(BaseModel):
    matches: List["GetProgramsProgramsMatches"]


class GetProgramsProgramsMatches(BaseModel):
    id: Any
    name: Optional[Any]
    description: Optional[Any]
    existence: Existence
    type: ProgramType
    active: "GetProgramsProgramsMatchesActive"
    proposal_status: ProposalStatus = Field(alias="proposalStatus")
    proposal: Optional["GetProgramsProgramsMatchesProposal"]
    allocations: List["GetProgramsProgramsMatchesAllocations"]
    time_charge: List["GetProgramsProgramsMatchesTimeCharge"] = Field(
        alias="timeCharge"
    )
    all_group_elements: List["GetProgramsProgramsMatchesAllGroupElements"] = Field(
        alias="allGroupElements"
    )


class GetProgramsProgramsMatchesActive(BaseModel):
    start: Any
    end: Any


class GetProgramsProgramsMatchesProposal(BaseModel):
    type: "GetProgramsProgramsMatchesProposalType"
    call: Optional["GetProgramsProgramsMatchesProposalCall"]


class GetProgramsProgramsMatchesProposalType(BaseModel):
    typename__: Literal[
        "Classical",
        "DemoScience",
        "DirectorsTime",
        "FastTurnaround",
        "LargeProgram",
        "PoorWeather",
        "ProposalType",
        "Queue",
        "SystemVerification",
    ] = Field(alias="__typename")
    science_subtype: ScienceSubtype = Field(alias="scienceSubtype")


class GetProgramsProgramsMatchesProposalCall(BaseModel):
    active: "GetProgramsProgramsMatchesProposalCallActive"
    semester: Any


class GetProgramsProgramsMatchesProposalCallActive(BaseModel):
    start: Any
    end: Any


class GetProgramsProgramsMatchesAllocations(BaseModel):
    category: TimeAccountingCategory
    duration: "GetProgramsProgramsMatchesAllocationsDuration"
    science_band: ScienceBand = Field(alias="scienceBand")


class GetProgramsProgramsMatchesAllocationsDuration(BaseModel):
    hours: Any


class GetProgramsProgramsMatchesTimeCharge(BaseModel):
    band: Optional[ScienceBand]
    time: "GetProgramsProgramsMatchesTimeChargeTime"


class GetProgramsProgramsMatchesTimeChargeTime(BaseModel):
    program: "GetProgramsProgramsMatchesTimeChargeTimeProgram"
    total: "GetProgramsProgramsMatchesTimeChargeTimeTotal"
    non_charged: "GetProgramsProgramsMatchesTimeChargeTimeNonCharged" = Field(
        alias="nonCharged"
    )


class GetProgramsProgramsMatchesTimeChargeTimeProgram(BaseModel):
    hours: Any


class GetProgramsProgramsMatchesTimeChargeTimeTotal(BaseModel):
    hours: Any


class GetProgramsProgramsMatchesTimeChargeTimeNonCharged(BaseModel):
    hours: Any


class GetProgramsProgramsMatchesAllGroupElements(BaseModel):
    parent_group_id: Optional[Any] = Field(alias="parentGroupId")
    group: Optional["GetProgramsProgramsMatchesAllGroupElementsGroup"]
    observation: Optional["GetProgramsProgramsMatchesAllGroupElementsObservation"]


class GetProgramsProgramsMatchesAllGroupElementsGroup(BaseModel):
    id: Any
    name: Optional[Any]
    minimum_required: Optional[Any] = Field(alias="minimumRequired")
    ordered: bool
    parent_id: Optional[Any] = Field(alias="parentId")
    parent_index: Any = Field(alias="parentIndex")
    minimum_interval: Optional[
        "GetProgramsProgramsMatchesAllGroupElementsGroupMinimumInterval"
    ] = Field(alias="minimumInterval")
    maximum_interval: Optional[
        "GetProgramsProgramsMatchesAllGroupElementsGroupMaximumInterval"
    ] = Field(alias="maximumInterval")


class GetProgramsProgramsMatchesAllGroupElementsGroupMinimumInterval(BaseModel):
    seconds: Any


class GetProgramsProgramsMatchesAllGroupElementsGroupMaximumInterval(BaseModel):
    seconds: Any


class GetProgramsProgramsMatchesAllGroupElementsObservation(BaseModel):
    id: Any
    group_id: Optional[Any] = Field(alias="groupId")


GetPrograms.model_rebuild()
GetProgramsPrograms.model_rebuild()
GetProgramsProgramsMatches.model_rebuild()
GetProgramsProgramsMatchesProposal.model_rebuild()
GetProgramsProgramsMatchesProposalCall.model_rebuild()
GetProgramsProgramsMatchesAllocations.model_rebuild()
GetProgramsProgramsMatchesTimeCharge.model_rebuild()
GetProgramsProgramsMatchesTimeChargeTime.model_rebuild()
GetProgramsProgramsMatchesAllGroupElements.model_rebuild()
GetProgramsProgramsMatchesAllGroupElementsGroup.model_rebuild()
