# Generated by ariadne-codegen
# Source: schema.graphql

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    ArcType,
    AtomStage,
    AttachmentType,
    Band,
    BrightnessIntegratedUnits,
    BrightnessSurfaceUnits,
    CalculationState,
    CalibrationRole,
    CallForProposalsType,
    CatalogName,
    ChargeClass,
    CloudExtinctionPreset,
    ConditionsExpectationType,
    ConditionsMeasurementSource,
    ConfigurationRequestStatus,
    CoolStarTemperature,
    DatabaseOperation,
    DatasetQaState,
    DatasetStage,
    EducationalStatus,
    EphemerisKeyType,
    ExecutionEventType,
    Existence,
    Flamingos2CustomSlitWidth,
    Flamingos2Decker,
    Flamingos2Disperser,
    Flamingos2Filter,
    Flamingos2Fpu,
    Flamingos2LyotWheel,
    Flamingos2ReadMode,
    Flamingos2ReadoutMode,
    Flamingos2Reads,
    FluxDensityContinuumIntegratedUnits,
    FluxDensityContinuumSurfaceUnits,
    FocalPlane,
    GalaxySpectrum,
    GcalArc,
    GcalContinuum,
    GcalDiffuser,
    GcalFilter,
    GcalShutter,
    Gender,
    GmosAmpCount,
    GmosAmpGain,
    GmosAmpReadMode,
    GmosBinning,
    GmosCustomSlitWidth,
    GmosDtax,
    GmosEOffsetting,
    GmosGratingOrder,
    GmosNorthBuiltinFpu,
    GmosNorthDetector,
    GmosNorthFilter,
    GmosNorthGrating,
    GmosNorthStageMode,
    GmosRoi,
    GmosSouthBuiltinFpu,
    GmosSouthDetector,
    GmosSouthFilter,
    GmosSouthGrating,
    GmosSouthStageMode,
    GuideState,
    HiiRegionSpectrum,
    Ignore,
    ImageQualityPreset,
    Instrument,
    LineFluxIntegratedUnits,
    LineFluxSurfaceUnits,
    MosPreImaging,
    MultipleFiltersMode,
    ObservationWorkflowState,
    ObserveClass,
    Partner,
    PartnerLinkType,
    PlanetaryNebulaSpectrum,
    PlanetSpectrum,
    PosAngleConstraintMode,
    ProgramType,
    ProgramUserRole,
    ProposalStatus,
    QuasarSpectrum,
    ScienceBand,
    ScienceSubtype,
    SeeingTrend,
    SequenceCommand,
    SequenceType,
    Site,
    SkyBackground,
    SlewStage,
    SmartGcalType,
    SpectroscopyCapabilities,
    StellarLibrarySpectrum,
    StepStage,
    TacCategory,
    TimeAccountingCategory,
    TimeChargeCorrectionOp,
    TimingWindowInclusion,
    ToOActivation,
    UserType,
    WaterVapor,
)


class AddAtomEventInput(BaseModel):
    atom_id: Any = Field(alias=str("atomId"))
    atom_stage: AtomStage = Field(alias=str("atomStage"))
    client_id: Optional[Any] = Field(alias=str("clientId"), default=None)


class AddDatasetEventInput(BaseModel):
    dataset_id: Any = Field(alias=str("datasetId"))
    dataset_stage: DatasetStage = Field(alias=str("datasetStage"))
    client_id: Optional[Any] = Field(alias=str("clientId"), default=None)


class AddProgramUserInput(BaseModel):
    program_id: Any = Field(alias=str("programId"))
    role: ProgramUserRole
    set: Optional["ProgramUserPropertiesInput"] = Field(alias=str("SET"), default=None)


class AddSequenceEventInput(BaseModel):
    visit_id: Any = Field(alias=str("visitId"))
    command: SequenceCommand
    client_id: Optional[Any] = Field(alias=str("clientId"), default=None)


class AddSlewEventInput(BaseModel):
    observation_id: Any = Field(alias=str("observationId"))
    slew_stage: SlewStage = Field(alias=str("slewStage"))
    client_id: Optional[Any] = Field(alias=str("clientId"), default=None)


class AddStepEventInput(BaseModel):
    step_id: Any = Field(alias=str("stepId"))
    step_stage: StepStage = Field(alias=str("stepStage"))
    client_id: Optional[Any] = Field(alias=str("clientId"), default=None)


class AddTimeChargeCorrectionInput(BaseModel):
    visit_id: Any = Field(alias=str("visitId"))
    correction: "TimeChargeCorrectionInput"


class AirMassRangeInput(BaseModel):
    min: Optional[Any] = None
    max: Optional[Any] = None


class AllocationInput(BaseModel):
    category: TimeAccountingCategory
    science_band: ScienceBand = Field(alias=str("scienceBand"))
    duration: "TimeSpanInput"


class AngleInput(BaseModel):
    microarcseconds: Optional[Any] = None
    microseconds: Optional[Any] = None
    milliarcseconds: Optional[Any] = None
    milliseconds: Optional[Any] = None
    arcseconds: Optional[Any] = None
    seconds: Optional[Any] = None
    arcminutes: Optional[Any] = None
    minutes: Optional[Any] = None
    degrees: Optional[Any] = None
    hours: Optional[Any] = None
    dms: Optional[str] = None
    hms: Optional[str] = None


class BandBrightnessIntegratedInput(BaseModel):
    band: Band
    value: Optional[Any] = None
    units: Optional[BrightnessIntegratedUnits] = None
    error: Optional[Any] = None


class BandBrightnessSurfaceInput(BaseModel):
    band: Band
    value: Optional[Any] = None
    units: Optional[BrightnessSurfaceUnits] = None
    error: Optional[Any] = None


class BandNormalizedIntegratedInput(BaseModel):
    sed: Optional["UnnormalizedSedInput"] = None
    brightnesses: Optional[List["BandBrightnessIntegratedInput"]] = None


class BandNormalizedSurfaceInput(BaseModel):
    sed: Optional["UnnormalizedSedInput"] = None
    brightnesses: Optional[List["BandBrightnessSurfaceInput"]] = None


class CallForProposalsPropertiesInput(BaseModel):
    type: Optional[CallForProposalsType] = None
    semester: Optional[Any] = None
    title: Optional[Any] = None
    coordinate_limits: Optional["SiteCoordinateLimitsInput"] = Field(
        alias=str("coordinateLimits"), default=None
    )
    active_start: Optional[Any] = Field(alias=str("activeStart"), default=None)
    active_end: Optional[Any] = Field(alias=str("activeEnd"), default=None)
    submission_deadline_default: Optional[Any] = Field(
        alias=str("submissionDeadlineDefault"), default=None
    )
    partners: Optional[List["CallForProposalsPartnerInput"]] = None
    instruments: Optional[List[Instrument]] = None
    proprietary_months: Optional[Any] = Field(
        alias=str("proprietaryMonths"), default=None
    )
    existence: Optional[Existence] = None


class SiteCoordinateLimitsInput(BaseModel):
    north: Optional["CoordinateLimitsInput"] = None
    south: Optional["CoordinateLimitsInput"] = None


class CoordinateLimitsInput(BaseModel):
    ra_start: Optional["RightAscensionInput"] = Field(
        alias=str("raStart"), default=None
    )
    ra_end: Optional["RightAscensionInput"] = Field(alias=str("raEnd"), default=None)
    dec_start: Optional["DeclinationInput"] = Field(alias=str("decStart"), default=None)
    dec_end: Optional["DeclinationInput"] = Field(alias=str("decEnd"), default=None)


class CallForProposalsPartnerInput(BaseModel):
    partner: Partner
    submission_deadline_override: Optional[Any] = Field(
        alias=str("submissionDeadlineOverride"), default=None
    )


class CatalogInfoInput(BaseModel):
    name: Optional[CatalogName] = None
    id: Optional[Any] = None
    object_type: Optional[Any] = Field(alias=str("objectType"), default=None)


class ChangeProgramUserRoleInput(BaseModel):
    program_user_id: Any = Field(alias=str("programUserId"))
    new_role: ProgramUserRole = Field(alias=str("newRole"))


class CloneObservationInput(BaseModel):
    observation_id: Optional[Any] = Field(alias=str("observationId"), default=None)
    observation_reference: Optional[Any] = Field(
        alias=str("observationReference"), default=None
    )
    set: Optional["ObservationPropertiesInput"] = Field(alias=str("SET"), default=None)


class CloneTargetInput(BaseModel):
    target_id: Any = Field(alias=str("targetId"))
    set: Optional["TargetPropertiesInput"] = Field(alias=str("SET"), default=None)
    replace_in: Optional[List[Any]] = Field(alias=str("REPLACE_IN"), default=None)


class ConstraintSetInput(BaseModel):
    image_quality: Optional[ImageQualityPreset] = Field(
        alias=str("imageQuality"), default=None
    )
    cloud_extinction: Optional[CloudExtinctionPreset] = Field(
        alias=str("cloudExtinction"), default=None
    )
    sky_background: Optional[SkyBackground] = Field(
        alias=str("skyBackground"), default=None
    )
    water_vapor: Optional[WaterVapor] = Field(alias=str("waterVapor"), default=None)
    elevation_range: Optional["ElevationRangeInput"] = Field(
        alias=str("elevationRange"), default=None
    )


class ConditionsEntryInput(BaseModel):
    measurement: Optional["ConditionsMeasurementInput"] = None
    intuition: Optional["ConditionsIntuitionInput"] = None


class ConditionsMeasurementInput(BaseModel):
    source: ConditionsMeasurementSource
    seeing: Optional["AngleInput"] = None
    extinction: Optional[Any] = None
    wavelength: Optional["WavelengthInput"] = None
    azimuth: Optional["AngleInput"] = None
    elevation: Optional["AngleInput"] = None


class ConditionsIntuitionInput(BaseModel):
    expectation: Optional["ConditionsExpectationInput"] = None
    seeing_trend: Optional[SeeingTrend] = Field(alias=str("seeingTrend"), default=None)


class ConditionsExpectationInput(BaseModel):
    type: ConditionsExpectationType
    timeframe: "TimeSpanInput"


class CoordinatesInput(BaseModel):
    ra: Optional["RightAscensionInput"] = None
    dec: Optional["DeclinationInput"] = None


class CreateCallForProposalsInput(BaseModel):
    set: Optional["CallForProposalsPropertiesInput"] = Field(
        alias=str("SET"), default=None
    )


class CreateObservationInput(BaseModel):
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)
    proposal_reference: Optional[Any] = Field(
        alias=str("proposalReference"), default=None
    )
    program_reference: Optional[Any] = Field(
        alias=str("programReference"), default=None
    )
    set: Optional["ObservationPropertiesInput"] = Field(alias=str("SET"), default=None)


class CreateProgramInput(BaseModel):
    set: Optional["ProgramPropertiesInput"] = Field(alias=str("SET"), default=None)


class CreateProgramNoteInput(BaseModel):
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)
    proposal_reference: Optional[Any] = Field(
        alias=str("proposalReference"), default=None
    )
    program_reference: Optional[Any] = Field(
        alias=str("programReference"), default=None
    )
    set: "ProgramNotePropertiesInput" = Field(alias=str("SET"))


class CreateProposalInput(BaseModel):
    program_id: Any = Field(alias=str("programId"))
    set: "ProposalPropertiesInput" = Field(alias=str("SET"))


class CreateTargetInput(BaseModel):
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)
    proposal_reference: Optional[Any] = Field(
        alias=str("proposalReference"), default=None
    )
    program_reference: Optional[Any] = Field(
        alias=str("programReference"), default=None
    )
    set: "TargetPropertiesInput" = Field(alias=str("SET"))


class DatasetPropertiesInput(BaseModel):
    qa_state: Optional[DatasetQaState] = Field(alias=str("qaState"), default=None)
    comment: Optional[Any] = None


class DeclinationInput(BaseModel):
    microarcseconds: Optional[Any] = None
    degrees: Optional[Any] = None
    dms: Optional[Any] = None


class DeleteProgramUserInput(BaseModel):
    program_user_id: Any = Field(alias=str("programUserId"))


class DeleteProposalInput(BaseModel):
    program_id: Any = Field(alias=str("programId"))


class EditAsterismsPatchInput(BaseModel):
    add: Optional[List[Any]] = Field(alias=str("ADD"), default=None)
    delete: Optional[List[Any]] = Field(alias=str("DELETE"), default=None)


class ElevationRangeInput(BaseModel):
    air_mass: Optional["AirMassRangeInput"] = Field(alias=str("airMass"), default=None)
    hour_angle: Optional["HourAngleRangeInput"] = Field(
        alias=str("hourAngle"), default=None
    )


class EmissionLineIntegratedInput(BaseModel):
    wavelength: "WavelengthInput"
    line_width: Optional[Any] = Field(alias=str("lineWidth"), default=None)
    line_flux: Optional["LineFluxIntegratedInput"] = Field(
        alias=str("lineFlux"), default=None
    )


class EmissionLineSurfaceInput(BaseModel):
    wavelength: "WavelengthInput"
    line_width: Optional[Any] = Field(alias=str("lineWidth"), default=None)
    line_flux: Optional["LineFluxSurfaceInput"] = Field(
        alias=str("lineFlux"), default=None
    )


class EmissionLinesIntegratedInput(BaseModel):
    lines: Optional[List["EmissionLineIntegratedInput"]] = None
    flux_density_continuum: Optional["FluxDensityContinuumIntegratedInput"] = Field(
        alias=str("fluxDensityContinuum"), default=None
    )


class EmissionLinesSurfaceInput(BaseModel):
    lines: Optional[List["EmissionLineSurfaceInput"]] = None
    flux_density_continuum: Optional["FluxDensityContinuumSurfaceInput"] = Field(
        alias=str("fluxDensityContinuum"), default=None
    )


class ExposureTimeModeInput(BaseModel):
    signal_to_noise: Optional["SignalToNoiseExposureTimeModeInput"] = Field(
        alias=str("signalToNoise"), default=None
    )
    time_and_count: Optional["TimeAndCountExposureTimeModeInput"] = Field(
        alias=str("timeAndCount"), default=None
    )


class TimeAndCountExposureTimeModeInput(BaseModel):
    time: "TimeSpanInput"
    count: Any
    at: "WavelengthInput"


class FluxDensity(BaseModel):
    wavelength: "WavelengthInput"
    density: Any


class FluxDensityContinuumIntegratedInput(BaseModel):
    value: Any
    units: FluxDensityContinuumIntegratedUnits
    error: Optional[Any] = None


class FluxDensityContinuumSurfaceInput(BaseModel):
    value: Any
    units: FluxDensityContinuumSurfaceUnits
    error: Optional[Any] = None


class GaussianInput(BaseModel):
    fwhm: Optional["AngleInput"] = None
    spectral_definition: Optional["SpectralDefinitionIntegratedInput"] = Field(
        alias=str("spectralDefinition"), default=None
    )


class GmosCcdModeInput(BaseModel):
    x_bin: Optional[GmosBinning] = Field(alias=str("xBin"), default=None)
    y_bin: Optional[GmosBinning] = Field(alias=str("yBin"), default=None)
    amp_count: Optional[GmosAmpCount] = Field(alias=str("ampCount"), default=None)
    amp_gain: Optional[GmosAmpGain] = Field(alias=str("ampGain"), default=None)
    amp_read_mode: Optional[GmosAmpReadMode] = Field(
        alias=str("ampReadMode"), default=None
    )


class GmosCustomMaskInput(BaseModel):
    filename: str
    slit_width: GmosCustomSlitWidth = Field(alias=str("slitWidth"))


class GmosNodAndShuffleInput(BaseModel):
    pos_a: "OffsetInput" = Field(alias=str("posA"))
    pos_b: "OffsetInput" = Field(alias=str("posB"))
    e_offset: GmosEOffsetting = Field(alias=str("eOffset"))
    shuffle_offset: Any = Field(alias=str("shuffleOffset"))
    shuffle_cycles: Any = Field(alias=str("shuffleCycles"))


class GmosNorthDynamicInput(BaseModel):
    exposure: "TimeSpanInput"
    readout: "GmosCcdModeInput"
    dtax: GmosDtax
    roi: GmosRoi
    grating_config: Optional["GmosNorthGratingConfigInput"] = Field(
        alias=str("gratingConfig"), default=None
    )
    filter: Optional[GmosNorthFilter] = None
    fpu: Optional["GmosNorthFpuInput"] = None


class GmosNorthFpuInput(BaseModel):
    custom_mask: Optional["GmosCustomMaskInput"] = Field(
        alias=str("customMask"), default=None
    )
    builtin: Optional[GmosNorthBuiltinFpu] = None


class GmosNorthGratingConfigInput(BaseModel):
    grating: GmosNorthGrating
    order: GmosGratingOrder
    wavelength: "WavelengthInput"


class GmosNorthLongSlitInput(BaseModel):
    grating: Optional[GmosNorthGrating] = None
    filter: Optional[GmosNorthFilter] = None
    fpu: Optional[GmosNorthBuiltinFpu] = None
    central_wavelength: Optional["WavelengthInput"] = Field(
        alias=str("centralWavelength"), default=None
    )
    explicit_x_bin: Optional[GmosBinning] = Field(
        alias=str("explicitXBin"), default=None
    )
    explicit_y_bin: Optional[GmosBinning] = Field(
        alias=str("explicitYBin"), default=None
    )
    explicit_amp_read_mode: Optional[GmosAmpReadMode] = Field(
        alias=str("explicitAmpReadMode"), default=None
    )
    explicit_amp_gain: Optional[GmosAmpGain] = Field(
        alias=str("explicitAmpGain"), default=None
    )
    explicit_roi: Optional[GmosRoi] = Field(alias=str("explicitRoi"), default=None)
    explicit_wavelength_dithers: Optional[List["WavelengthDitherInput"]] = Field(
        alias=str("explicitWavelengthDithers"), default=None
    )
    explicit_spatial_offsets: Optional[List["OffsetComponentInput"]] = Field(
        alias=str("explicitSpatialOffsets"), default=None
    )


class GmosNorthImagingInput(BaseModel):
    filters: Optional[List[GmosNorthFilter]] = None
    offsets: Optional[List["OffsetInput"]] = None
    explicit_multiple_filters_mode: Optional[MultipleFiltersMode] = Field(
        alias=str("explicitMultipleFiltersMode"), default=None
    )
    explicit_bin: Optional[GmosBinning] = Field(alias=str("explicitBin"), default=None)
    explicit_amp_read_mode: Optional[GmosAmpReadMode] = Field(
        alias=str("explicitAmpReadMode"), default=None
    )
    explicit_amp_gain: Optional[GmosAmpGain] = Field(
        alias=str("explicitAmpGain"), default=None
    )
    explicit_roi: Optional[GmosRoi] = Field(alias=str("explicitRoi"), default=None)


class GmosNorthStaticInput(BaseModel):
    stage_mode: Optional[GmosNorthStageMode] = Field(
        alias=str("stageMode"), default=None
    )
    detector: Optional[GmosNorthDetector] = None
    mos_pre_imaging: Optional[MosPreImaging] = Field(
        alias=str("mosPreImaging"), default=None
    )
    nod_and_shuffle: Optional["GmosNodAndShuffleInput"] = Field(
        alias=str("nodAndShuffle"), default=None
    )


class GmosSouthDynamicInput(BaseModel):
    exposure: "TimeSpanInput"
    readout: "GmosCcdModeInput"
    dtax: GmosDtax
    roi: GmosRoi
    grating_config: Optional["GmosSouthGratingConfigInput"] = Field(
        alias=str("gratingConfig"), default=None
    )
    filter: Optional[GmosSouthFilter] = None
    fpu: Optional["GmosSouthFpuInput"] = None


class GmosSouthFpuInput(BaseModel):
    custom_mask: Optional["GmosCustomMaskInput"] = Field(
        alias=str("customMask"), default=None
    )
    builtin: Optional[GmosSouthBuiltinFpu] = None


class GmosSouthGratingConfigInput(BaseModel):
    grating: GmosSouthGrating
    order: GmosGratingOrder
    wavelength: "WavelengthInput"


class GmosSouthLongSlitInput(BaseModel):
    grating: Optional[GmosSouthGrating] = None
    filter: Optional[GmosSouthFilter] = None
    fpu: Optional[GmosSouthBuiltinFpu] = None
    central_wavelength: Optional["WavelengthInput"] = Field(
        alias=str("centralWavelength"), default=None
    )
    explicit_x_bin: Optional[GmosBinning] = Field(
        alias=str("explicitXBin"), default=None
    )
    explicit_y_bin: Optional[GmosBinning] = Field(
        alias=str("explicitYBin"), default=None
    )
    explicit_amp_read_mode: Optional[GmosAmpReadMode] = Field(
        alias=str("explicitAmpReadMode"), default=None
    )
    explicit_amp_gain: Optional[GmosAmpGain] = Field(
        alias=str("explicitAmpGain"), default=None
    )
    explicit_roi: Optional[GmosRoi] = Field(alias=str("explicitRoi"), default=None)
    explicit_wavelength_dithers: Optional[List["WavelengthDitherInput"]] = Field(
        alias=str("explicitWavelengthDithers"), default=None
    )
    explicit_spatial_offsets: Optional[List["OffsetComponentInput"]] = Field(
        alias=str("explicitSpatialOffsets"), default=None
    )


class GmosSouthImagingInput(BaseModel):
    filters: Optional[List[GmosSouthFilter]] = None
    offsets: Optional[List["OffsetInput"]] = None
    explicit_multiple_filters_mode: Optional[MultipleFiltersMode] = Field(
        alias=str("explicitMultipleFiltersMode"), default=None
    )
    explicit_bin: Optional[GmosBinning] = Field(alias=str("explicitBin"), default=None)
    explicit_amp_read_mode: Optional[GmosAmpReadMode] = Field(
        alias=str("explicitAmpReadMode"), default=None
    )
    explicit_amp_gain: Optional[GmosAmpGain] = Field(
        alias=str("explicitAmpGain"), default=None
    )
    explicit_roi: Optional[GmosRoi] = Field(alias=str("explicitRoi"), default=None)


class GmosSouthStaticInput(BaseModel):
    stage_mode: Optional[GmosSouthStageMode] = Field(
        alias=str("stageMode"), default=None
    )
    detector: Optional[GmosSouthDetector] = None
    mos_pre_imaging: Optional[MosPreImaging] = Field(
        alias=str("mosPreImaging"), default=None
    )
    nod_and_shuffle: Optional["GmosNodAndShuffleInput"] = Field(
        alias=str("nodAndShuffle"), default=None
    )


class CloneGroupInput(BaseModel):
    group_id: Any = Field(alias=str("groupId"))
    set: Optional["GroupPropertiesInput"] = Field(alias=str("SET"), default=None)


class HourAngleRangeInput(BaseModel):
    min_hours: Optional[Any] = Field(alias=str("minHours"), default=None)
    max_hours: Optional[Any] = Field(alias=str("maxHours"), default=None)


class LineFluxIntegratedInput(BaseModel):
    value: Any
    units: LineFluxIntegratedUnits


class LineFluxSurfaceInput(BaseModel):
    value: Any
    units: LineFluxSurfaceUnits


class LinkUserInput(BaseModel):
    program_user_id: Any = Field(alias=str("programUserId"))
    user_id: Any = Field(alias=str("userId"))


class CreateUserInvitationInput(BaseModel):
    program_user_id: Any = Field(alias=str("programUserId"))
    recipient_email: Any = Field(alias=str("recipientEmail"))


class RedeemUserInvitationInput(BaseModel):
    key: Any
    accept: Optional[bool] = True


class RevokeUserInvitationInput(BaseModel):
    id: Any


class SetObservationWorkflowStateInput(BaseModel):
    observation_id: Any = Field(alias=str("observationId"))
    state: ObservationWorkflowState


class NonsiderealInput(BaseModel):
    key_type: Optional[EphemerisKeyType] = Field(alias=str("keyType"), default=None)
    des: Optional[Any] = None
    key: Optional[Any] = None


class ConfigurationRequestProperties(BaseModel):
    status: Optional[ConfigurationRequestStatus] = None
    justification: Optional[Any] = None


class ObservationPropertiesInput(BaseModel):
    subtitle: Optional[Any] = None
    science_band: Optional[ScienceBand] = Field(alias=str("scienceBand"), default=None)
    pos_angle_constraint: Optional["PosAngleConstraintInput"] = Field(
        alias=str("posAngleConstraint"), default=None
    )
    target_environment: Optional["TargetEnvironmentInput"] = Field(
        alias=str("targetEnvironment"), default=None
    )
    constraint_set: Optional["ConstraintSetInput"] = Field(
        alias=str("constraintSet"), default=None
    )
    timing_windows: Optional[List["TimingWindowInput"]] = Field(
        alias=str("timingWindows"), default=None
    )
    attachments: Optional[List[Any]] = None
    science_requirements: Optional["ScienceRequirementsInput"] = Field(
        alias=str("scienceRequirements"), default=None
    )
    observing_mode: Optional["ObservingModeInput"] = Field(
        alias=str("observingMode"), default=None
    )
    existence: Optional[Existence] = None
    group_id: Optional[Any] = Field(alias=str("groupId"), default=None)
    group_index: Optional[Any] = Field(alias=str("groupIndex"), default=None)
    observer_notes: Optional[Any] = Field(alias=str("observerNotes"), default=None)


class ObservationTimesInput(BaseModel):
    observation_time: Optional[Any] = Field(alias=str("observationTime"), default=None)
    observation_duration: Optional["TimeSpanInput"] = Field(
        alias=str("observationDuration"), default=None
    )


class OffsetComponentInput(BaseModel):
    microarcseconds: Optional[Any] = None
    milliarcseconds: Optional[Any] = None
    arcseconds: Optional[Any] = None


class OffsetInput(BaseModel):
    p: "OffsetComponentInput"
    q: "OffsetComponentInput"


class ParallaxInput(BaseModel):
    microarcseconds: Optional[Any] = None
    milliarcseconds: Optional[Any] = None


class PartnerLinkInput(BaseModel):
    link_type: Optional[PartnerLinkType] = Field(alias=str("linkType"), default=None)
    partner: Optional[Partner] = None


class PartnerSplitInput(BaseModel):
    partner: Partner
    percent: Any


class PosAngleConstraintInput(BaseModel):
    mode: Optional[PosAngleConstraintMode] = None
    angle: Optional["AngleInput"] = None


class ProgramPropertiesInput(BaseModel):
    name: Optional[Any] = None
    description: Optional[Any] = None
    goa: Optional["GoaPropertiesInput"] = None
    existence: Optional[Existence] = None
    active_start: Optional[Any] = Field(alias=str("activeStart"), default=None)
    active_end: Optional[Any] = Field(alias=str("activeEnd"), default=None)


class ProgramNotePropertiesInput(BaseModel):
    title: Optional[Any] = None
    text: Optional[Any] = None
    is_private: Optional[bool] = Field(alias=str("isPrivate"), default=None)
    existence: Optional[Existence] = None


class ProgramUserPropertiesInput(BaseModel):
    partner_link: Optional["PartnerLinkInput"] = Field(
        alias=str("partnerLink"), default=None
    )
    preferred_profile: Optional["UserProfileInput"] = Field(
        alias=str("preferredProfile"), default=None
    )
    educational_status: Optional[EducationalStatus] = Field(
        alias=str("educationalStatus"), default=None
    )
    thesis: Optional[bool] = None
    gender: Optional[Gender] = None
    affiliation: Optional[Any] = None
    has_data_access: Optional[bool] = Field(alias=str("hasDataAccess"), default=None)


class ProperMotionComponentInput(BaseModel):
    microarcseconds_per_year: Optional[Any] = Field(
        alias=str("microarcsecondsPerYear"), default=None
    )
    milliarcseconds_per_year: Optional[Any] = Field(
        alias=str("milliarcsecondsPerYear"), default=None
    )


class ProperMotionInput(BaseModel):
    ra: "ProperMotionComponentInput"
    dec: "ProperMotionComponentInput"


class ProposalTypeInput(BaseModel):
    classical: Optional["ClassicalInput"] = None
    demo_science: Optional["DemoScienceInput"] = Field(
        alias=str("demoScience"), default=None
    )
    directors_time: Optional["DirectorsTimeInput"] = Field(
        alias=str("directorsTime"), default=None
    )
    fast_turnaround: Optional["FastTurnaroundInput"] = Field(
        alias=str("fastTurnaround"), default=None
    )
    large_program: Optional["LargeProgramInput"] = Field(
        alias=str("largeProgram"), default=None
    )
    poor_weather: Optional["PoorWeatherInput"] = Field(
        alias=str("poorWeather"), default=None
    )
    queue: Optional["QueueInput"] = None
    system_verification: Optional["SystemVerificationInput"] = Field(
        alias=str("systemVerification"), default=None
    )


class ClassicalInput(BaseModel):
    min_percent_time: Optional[Any] = Field(alias=str("minPercentTime"), default=None)
    partner_splits: Optional[List["PartnerSplitInput"]] = Field(
        alias=str("partnerSplits"), default=None
    )


class DemoScienceInput(BaseModel):
    to_o_activation: Optional[ToOActivation] = Field(
        alias=str("toOActivation"), default=None
    )
    min_percent_time: Optional[Any] = Field(alias=str("minPercentTime"), default=None)


class DirectorsTimeInput(BaseModel):
    to_o_activation: Optional[ToOActivation] = Field(
        alias=str("toOActivation"), default=None
    )
    min_percent_time: Optional[Any] = Field(alias=str("minPercentTime"), default=None)


class FastTurnaroundInput(BaseModel):
    to_o_activation: Optional[ToOActivation] = Field(
        alias=str("toOActivation"), default=None
    )
    min_percent_time: Optional[Any] = Field(alias=str("minPercentTime"), default=None)
    reviewer_id: Optional[Any] = Field(alias=str("reviewerId"), default=None)
    mentor_id: Optional[Any] = Field(alias=str("mentorId"), default=None)


class LargeProgramInput(BaseModel):
    to_o_activation: Optional[ToOActivation] = Field(
        alias=str("toOActivation"), default=None
    )
    min_percent_time: Optional[Any] = Field(alias=str("minPercentTime"), default=None)
    min_percent_total_time: Optional[Any] = Field(
        alias=str("minPercentTotalTime"), default=None
    )
    total_time: Optional["TimeSpanInput"] = Field(alias=str("totalTime"), default=None)


class PoorWeatherInput(BaseModel):
    ignore: Optional[Ignore] = None


class QueueInput(BaseModel):
    to_o_activation: Optional[ToOActivation] = Field(
        alias=str("toOActivation"), default=None
    )
    min_percent_time: Optional[Any] = Field(alias=str("minPercentTime"), default=None)
    partner_splits: Optional[List["PartnerSplitInput"]] = Field(
        alias=str("partnerSplits"), default=None
    )


class SystemVerificationInput(BaseModel):
    to_o_activation: Optional[ToOActivation] = Field(
        alias=str("toOActivation"), default=None
    )
    min_percent_time: Optional[Any] = Field(alias=str("minPercentTime"), default=None)


class ProposalPropertiesInput(BaseModel):
    category: Optional[TacCategory] = None
    call_id: Optional[Any] = Field(alias=str("callId"), default=None)
    type: Optional["ProposalTypeInput"] = None


class RadialVelocityInput(BaseModel):
    centimeters_per_second: Optional[Any] = Field(
        alias=str("centimetersPerSecond"), default=None
    )
    meters_per_second: Optional[Any] = Field(alias=str("metersPerSecond"), default=None)
    kilometers_per_second: Optional[Any] = Field(
        alias=str("kilometersPerSecond"), default=None
    )


class RecordAtomInput(BaseModel):
    visit_id: Any = Field(alias=str("visitId"))
    instrument: Instrument
    sequence_type: SequenceType = Field(alias=str("sequenceType"))
    generated_id: Optional[Any] = Field(alias=str("generatedId"), default=None)


class RecordDatasetInput(BaseModel):
    step_id: Any = Field(alias=str("stepId"))
    filename: Any
    qa_state: Optional[DatasetQaState] = Field(alias=str("qaState"), default=None)
    comment: Optional[Any] = None


class RecordGmosNorthStepInput(BaseModel):
    atom_id: Any = Field(alias=str("atomId"))
    gmos_north: "GmosNorthDynamicInput" = Field(alias=str("gmosNorth"))
    step_config: "StepConfigInput" = Field(alias=str("stepConfig"))
    telescope_config: Optional["TelescopeConfigInput"] = Field(
        alias=str("telescopeConfig"), default=None
    )
    observe_class: ObserveClass = Field(alias=str("observeClass"))
    generated_id: Optional[Any] = Field(alias=str("generatedId"), default=None)


class RecordGmosNorthVisitInput(BaseModel):
    observation_id: Any = Field(alias=str("observationId"))
    gmos_north: "GmosNorthStaticInput" = Field(alias=str("gmosNorth"))


class RecordGmosSouthStepInput(BaseModel):
    atom_id: Any = Field(alias=str("atomId"))
    gmos_south: "GmosSouthDynamicInput" = Field(alias=str("gmosSouth"))
    step_config: "StepConfigInput" = Field(alias=str("stepConfig"))
    telescope_config: Optional["TelescopeConfigInput"] = Field(
        alias=str("telescopeConfig"), default=None
    )
    observe_class: ObserveClass = Field(alias=str("observeClass"))
    generated_id: Optional[Any] = Field(alias=str("generatedId"), default=None)


class RecordGmosSouthVisitInput(BaseModel):
    observation_id: Any = Field(alias=str("observationId"))
    gmos_south: "GmosSouthStaticInput" = Field(alias=str("gmosSouth"))


class ResetAcquisitionInput(BaseModel):
    observation_id: Optional[Any] = Field(alias=str("observationId"), default=None)
    observation_reference: Optional[Any] = Field(
        alias=str("observationReference"), default=None
    )


class RightAscensionInput(BaseModel):
    microseconds: Optional[Any] = None
    degrees: Optional[Any] = None
    hours: Optional[Any] = None
    hms: Optional[Any] = None


class ObservingModeInput(BaseModel):
    gmos_north_long_slit: Optional["GmosNorthLongSlitInput"] = Field(
        alias=str("gmosNorthLongSlit"), default=None
    )
    gmos_south_long_slit: Optional["GmosSouthLongSlitInput"] = Field(
        alias=str("gmosSouthLongSlit"), default=None
    )
    gmos_north_imaging: Optional["GmosNorthImagingInput"] = Field(
        alias=str("gmosNorthImaging"), default=None
    )
    gmos_south_imaging: Optional["GmosSouthImagingInput"] = Field(
        alias=str("gmosSouthImaging"), default=None
    )
    flamingos_2_long_slit: Optional["Flamingos2LongSlitInput"] = Field(
        alias=str("flamingos2LongSlit"), default=None
    )


class ScienceRequirementsInput(BaseModel):
    exposure_time_mode: Optional["ExposureTimeModeInput"] = Field(
        alias=str("exposureTimeMode"), default=None
    )
    spectroscopy: Optional["SpectroscopyScienceRequirementsInput"] = None
    imaging: Optional["ImagingScienceRequirementsInput"] = None


class SetAllocationsInput(BaseModel):
    program_id: Any = Field(alias=str("programId"))
    allocations: List["AllocationInput"]


class SetGuideTargetNameInput(BaseModel):
    observation_id: Optional[Any] = Field(alias=str("observationId"), default=None)
    observation_reference: Optional[Any] = Field(
        alias=str("observationReference"), default=None
    )
    target_name: Optional[Any] = Field(alias=str("targetName"), default=None)


class SetProgramReferenceInput(BaseModel):
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)
    proposal_reference: Optional[Any] = Field(
        alias=str("proposalReference"), default=None
    )
    program_reference: Optional[Any] = Field(
        alias=str("programReference"), default=None
    )
    set: "ProgramReferencePropertiesInput" = Field(alias=str("SET"))


class ProgramReferencePropertiesInput(BaseModel):
    calibration: Optional["ProgramReferencePropertiesCalibrationInput"] = None
    commissioning: Optional["ProgramReferencePropertiesCommissioningInput"] = None
    engineering: Optional["ProgramReferencePropertiesEngineeringInput"] = None
    example: Optional["ProgramReferencePropertiesExampleInput"] = None
    library: Optional["ProgramReferencePropertiesLibraryInput"] = None
    monitoring: Optional["ProgramReferencePropertiesMonitoringInput"] = None
    science: Optional["ProgramReferencePropertiesScienceInput"] = None
    system: Optional["ProgramReferencePropertiesSystemInput"] = None


class ProgramReferencePropertiesCalibrationInput(BaseModel):
    semester: Any
    instrument: Instrument


class ProgramReferencePropertiesCommissioningInput(BaseModel):
    semester: Any
    instrument: Instrument


class ProgramReferencePropertiesEngineeringInput(BaseModel):
    semester: Any
    instrument: Instrument


class ProgramReferencePropertiesExampleInput(BaseModel):
    instrument: Instrument


class ProgramReferencePropertiesLibraryInput(BaseModel):
    instrument: Instrument
    description: Any


class ProgramReferencePropertiesMonitoringInput(BaseModel):
    semester: Any
    instrument: Instrument


class ProgramReferencePropertiesScienceInput(BaseModel):
    semester: Any
    science_subtype: ScienceSubtype = Field(alias=str("scienceSubtype"))


class ProgramReferencePropertiesSystemInput(BaseModel):
    description: Any


class SetProposalStatusInput(BaseModel):
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)
    proposal_reference: Optional[Any] = Field(
        alias=str("proposalReference"), default=None
    )
    program_reference: Optional[Any] = Field(
        alias=str("programReference"), default=None
    )
    status: ProposalStatus


class SiderealInput(BaseModel):
    ra: Optional["RightAscensionInput"] = None
    dec: Optional["DeclinationInput"] = None
    epoch: Optional[Any] = None
    proper_motion: Optional["ProperMotionInput"] = Field(
        alias=str("properMotion"), default=None
    )
    radial_velocity: Optional["RadialVelocityInput"] = Field(
        alias=str("radialVelocity"), default=None
    )
    parallax: Optional["ParallaxInput"] = None
    catalog_info: Optional["CatalogInfoInput"] = Field(
        alias=str("catalogInfo"), default=None
    )


class OpportunityInput(BaseModel):
    region: "RegionInput"


class RegionInput(BaseModel):
    right_ascension_arc: "RightAscensionArcInput" = Field(
        alias=str("rightAscensionArc")
    )
    declination_arc: "DeclinationArcInput" = Field(alias=str("declinationArc"))


class RightAscensionArcInput(BaseModel):
    type: ArcType
    start: Optional["RightAscensionInput"] = None
    end: Optional["RightAscensionInput"] = None


class DeclinationArcInput(BaseModel):
    type: ArcType
    start: Optional["DeclinationInput"] = None
    end: Optional["DeclinationInput"] = None


class SignalToNoiseExposureTimeModeInput(BaseModel):
    value: Any
    at: "WavelengthInput"


class SourceProfileInput(BaseModel):
    point: Optional["SpectralDefinitionIntegratedInput"] = None
    uniform: Optional["SpectralDefinitionSurfaceInput"] = None
    gaussian: Optional["GaussianInput"] = None


class SpectralDefinitionIntegratedInput(BaseModel):
    band_normalized: Optional["BandNormalizedIntegratedInput"] = Field(
        alias=str("bandNormalized"), default=None
    )
    emission_lines: Optional["EmissionLinesIntegratedInput"] = Field(
        alias=str("emissionLines"), default=None
    )


class SpectralDefinitionSurfaceInput(BaseModel):
    band_normalized: Optional["BandNormalizedSurfaceInput"] = Field(
        alias=str("bandNormalized"), default=None
    )
    emission_lines: Optional["EmissionLinesSurfaceInput"] = Field(
        alias=str("emissionLines"), default=None
    )


class SpectroscopyScienceRequirementsInput(BaseModel):
    wavelength: Optional["WavelengthInput"] = None
    resolution: Optional[Any] = None
    wavelength_coverage: Optional["WavelengthInput"] = Field(
        alias=str("wavelengthCoverage"), default=None
    )
    focal_plane: Optional[FocalPlane] = Field(alias=str("focalPlane"), default=None)
    focal_plane_angle: Optional["AngleInput"] = Field(
        alias=str("focalPlaneAngle"), default=None
    )
    capability: Optional[SpectroscopyCapabilities] = None


class StepConfigInput(BaseModel):
    bias: Optional[bool] = None
    dark: Optional[bool] = None
    gcal: Optional["StepConfigGcalInput"] = None
    science: Optional[bool] = None
    smart_gcal: Optional["StepConfigSmartGcalInput"] = Field(
        alias=str("smartGcal"), default=None
    )


class StepConfigGcalInput(BaseModel):
    arcs: Optional[List[GcalArc]] = None
    continuum: Optional[GcalContinuum] = None
    diffuser: GcalDiffuser
    filter: GcalFilter
    shutter: GcalShutter


class StepConfigSmartGcalInput(BaseModel):
    smart_gcal_type: SmartGcalType = Field(alias=str("smartGcalType"))


class ObscalcUpdateInput(BaseModel):
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)
    observation_id: Optional[Any] = Field(alias=str("observationId"), default=None)
    old_state: Optional["WhereOptionEqCalculationState"] = Field(
        alias=str("oldState"), default=None
    )
    new_state: Optional["WhereOptionEqCalculationState"] = Field(
        alias=str("newState"), default=None
    )


class WhereOrderCalculationState(BaseModel):
    eq: Optional[CalculationState] = Field(alias=str("EQ"), default=None)
    neq: Optional[CalculationState] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[CalculationState]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[CalculationState]] = Field(alias=str("NIN"), default=None)
    gt: Optional[CalculationState] = Field(alias=str("GT"), default=None)
    lt: Optional[CalculationState] = Field(alias=str("LT"), default=None)
    gte: Optional[CalculationState] = Field(alias=str("GTE"), default=None)
    lte: Optional[CalculationState] = Field(alias=str("LTE"), default=None)


class WhereOptionEqCalculationState(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    eq: Optional[CalculationState] = Field(alias=str("EQ"), default=None)
    neq: Optional[CalculationState] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[CalculationState]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[CalculationState]] = Field(alias=str("NIN"), default=None)


class ExecutionEventAddedInput(BaseModel):
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)
    observation_id: Optional[Any] = Field(alias=str("observationId"), default=None)
    visit_id: Optional[Any] = Field(alias=str("visitId"), default=None)
    event_type: Optional["WhereEqExecutionEventType"] = Field(
        alias=str("eventType"), default=None
    )


class TargetEditInput(BaseModel):
    target_id: Optional[Any] = Field(alias=str("targetId"), default=None)
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)


class GroupEditInput(BaseModel):
    group_id: Optional[Any] = Field(alias=str("groupId"), default=None)
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)


class ConfigurationRequestEditInput(BaseModel):
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)


class DatasetEditInput(BaseModel):
    dataset_id: Optional[Any] = Field(alias=str("datasetId"), default=None)
    observation_id: Optional[Any] = Field(alias=str("observationId"), default=None)
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)
    is_written: Optional[bool] = Field(alias=str("isWritten"), default=None)


class ObservationEditInput(BaseModel):
    observation_id: Optional[Any] = Field(alias=str("observationId"), default=None)
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)


class ProgramEditInput(BaseModel):
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)


class TargetEnvironmentInput(BaseModel):
    explicit_base: Optional["CoordinatesInput"] = Field(
        alias=str("explicitBase"), default=None
    )
    asterism: Optional[List[Any]] = None


class TargetPropertiesInput(BaseModel):
    name: Optional[Any] = None
    sidereal: Optional["SiderealInput"] = None
    nonsidereal: Optional["NonsiderealInput"] = None
    opportunity: Optional["OpportunityInput"] = None
    source_profile: Optional["SourceProfileInput"] = Field(
        alias=str("sourceProfile"), default=None
    )
    existence: Optional[Existence] = None


class TelescopeConfigInput(BaseModel):
    offset: Optional["OffsetInput"] = None
    guiding: Optional[GuideState] = None


class TimingWindowRepeatInput(BaseModel):
    period: "TimeSpanInput"
    times: Optional[Any] = None


class TimingWindowEndInput(BaseModel):
    at_utc: Optional[Any] = Field(alias=str("atUtc"), default=None)
    after: Optional["TimeSpanInput"] = None
    repeat: Optional["TimingWindowRepeatInput"] = None


class TimingWindowInput(BaseModel):
    inclusion: TimingWindowInclusion
    start_utc: Any = Field(alias=str("startUtc"))
    end: Optional["TimingWindowEndInput"] = None


class UnnormalizedSedInput(BaseModel):
    stellar_library: Optional[StellarLibrarySpectrum] = Field(
        alias=str("stellarLibrary"), default=None
    )
    cool_star: Optional[CoolStarTemperature] = Field(
        alias=str("coolStar"), default=None
    )
    galaxy: Optional[GalaxySpectrum] = None
    planet: Optional[PlanetSpectrum] = None
    quasar: Optional[QuasarSpectrum] = None
    hii_region: Optional[HiiRegionSpectrum] = Field(
        alias=str("hiiRegion"), default=None
    )
    planetary_nebula: Optional[PlanetaryNebulaSpectrum] = Field(
        alias=str("planetaryNebula"), default=None
    )
    power_law: Optional[Any] = Field(alias=str("powerLaw"), default=None)
    black_body_temp_k: Optional[Any] = Field(alias=str("blackBodyTempK"), default=None)
    flux_densities: Optional[List["FluxDensity"]] = Field(
        alias=str("fluxDensities"), default=None
    )
    flux_densities_attachment: Optional[Any] = Field(
        alias=str("fluxDensitiesAttachment"), default=None
    )


class UpdateAsterismsInput(BaseModel):
    set: "EditAsterismsPatchInput" = Field(alias=str("SET"))
    where: Optional["WhereObservation"] = Field(alias=str("WHERE"), default=None)
    limit: Optional[Any] = Field(alias=str("LIMIT"), default=None)
    include_deleted: Optional[bool] = Field(alias=str("includeDeleted"), default=False)


class UpdateAttachmentsInput(BaseModel):
    set: "AttachmentPropertiesInput" = Field(alias=str("SET"))
    where: Optional["WhereAttachment"] = Field(alias=str("WHERE"), default=None)
    limit: Optional[Any] = Field(alias=str("LIMIT"), default=None)


class UpdateCallsForProposalsInput(BaseModel):
    set: "CallForProposalsPropertiesInput" = Field(alias=str("SET"))
    where: Optional["WhereCallForProposals"] = Field(alias=str("WHERE"), default=None)
    limit: Optional[Any] = Field(alias=str("LIMIT"), default=None)
    include_deleted: Optional[bool] = Field(alias=str("includeDeleted"), default=False)


class UpdateDatasetsInput(BaseModel):
    set: "DatasetPropertiesInput" = Field(alias=str("SET"))
    where: Optional["WhereDataset"] = Field(alias=str("WHERE"), default=None)
    limit: Optional[Any] = Field(alias=str("LIMIT"), default=None)


class UpdateGroupsInput(BaseModel):
    set: "GroupPropertiesInput" = Field(alias=str("SET"))
    where: Optional["WhereGroup"] = Field(alias=str("WHERE"), default=None)
    limit: Optional[Any] = Field(alias=str("LIMIT"), default=None)


class UpdateObservationsInput(BaseModel):
    set: "ObservationPropertiesInput" = Field(alias=str("SET"))
    where: Optional["WhereObservation"] = Field(alias=str("WHERE"), default=None)
    limit: Optional[Any] = Field(alias=str("LIMIT"), default=None)
    include_deleted: Optional[bool] = Field(alias=str("includeDeleted"), default=False)


class UpdateConfigurationRequestsInput(BaseModel):
    set: "ConfigurationRequestProperties" = Field(alias=str("SET"))
    where: Optional["WhereConfigurationRequest"] = Field(
        alias=str("WHERE"), default=None
    )
    limit: Optional[Any] = Field(alias=str("LIMIT"), default=None)


class UpdateObservationsTimesInput(BaseModel):
    set: "ObservationTimesInput" = Field(alias=str("SET"))
    where: Optional["WhereObservation"] = Field(alias=str("WHERE"), default=None)
    limit: Optional[Any] = Field(alias=str("LIMIT"), default=None)
    include_deleted: Optional[bool] = Field(alias=str("includeDeleted"), default=False)


class UpdateProgramUsersInput(BaseModel):
    set: "ProgramUserPropertiesInput" = Field(alias=str("SET"))
    where: Optional["WhereProgramUser"] = Field(alias=str("WHERE"), default=None)
    limit: Optional[Any] = Field(alias=str("LIMIT"), default=None)


class UpdateProgramNotesInput(BaseModel):
    set: "ProgramNotePropertiesInput" = Field(alias=str("SET"))
    where: Optional["WhereProgramNote"] = Field(alias=str("WHERE"), default=None)
    limit: Optional[Any] = Field(alias=str("LIMIT"), default=None)
    include_deleted: Optional[bool] = Field(alias=str("includeDeleted"), default=False)


class UpdateProgramsInput(BaseModel):
    set: "ProgramPropertiesInput" = Field(alias=str("SET"))
    where: Optional["WhereProgram"] = Field(alias=str("WHERE"), default=None)
    limit: Optional[Any] = Field(alias=str("LIMIT"), default=None)
    include_deleted: Optional[bool] = Field(alias=str("includeDeleted"), default=False)


class UpdateProposalInput(BaseModel):
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)
    proposal_reference: Optional[Any] = Field(
        alias=str("proposalReference"), default=None
    )
    program_reference: Optional[Any] = Field(
        alias=str("programReference"), default=None
    )
    set: "ProposalPropertiesInput" = Field(alias=str("SET"))


class UpdateTargetsInput(BaseModel):
    set: "TargetPropertiesInput" = Field(alias=str("SET"))
    where: Optional["WhereTarget"] = Field(alias=str("WHERE"), default=None)
    limit: Optional[Any] = Field(alias=str("LIMIT"), default=None)
    include_deleted: Optional[bool] = Field(alias=str("includeDeleted"), default=False)


class WavelengthInput(BaseModel):
    picometers: Optional[Any] = None
    angstroms: Optional[Any] = None
    nanometers: Optional[Any] = None
    micrometers: Optional[Any] = None


class WavelengthDitherInput(BaseModel):
    picometers: Optional[int] = None
    angstroms: Optional[Any] = None
    nanometers: Optional[Any] = None
    micrometers: Optional[Any] = None


class AttachmentPropertiesInput(BaseModel):
    description: Optional[Any] = None
    checked: Optional[bool] = None


class WhereDatasetChronicleEntry(BaseModel):
    and_: Optional[List["WhereDatasetChronicleEntry"]] = Field(
        alias=str("AND"), default=None
    )
    or_: Optional[List["WhereDatasetChronicleEntry"]] = Field(
        alias=str("OR"), default=None
    )
    not_: Optional["WhereDatasetChronicleEntry"] = Field(alias=str("NOT"), default=None)
    id: Optional["WhereOrderChronicleId"] = None
    user: Optional["WhereUser"] = None
    operation: Optional["WhereEqDatabaseOperation"] = None
    timestamp: Optional["WhereOrderTimestamp"] = None
    dataset: Optional["WhereOrderDatasetId"] = None
    mod_dataset_id: Optional["WhereBoolean"] = Field(
        alias=str("modDatasetId"), default=None
    )
    mod_step_id: Optional["WhereBoolean"] = Field(alias=str("modStepId"), default=None)
    mod_observation_id: Optional["WhereBoolean"] = Field(
        alias=str("modObservationId"), default=None
    )
    mod_visit_id: Optional["WhereBoolean"] = Field(
        alias=str("modVisitId"), default=None
    )
    mod_reference: Optional["WhereBoolean"] = Field(
        alias=str("modReference"), default=None
    )
    mod_filename: Optional["WhereBoolean"] = Field(
        alias=str("modFilename"), default=None
    )
    mod_qa_state: Optional["WhereBoolean"] = Field(
        alias=str("modQaState"), default=None
    )
    mod_interval: Optional["WhereBoolean"] = Field(
        alias=str("modInterval"), default=None
    )
    mod_comment: Optional["WhereBoolean"] = Field(alias=str("modComment"), default=None)


class Flamingos2StaticInput(BaseModel):
    mos_pre_imaging: Optional[MosPreImaging] = Field(
        alias=str("mosPreImaging"), default=None
    )
    use_electronic_offsetting: Optional[bool] = Field(
        alias=str("useElectronicOffsetting"), default=None
    )


class RecordFlamingos2StepInput(BaseModel):
    atom_id: Any = Field(alias=str("atomId"))
    flamingos_2: "Flamingos2DynamicInput" = Field(alias=str("flamingos2"))
    step_config: "StepConfigInput" = Field(alias=str("stepConfig"))
    telescope_config: Optional["TelescopeConfigInput"] = Field(
        alias=str("telescopeConfig"), default=None
    )
    observe_class: ObserveClass = Field(alias=str("observeClass"))
    generated_id: Optional[Any] = Field(alias=str("generatedId"), default=None)


class RecordFlamingos2VisitInput(BaseModel):
    observation_id: Any = Field(alias=str("observationId"))
    flamingos_2: "Flamingos2StaticInput" = Field(alias=str("flamingos2"))


class Flamingos2DynamicInput(BaseModel):
    exposure: "TimeSpanInput"
    disperser: Optional[Flamingos2Disperser] = None
    filter: Flamingos2Filter
    read_mode: Flamingos2ReadMode = Field(alias=str("readMode"))
    lyot_wheel: Flamingos2LyotWheel = Field(alias=str("lyotWheel"))
    fpu: Optional["Flamingos2FpuMaskInput"] = None
    decker: Flamingos2Decker
    readout_mode: Flamingos2ReadoutMode = Field(alias=str("readoutMode"))
    reads: Flamingos2Reads


class Flamingos2FpuMaskInput(BaseModel):
    custom_mask: Optional["Flamingos2CustomMaskInput"] = Field(
        alias=str("customMask"), default=None
    )
    builtin: Optional[Flamingos2Fpu] = None


class Flamingos2CustomMaskInput(BaseModel):
    filename: str
    slit_width: Flamingos2CustomSlitWidth = Field(alias=str("slitWidth"))


class Flamingos2LongSlitInput(BaseModel):
    disperser: Optional[Flamingos2Disperser] = None
    filter: Optional[Flamingos2Filter] = None
    fpu: Optional[Flamingos2Fpu] = None
    explicit_read_mode: Optional[Flamingos2ReadMode] = Field(
        alias=str("explicitReadMode"), default=None
    )
    explicit_reads: Optional[Flamingos2Reads] = Field(
        alias=str("explicitReads"), default=None
    )
    explicit_decker: Optional[Flamingos2Decker] = Field(
        alias=str("explicitDecker"), default=None
    )
    explicit_readout_mode: Optional[Flamingos2ReadoutMode] = Field(
        alias=str("explicitReadoutMode"), default=None
    )
    explicit_offsets: Optional[List["OffsetInput"]] = Field(
        alias=str("explicitOffsets"), default=None
    )


class GoaPropertiesInput(BaseModel):
    proprietary_months: Optional[Any] = Field(
        alias=str("proprietaryMonths"), default=None
    )
    should_notify: Optional[bool] = Field(alias=str("shouldNotify"), default=None)
    private_header: Optional[bool] = Field(alias=str("privateHeader"), default=None)


class GroupElementInput(BaseModel):
    group_id: Optional[Any] = Field(alias=str("groupId"), default=None)
    observation_id: Optional[Any] = Field(alias=str("observationId"), default=None)


class GroupPropertiesInput(BaseModel):
    name: Optional[Any] = None
    description: Optional[Any] = None
    minimum_required: Optional[Any] = Field(alias=str("minimumRequired"), default=None)
    ordered: Optional[bool] = None
    minimum_interval: Optional["TimeSpanInput"] = Field(
        alias=str("minimumInterval"), default=None
    )
    maximum_interval: Optional["TimeSpanInput"] = Field(
        alias=str("maximumInterval"), default=None
    )
    parent_group: Optional[Any] = Field(alias=str("parentGroup"), default=None)
    parent_group_index: Optional[Any] = Field(
        alias=str("parentGroupIndex"), default=None
    )
    existence: Optional[Existence] = None


class CreateGroupInput(BaseModel):
    program_id: Optional[Any] = Field(alias=str("programId"), default=None)
    proposal_reference: Optional[Any] = Field(
        alias=str("proposalReference"), default=None
    )
    program_reference: Optional[Any] = Field(
        alias=str("programReference"), default=None
    )
    set: Optional["GroupPropertiesInput"] = Field(alias=str("SET"), default=None)
    initial_contents: Optional[List[Optional["GroupElementInput"]]] = Field(
        alias=str("initialContents"), default=None
    )


class ImagingScienceRequirementsInput(BaseModel):
    minimum_fov: Optional["AngleInput"] = Field(alias=str("minimumFov"), default=None)
    narrow_filters: Optional[bool] = Field(alias=str("narrowFilters"), default=None)
    broad_filters: Optional[bool] = Field(alias=str("broadFilters"), default=None)
    combined_filters: Optional[bool] = Field(alias=str("combinedFilters"), default=None)


class CreateConfigurationRequestInput(BaseModel):
    observation_id: Optional[Any] = Field(alias=str("observationId"), default=None)
    set: Optional["ConfigurationRequestProperties"] = Field(
        alias=str("SET"), default=None
    )


class TimeChargeCorrectionInput(BaseModel):
    charge_class: ChargeClass = Field(alias=str("chargeClass"))
    op: TimeChargeCorrectionOp
    amount: "TimeSpanInput"
    comment: Optional[str] = None


class TimeSpanInput(BaseModel):
    microseconds: Optional[Any] = None
    milliseconds: Optional[Any] = None
    seconds: Optional[Any] = None
    minutes: Optional[Any] = None
    hours: Optional[Any] = None
    iso: Optional[str] = None


class UnlinkUserInput(BaseModel):
    program_user_id: Any = Field(alias=str("programUserId"))


class UserProfileInput(BaseModel):
    given_name: Optional[str] = Field(alias=str("givenName"), default=None)
    family_name: Optional[str] = Field(alias=str("familyName"), default=None)
    credit_name: Optional[str] = Field(alias=str("creditName"), default=None)
    email: Optional[str] = None


class WhereAngle(BaseModel):
    and_: Optional[List["WhereAngle"]] = Field(alias=str("AND"), default=None)
    or_: Optional[List["WhereAngle"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereAngle"] = Field(alias=str("NOT"), default=None)
    microarcseconds: Optional["WhereOrderLong"] = None
    microseconds: Optional["WhereOrderBigDecimal"] = None
    milliarcseconds: Optional["WhereOrderBigDecimal"] = None
    milliseconds: Optional["WhereOrderBigDecimal"] = None
    arcseconds: Optional["WhereOrderBigDecimal"] = None
    seconds: Optional["WhereOrderBigDecimal"] = None
    arcminutes: Optional["WhereOrderBigDecimal"] = None
    minutes: Optional["WhereOrderBigDecimal"] = None
    degrees: Optional["WhereOrderBigDecimal"] = None
    hours: Optional["WhereOrderBigDecimal"] = None


class WhereBoolean(BaseModel):
    eq: Optional[bool] = Field(alias=str("EQ"), default=None)


class WhereOptionBoolean(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    eq: Optional[bool] = Field(alias=str("EQ"), default=None)


class WhereCallForProposals(BaseModel):
    and_: Optional[List["WhereCallForProposals"]] = Field(
        alias=str("AND"), default=None
    )
    or_: Optional[List["WhereCallForProposals"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereCallForProposals"] = Field(alias=str("NOT"), default=None)
    id: Optional["WhereOrderCallForProposalsId"] = None
    type: Optional["WhereEqCallForProposalsType"] = None
    semester: Optional["WhereOrderSemester"] = None
    active_start: Optional["WhereOrderDate"] = Field(
        alias=str("activeStart"), default=None
    )
    active_end: Optional["WhereOrderDate"] = Field(alias=str("activeEnd"), default=None)
    is_open: Optional["WhereBoolean"] = Field(alias=str("isOpen"), default=None)
    allows_non_partner_pi: Optional["WhereBoolean"] = Field(
        alias=str("allowsNonPartnerPi"), default=None
    )


class WhereAttachment(BaseModel):
    and_: Optional[List["WhereAttachment"]] = Field(alias=str("AND"), default=None)
    or_: Optional[List["WhereAttachment"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereAttachment"] = Field(alias=str("NOT"), default=None)
    id: Optional["WhereOrderAttachmentId"] = None
    file_name: Optional["WhereString"] = Field(alias=str("fileName"), default=None)
    description: Optional["WhereOptionString"] = None
    attachment_type: Optional["WhereAttachmentType"] = Field(
        alias=str("attachmentType"), default=None
    )
    checked: Optional[bool] = None
    program: Optional["WhereProgram"] = None


class WhereAttachmentType(BaseModel):
    eq: Optional[AttachmentType] = Field(alias=str("EQ"), default=None)
    neq: Optional[AttachmentType] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[AttachmentType]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[AttachmentType]] = Field(alias=str("NIN"), default=None)


class WhereOrderAttachmentId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereDataset(BaseModel):
    and_: Optional[List["WhereDataset"]] = Field(alias=str("AND"), default=None)
    or_: Optional[List["WhereDataset"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereDataset"] = Field(alias=str("NOT"), default=None)
    id: Optional["WhereOrderDatasetId"] = None
    reference: Optional["WhereDatasetReference"] = None
    observation: Optional["WhereObservation"] = None
    step_id: Optional["WhereEqStepId"] = Field(alias=str("stepId"), default=None)
    index: Optional["WhereOrderPosInt"] = None
    filename: Optional["WhereString"] = None
    qa_state: Optional["WhereOptionEqQaState"] = Field(
        alias=str("qaState"), default=None
    )
    comment: Optional["WhereOptionString"] = None
    is_written: Optional["WhereBoolean"] = Field(alias=str("isWritten"), default=None)


class WhereDatasetReference(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    label: Optional["WhereString"] = None
    observation: Optional["WhereObservationReference"] = None
    step_index: Optional["WhereOrderPosInt"] = Field(
        alias=str("stepIndex"), default=None
    )
    exposure_index: Optional["WhereOrderPosInt"] = Field(
        alias=str("exposureIndex"), default=None
    )


class WhereEqCallForProposalsType(BaseModel):
    eq: Optional[CallForProposalsType] = Field(alias=str("EQ"), default=None)
    neq: Optional[CallForProposalsType] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[CallForProposalsType]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[CallForProposalsType]] = Field(alias=str("NIN"), default=None)


class WhereEqDatabaseOperation(BaseModel):
    eq: Optional[DatabaseOperation] = Field(alias=str("EQ"), default=None)
    neq: Optional[DatabaseOperation] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[DatabaseOperation]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[DatabaseOperation]] = Field(alias=str("NIN"), default=None)


class WhereOptionEqEducationalStatus(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    eq: Optional[EducationalStatus] = Field(alias=str("EQ"), default=None)
    neq: Optional[EducationalStatus] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[EducationalStatus]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[EducationalStatus]] = Field(alias=str("NIN"), default=None)


class WhereEqExecutionEventType(BaseModel):
    eq: Optional[ExecutionEventType] = Field(alias=str("EQ"), default=None)
    neq: Optional[ExecutionEventType] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[ExecutionEventType]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[ExecutionEventType]] = Field(alias=str("NIN"), default=None)


class WhereOptionEqGender(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    eq: Optional[Gender] = Field(alias=str("EQ"), default=None)
    neq: Optional[Gender] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Gender]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Gender]] = Field(alias=str("NIN"), default=None)


class WhereOptionEqInstrument(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    eq: Optional[Instrument] = Field(alias=str("EQ"), default=None)
    neq: Optional[Instrument] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Instrument]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Instrument]] = Field(alias=str("NIN"), default=None)


class WhereEqPartner(BaseModel):
    eq: Optional[Partner] = Field(alias=str("EQ"), default=None)
    neq: Optional[Partner] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Partner]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Partner]] = Field(alias=str("NIN"), default=None)


class WhereEqPartnerLinkType(BaseModel):
    eq: Optional[PartnerLinkType] = Field(alias=str("EQ"), default=None)
    neq: Optional[PartnerLinkType] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[PartnerLinkType]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[PartnerLinkType]] = Field(alias=str("NIN"), default=None)


class WhereEqProgramUserRole(BaseModel):
    eq: Optional[ProgramUserRole] = Field(alias=str("EQ"), default=None)
    neq: Optional[ProgramUserRole] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[ProgramUserRole]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[ProgramUserRole]] = Field(alias=str("NIN"), default=None)


class WhereEqProgramType(BaseModel):
    eq: Optional[ProgramType] = Field(alias=str("EQ"), default=None)
    neq: Optional[ProgramType] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[ProgramType]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[ProgramType]] = Field(alias=str("NIN"), default=None)


class WhereEqProposalStatus(BaseModel):
    eq: Optional[ProposalStatus] = Field(alias=str("EQ"), default=None)
    neq: Optional[ProposalStatus] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[ProposalStatus]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[ProposalStatus]] = Field(alias=str("NIN"), default=None)


class WhereEqSite(BaseModel):
    eq: Optional[Site] = Field(alias=str("EQ"), default=None)
    neq: Optional[Site] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Site]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Site]] = Field(alias=str("NIN"), default=None)


class WhereOptionEqSite(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    eq: Optional[Site] = Field(alias=str("EQ"), default=None)
    neq: Optional[Site] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Site]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Site]] = Field(alias=str("NIN"), default=None)


class WhereEqStepId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)


class WhereEqToOActivation(BaseModel):
    eq: Optional[ToOActivation] = Field(alias=str("EQ"), default=None)
    neq: Optional[ToOActivation] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[ToOActivation]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[ToOActivation]] = Field(alias=str("NIN"), default=None)


class WhereEqUserType(BaseModel):
    eq: Optional[UserType] = Field(alias=str("EQ"), default=None)
    neq: Optional[UserType] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[UserType]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[UserType]] = Field(alias=str("NIN"), default=None)


class WhereEqVisitId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)


class WhereExecutionEvent(BaseModel):
    and_: Optional[List["WhereExecutionEvent"]] = Field(alias=str("AND"), default=None)
    or_: Optional[List["WhereExecutionEvent"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereExecutionEvent"] = Field(alias=str("NOT"), default=None)
    id: Optional["WhereOrderExecutionEventId"] = None
    visit_id: Optional["WhereEqVisitId"] = Field(alias=str("visitId"), default=None)
    observation: Optional["WhereObservation"] = None
    received: Optional["WhereOrderTimestamp"] = None
    event_type: Optional["WhereEqExecutionEventType"] = Field(
        alias=str("eventType"), default=None
    )
    slew_stage: Optional["WhereOrderSlewStage"] = Field(
        alias=str("slewStage"), default=None
    )
    sequence_command: Optional["WhereOrderSequenceCommand"] = Field(
        alias=str("sequenceCommand"), default=None
    )
    step_id: Optional["WhereEqStepId"] = Field(alias=str("stepId"), default=None)
    step_stage: Optional["WhereOrderStepStage"] = Field(
        alias=str("stepStage"), default=None
    )
    dataset_id: Optional["WhereOrderDatasetId"] = Field(
        alias=str("datasetId"), default=None
    )
    dataset_stage: Optional["WhereOrderDatasetStage"] = Field(
        alias=str("datasetStage"), default=None
    )


class WhereObservation(BaseModel):
    and_: Optional[List["WhereObservation"]] = Field(alias=str("AND"), default=None)
    or_: Optional[List["WhereObservation"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereObservation"] = Field(alias=str("NOT"), default=None)
    id: Optional["WhereOrderObservationId"] = None
    reference: Optional["WhereObservationReference"] = None
    program: Optional["WhereProgram"] = None
    subtitle: Optional["WhereOptionString"] = None
    science_band: Optional["WhereOptionOrderScienceBand"] = Field(
        alias=str("scienceBand"), default=None
    )
    instrument: Optional["WhereOptionEqInstrument"] = None
    site: Optional["WhereOptionEqSite"] = None
    workflow: Optional["WhereCalculatedObservationWorkflow"] = None


class WhereConfigurationRequest(BaseModel):
    and_: Optional[List["WhereConfigurationRequest"]] = Field(
        alias=str("AND"), default=None
    )
    or_: Optional[List["WhereConfigurationRequest"]] = Field(
        alias=str("OR"), default=None
    )
    not_: Optional["WhereConfigurationRequest"] = Field(alias=str("NOT"), default=None)
    id: Optional["WhereOrderConfigurationRequestId"] = None
    program: Optional["WhereProgram"] = None
    status: Optional["WhereOrderConfigurationRequestStatus"] = None


class WhereObservationReference(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    label: Optional["WhereString"] = None
    program: Optional["WhereProgramReference"] = None
    index: Optional["WhereOrderPosInt"] = None


class WhereGroup(BaseModel):
    and_: Optional[List["WhereGroup"]] = Field(alias=str("AND"), default=None)
    or_: Optional[List["WhereGroup"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereGroup"] = Field(alias=str("NOT"), default=None)
    id: Optional["WhereOrderGroupId"] = None
    name: Optional["WhereOptionString"] = None
    description: Optional["WhereOptionString"] = None


class WhereOrderGroupId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereEqFocalPlane(BaseModel):
    eq: Optional[FocalPlane] = Field(alias=str("EQ"), default=None)
    neq: Optional[FocalPlane] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[FocalPlane]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[FocalPlane]] = Field(alias=str("NIN"), default=None)


class WhereEqInstrument(BaseModel):
    eq: Optional[Instrument] = Field(alias=str("EQ"), default=None)
    neq: Optional[Instrument] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Instrument]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Instrument]] = Field(alias=str("NIN"), default=None)


class WhereOptionEqCalibrationRole(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    eq: Optional[CalibrationRole] = Field(alias=str("EQ"), default=None)
    neq: Optional[CalibrationRole] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[CalibrationRole]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[CalibrationRole]] = Field(alias=str("NIN"), default=None)


class WhereOptionEqPartner(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    eq: Optional[Partner] = Field(alias=str("EQ"), default=None)
    neq: Optional[Partner] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Partner]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Partner]] = Field(alias=str("NIN"), default=None)


class WhereOptionEqQaState(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    eq: Optional[DatasetQaState] = Field(alias=str("EQ"), default=None)
    neq: Optional[DatasetQaState] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[DatasetQaState]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[DatasetQaState]] = Field(alias=str("NIN"), default=None)


class WhereEqScienceSubtype(BaseModel):
    eq: Optional[ScienceSubtype] = Field(alias=str("EQ"), default=None)
    neq: Optional[ScienceSubtype] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[ScienceSubtype]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[ScienceSubtype]] = Field(alias=str("NIN"), default=None)


class WhereOptionEqSpectroscopyCapabilities(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    eq: Optional[SpectroscopyCapabilities] = Field(alias=str("EQ"), default=None)
    neq: Optional[SpectroscopyCapabilities] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[SpectroscopyCapabilities]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[SpectroscopyCapabilities]] = Field(
        alias=str("NIN"), default=None
    )


class WhereOptionEqTacCategory(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    eq: Optional[TacCategory] = Field(alias=str("EQ"), default=None)
    neq: Optional[TacCategory] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[TacCategory]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[TacCategory]] = Field(alias=str("NIN"), default=None)


class WhereOptionString(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    like: Optional[Any] = Field(alias=str("LIKE"), default=None)
    nlike: Optional[Any] = Field(alias=str("NLIKE"), default=None)
    match_case: Optional[bool] = Field(alias=str("MATCH_CASE"), default=True)


class WhereOrderBigDecimal(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderCallForProposalsId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderChronicleId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderDatasetId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderDatasetStage(BaseModel):
    eq: Optional[DatasetStage] = Field(alias=str("EQ"), default=None)
    neq: Optional[DatasetStage] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[DatasetStage]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[DatasetStage]] = Field(alias=str("NIN"), default=None)
    gt: Optional[DatasetStage] = Field(alias=str("GT"), default=None)
    lt: Optional[DatasetStage] = Field(alias=str("LT"), default=None)
    gte: Optional[DatasetStage] = Field(alias=str("GTE"), default=None)
    lte: Optional[DatasetStage] = Field(alias=str("LTE"), default=None)


class WhereOrderDate(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderExecutionEventId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderTimestamp(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderInt(BaseModel):
    eq: Optional[int] = Field(alias=str("EQ"), default=None)
    neq: Optional[int] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[int]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[int]] = Field(alias=str("NIN"), default=None)
    gt: Optional[int] = Field(alias=str("GT"), default=None)
    lt: Optional[int] = Field(alias=str("LT"), default=None)
    gte: Optional[int] = Field(alias=str("GTE"), default=None)
    lte: Optional[int] = Field(alias=str("LTE"), default=None)


class WhereOrderLong(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderObservationId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderConfigurationRequestId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderConfigurationRequestStatus(BaseModel):
    eq: Optional[ConfigurationRequestStatus] = Field(alias=str("EQ"), default=None)
    neq: Optional[ConfigurationRequestStatus] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[ConfigurationRequestStatus]] = Field(
        alias=str("IN"), default=None
    )
    nin: Optional[List[ConfigurationRequestStatus]] = Field(
        alias=str("NIN"), default=None
    )
    gt: Optional[ConfigurationRequestStatus] = Field(alias=str("GT"), default=None)
    lt: Optional[ConfigurationRequestStatus] = Field(alias=str("LT"), default=None)
    gte: Optional[ConfigurationRequestStatus] = Field(alias=str("GTE"), default=None)
    lte: Optional[ConfigurationRequestStatus] = Field(alias=str("LTE"), default=None)


class WhereOrderPosBigDecimal(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderPosInt(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderProgramId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderProgramNoteId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderProgramUserId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderUserId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereProposalReference(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    label: Optional["WhereString"] = None
    semester: Optional["WhereOrderSemester"] = None
    semester_index: Optional["WhereOrderPosInt"] = Field(
        alias=str("semesterIndex"), default=None
    )


class WhereOptionOrderScienceBand(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    eq: Optional[ScienceBand] = Field(alias=str("EQ"), default=None)
    neq: Optional[ScienceBand] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[ScienceBand]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[ScienceBand]] = Field(alias=str("NIN"), default=None)
    gt: Optional[ScienceBand] = Field(alias=str("GT"), default=None)
    lt: Optional[ScienceBand] = Field(alias=str("LT"), default=None)
    gte: Optional[ScienceBand] = Field(alias=str("GTE"), default=None)
    lte: Optional[ScienceBand] = Field(alias=str("LTE"), default=None)


class WhereOrderSemester(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WhereOrderSequenceCommand(BaseModel):
    eq: Optional[SequenceCommand] = Field(alias=str("EQ"), default=None)
    neq: Optional[SequenceCommand] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[SequenceCommand]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[SequenceCommand]] = Field(alias=str("NIN"), default=None)
    gt: Optional[SequenceCommand] = Field(alias=str("GT"), default=None)
    lt: Optional[SequenceCommand] = Field(alias=str("LT"), default=None)
    gte: Optional[SequenceCommand] = Field(alias=str("GTE"), default=None)
    lte: Optional[SequenceCommand] = Field(alias=str("LTE"), default=None)


class WhereOrderSequenceType(BaseModel):
    eq: Optional[SequenceType] = Field(alias=str("EQ"), default=None)
    neq: Optional[SequenceType] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[SequenceType]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[SequenceType]] = Field(alias=str("NIN"), default=None)
    gt: Optional[SequenceType] = Field(alias=str("GT"), default=None)
    lt: Optional[SequenceType] = Field(alias=str("LT"), default=None)
    gte: Optional[SequenceType] = Field(alias=str("GTE"), default=None)
    lte: Optional[SequenceType] = Field(alias=str("LTE"), default=None)


class WhereOrderSlewStage(BaseModel):
    eq: Optional[SlewStage] = Field(alias=str("EQ"), default=None)
    neq: Optional[SlewStage] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[SlewStage]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[SlewStage]] = Field(alias=str("NIN"), default=None)
    gt: Optional[SlewStage] = Field(alias=str("GT"), default=None)
    lt: Optional[SlewStage] = Field(alias=str("LT"), default=None)
    gte: Optional[SlewStage] = Field(alias=str("GTE"), default=None)
    lte: Optional[SlewStage] = Field(alias=str("LTE"), default=None)


class WhereOrderStepStage(BaseModel):
    eq: Optional[StepStage] = Field(alias=str("EQ"), default=None)
    neq: Optional[StepStage] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[StepStage]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[StepStage]] = Field(alias=str("NIN"), default=None)
    gt: Optional[StepStage] = Field(alias=str("GT"), default=None)
    lt: Optional[StepStage] = Field(alias=str("LT"), default=None)
    gte: Optional[StepStage] = Field(alias=str("GTE"), default=None)
    lte: Optional[StepStage] = Field(alias=str("LTE"), default=None)


class WhereOrderTargetId(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    gt: Optional[Any] = Field(alias=str("GT"), default=None)
    lt: Optional[Any] = Field(alias=str("LT"), default=None)
    gte: Optional[Any] = Field(alias=str("GTE"), default=None)
    lte: Optional[Any] = Field(alias=str("LTE"), default=None)


class WherePartnerLink(BaseModel):
    link_type: Optional["WhereEqPartnerLinkType"] = Field(
        alias=str("linkType"), default=None
    )
    partner: Optional["WhereOptionEqPartner"] = None


class WhereProgram(BaseModel):
    and_: Optional[List["WhereProgram"]] = Field(alias=str("AND"), default=None)
    or_: Optional[List["WhereProgram"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereProgram"] = Field(alias=str("NOT"), default=None)
    id: Optional["WhereOrderProgramId"] = None
    name: Optional["WhereOptionString"] = None
    type: Optional["WhereEqProgramType"] = None
    reference: Optional["WhereProgramReference"] = None
    pi: Optional["WhereProgramUser"] = None
    proposal_status: Optional["WhereEqProposalStatus"] = Field(
        alias=str("proposalStatus"), default=None
    )
    proposal: Optional["WhereProposal"] = None
    calibration_role: Optional["WhereOptionEqCalibrationRole"] = Field(
        alias=str("calibrationRole"), default=None
    )
    active_start: Optional["WhereOrderDate"] = Field(
        alias=str("activeStart"), default=None
    )
    active_end: Optional["WhereOrderDate"] = Field(alias=str("activeEnd"), default=None)


class WhereProgramReference(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    label: Optional["WhereString"] = None
    semester: Optional["WhereOrderSemester"] = None
    semester_index: Optional["WhereOrderPosInt"] = Field(
        alias=str("semesterIndex"), default=None
    )
    instrument: Optional["WhereEqInstrument"] = None
    description: Optional["WhereString"] = None
    science_subtype: Optional["WhereEqScienceSubtype"] = Field(
        alias=str("scienceSubtype"), default=None
    )


class WhereProgramNote(BaseModel):
    and_: Optional[List["WhereProgramNote"]] = Field(alias=str("AND"), default=None)
    or_: Optional[List["WhereProgramNote"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereProgramNote"] = Field(alias=str("NOT"), default=None)
    id: Optional["WhereOrderProgramNoteId"] = None
    program: Optional["WhereProgram"] = None
    title: Optional["WhereString"] = None
    text: Optional["WhereOptionString"] = None
    is_private: Optional["WhereBoolean"] = Field(alias=str("isPrivate"), default=None)


class WhereProgramUser(BaseModel):
    and_: Optional[List["WhereProgramUser"]] = Field(alias=str("AND"), default=None)
    or_: Optional[List["WhereProgramUser"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereProgramUser"] = Field(alias=str("NOT"), default=None)
    id: Optional["WhereOrderProgramUserId"] = None
    program: Optional["WhereProgram"] = None
    user: Optional["WhereUser"] = None
    role: Optional["WhereEqProgramUserRole"] = None
    partner_link: Optional["WherePartnerLink"] = Field(
        alias=str("partnerLink"), default=None
    )
    preferred_profile: Optional["WhereUserProfile"] = Field(
        alias=str("preferredProfile"), default=None
    )
    educational_status: Optional["WhereOptionEqEducationalStatus"] = Field(
        alias=str("educationalStatus"), default=None
    )
    thesis: Optional["WhereOptionBoolean"] = None
    gender: Optional["WhereOptionEqGender"] = None
    has_data_access: Optional["WhereBoolean"] = Field(
        alias=str("hasDataAccess"), default=None
    )


class WhereProposal(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    and_: Optional[List["WhereProposal"]] = Field(alias=str("AND"), default=None)
    or_: Optional[List["WhereProposal"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereProposal"] = Field(alias=str("NOT"), default=None)
    title: Optional["WhereOptionString"] = None
    reference: Optional["WhereProposalReference"] = None


class WhereProposalPartnerEntry(BaseModel):
    and_: Optional[List["WhereProposalPartnerEntry"]] = Field(
        alias=str("AND"), default=None
    )
    or_: Optional[List["WhereProposalPartnerEntry"]] = Field(
        alias=str("OR"), default=None
    )
    not_: Optional["WhereProposalPartnerEntry"] = Field(alias=str("NOT"), default=None)
    partner: Optional["WhereEqPartner"] = None
    percent: Optional["WhereOrderInt"] = None


class WhereProposalPartners(BaseModel):
    match: Optional["WhereProposalPartnerEntry"] = Field(
        alias=str("MATCH"), default=None
    )
    eq: Optional[List[Partner]] = Field(alias=str("EQ"), default=None)
    is_joint: Optional[bool] = Field(alias=str("isJoint"), default=None)


class WhereSpectroscopyConfigOption(BaseModel):
    and_: Optional[List["WhereSpectroscopyConfigOption"]] = Field(
        alias=str("AND"), default=None
    )
    or_: Optional[List["WhereSpectroscopyConfigOption"]] = Field(
        alias=str("OR"), default=None
    )
    not_: Optional["WhereSpectroscopyConfigOption"] = Field(
        alias=str("NOT"), default=None
    )
    adaptive_optics: Optional["WhereBoolean"] = Field(
        alias=str("adaptiveOptics"), default=None
    )
    capability: Optional["WhereOptionEqSpectroscopyCapabilities"] = None
    focal_plane: Optional["WhereEqFocalPlane"] = Field(
        alias=str("focalPlane"), default=None
    )
    instrument: Optional["WhereEqInstrument"] = None
    resolution: Optional["WhereOrderPosInt"] = None
    site: Optional["WhereEqSite"] = None
    slit_length: Optional["WhereAngle"] = Field(alias=str("slitLength"), default=None)
    slit_width: Optional["WhereAngle"] = Field(alias=str("slitWidth"), default=None)
    range_includes: Optional["WavelengthInput"] = Field(
        alias=str("rangeIncludes"), default=None
    )
    wavelength_optimal: Optional["WhereWavelength"] = Field(
        alias=str("wavelengthOptimal"), default=None
    )
    wavelength_coverage: Optional["WhereWavelength"] = Field(
        alias=str("wavelengthCoverage"), default=None
    )


class WhereImagingConfigOption(BaseModel):
    and_: Optional[List["WhereImagingConfigOption"]] = Field(
        alias=str("AND"), default=None
    )
    or_: Optional[List["WhereImagingConfigOption"]] = Field(
        alias=str("OR"), default=None
    )
    not_: Optional["WhereImagingConfigOption"] = Field(alias=str("NOT"), default=None)
    adaptive_optics: Optional["WhereBoolean"] = Field(
        alias=str("adaptiveOptics"), default=None
    )
    instrument: Optional["WhereEqInstrument"] = None
    fov: Optional["WhereAngle"] = None
    site: Optional["WhereEqSite"] = None


class WhereString(BaseModel):
    eq: Optional[Any] = Field(alias=str("EQ"), default=None)
    neq: Optional[Any] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[Any]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[Any]] = Field(alias=str("NIN"), default=None)
    like: Optional[Any] = Field(alias=str("LIKE"), default=None)
    nlike: Optional[Any] = Field(alias=str("NLIKE"), default=None)
    match_case: Optional[bool] = Field(alias=str("MATCH_CASE"), default=True)


class WhereTarget(BaseModel):
    and_: Optional[List["WhereTarget"]] = Field(alias=str("AND"), default=None)
    or_: Optional[List["WhereTarget"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereTarget"] = Field(alias=str("NOT"), default=None)
    id: Optional["WhereOrderTargetId"] = None
    program: Optional["WhereProgram"] = None
    name: Optional["WhereString"] = None
    calibration_role: Optional["WhereOptionEqCalibrationRole"] = Field(
        alias=str("calibrationRole"), default=None
    )


class WhereUser(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    and_: Optional[List["WhereUser"]] = Field(alias=str("AND"), default=None)
    or_: Optional[List["WhereUser"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereUser"] = Field(alias=str("NOT"), default=None)
    id: Optional["WhereOrderUserId"] = None
    type: Optional["WhereEqUserType"] = None
    orcid_id: Optional["WhereOptionString"] = Field(alias=str("orcidId"), default=None)
    profile: Optional["WhereUserProfile"] = None


class WhereUserProfile(BaseModel):
    given_name: Optional["WhereOptionString"] = Field(
        alias=str("givenName"), default=None
    )
    credit_name: Optional["WhereOptionString"] = Field(
        alias=str("creditName"), default=None
    )
    family_name: Optional["WhereOptionString"] = Field(
        alias=str("familyName"), default=None
    )
    email: Optional["WhereOptionString"] = None


class WhereWavelength(BaseModel):
    and_: Optional[List["WhereWavelength"]] = Field(alias=str("AND"), default=None)
    or_: Optional[List["WhereWavelength"]] = Field(alias=str("OR"), default=None)
    not_: Optional["WhereWavelength"] = Field(alias=str("NOT"), default=None)
    picometers: Optional["WhereOrderPosInt"] = None
    angstroms: Optional["WhereOrderPosBigDecimal"] = None
    nanometers: Optional["WhereOrderPosBigDecimal"] = None
    micrometers: Optional["WhereOrderPosBigDecimal"] = None


class WhereOrderObservationWorkflowState(BaseModel):
    eq: Optional[ObservationWorkflowState] = Field(alias=str("EQ"), default=None)
    neq: Optional[ObservationWorkflowState] = Field(alias=str("NEQ"), default=None)
    in_: Optional[List[ObservationWorkflowState]] = Field(alias=str("IN"), default=None)
    nin: Optional[List[ObservationWorkflowState]] = Field(
        alias=str("NIN"), default=None
    )
    gt: Optional[ObservationWorkflowState] = Field(alias=str("GT"), default=None)
    lt: Optional[ObservationWorkflowState] = Field(alias=str("LT"), default=None)
    gte: Optional[ObservationWorkflowState] = Field(alias=str("GTE"), default=None)
    lte: Optional[ObservationWorkflowState] = Field(alias=str("LTE"), default=None)


class WhereCalculatedObservationWorkflow(BaseModel):
    is_null: Optional[bool] = Field(alias=str("IS_NULL"), default=None)
    calculation_state: Optional["WhereOrderCalculationState"] = Field(
        alias=str("calculationState"), default=None
    )
    workflow_state: Optional["WhereOrderObservationWorkflowState"] = Field(
        alias=str("workflowState"), default=None
    )


AddProgramUserInput.model_rebuild()
AddTimeChargeCorrectionInput.model_rebuild()
AllocationInput.model_rebuild()
BandNormalizedIntegratedInput.model_rebuild()
BandNormalizedSurfaceInput.model_rebuild()
CallForProposalsPropertiesInput.model_rebuild()
SiteCoordinateLimitsInput.model_rebuild()
CoordinateLimitsInput.model_rebuild()
CloneObservationInput.model_rebuild()
CloneTargetInput.model_rebuild()
ConstraintSetInput.model_rebuild()
ConditionsEntryInput.model_rebuild()
ConditionsMeasurementInput.model_rebuild()
ConditionsIntuitionInput.model_rebuild()
ConditionsExpectationInput.model_rebuild()
CoordinatesInput.model_rebuild()
CreateCallForProposalsInput.model_rebuild()
CreateObservationInput.model_rebuild()
CreateProgramInput.model_rebuild()
CreateProgramNoteInput.model_rebuild()
CreateProposalInput.model_rebuild()
CreateTargetInput.model_rebuild()
ElevationRangeInput.model_rebuild()
EmissionLineIntegratedInput.model_rebuild()
EmissionLineSurfaceInput.model_rebuild()
EmissionLinesIntegratedInput.model_rebuild()
EmissionLinesSurfaceInput.model_rebuild()
ExposureTimeModeInput.model_rebuild()
TimeAndCountExposureTimeModeInput.model_rebuild()
FluxDensity.model_rebuild()
GaussianInput.model_rebuild()
GmosNodAndShuffleInput.model_rebuild()
GmosNorthDynamicInput.model_rebuild()
GmosNorthFpuInput.model_rebuild()
GmosNorthGratingConfigInput.model_rebuild()
GmosNorthLongSlitInput.model_rebuild()
GmosNorthImagingInput.model_rebuild()
GmosNorthStaticInput.model_rebuild()
GmosSouthDynamicInput.model_rebuild()
GmosSouthFpuInput.model_rebuild()
GmosSouthGratingConfigInput.model_rebuild()
GmosSouthLongSlitInput.model_rebuild()
GmosSouthImagingInput.model_rebuild()
GmosSouthStaticInput.model_rebuild()
CloneGroupInput.model_rebuild()
ObservationPropertiesInput.model_rebuild()
ObservationTimesInput.model_rebuild()
OffsetInput.model_rebuild()
PosAngleConstraintInput.model_rebuild()
ProgramPropertiesInput.model_rebuild()
ProgramUserPropertiesInput.model_rebuild()
ProperMotionInput.model_rebuild()
ProposalTypeInput.model_rebuild()
ClassicalInput.model_rebuild()
LargeProgramInput.model_rebuild()
QueueInput.model_rebuild()
ProposalPropertiesInput.model_rebuild()
RecordGmosNorthStepInput.model_rebuild()
RecordGmosNorthVisitInput.model_rebuild()
RecordGmosSouthStepInput.model_rebuild()
RecordGmosSouthVisitInput.model_rebuild()
ObservingModeInput.model_rebuild()
ScienceRequirementsInput.model_rebuild()
SetAllocationsInput.model_rebuild()
SetProgramReferenceInput.model_rebuild()
ProgramReferencePropertiesInput.model_rebuild()
SiderealInput.model_rebuild()
OpportunityInput.model_rebuild()
RegionInput.model_rebuild()
RightAscensionArcInput.model_rebuild()
DeclinationArcInput.model_rebuild()
SignalToNoiseExposureTimeModeInput.model_rebuild()
SourceProfileInput.model_rebuild()
SpectralDefinitionIntegratedInput.model_rebuild()
SpectralDefinitionSurfaceInput.model_rebuild()
SpectroscopyScienceRequirementsInput.model_rebuild()
StepConfigInput.model_rebuild()
ObscalcUpdateInput.model_rebuild()
ExecutionEventAddedInput.model_rebuild()
TargetEnvironmentInput.model_rebuild()
TargetPropertiesInput.model_rebuild()
TelescopeConfigInput.model_rebuild()
TimingWindowRepeatInput.model_rebuild()
TimingWindowEndInput.model_rebuild()
TimingWindowInput.model_rebuild()
UnnormalizedSedInput.model_rebuild()
UpdateAsterismsInput.model_rebuild()
UpdateAttachmentsInput.model_rebuild()
UpdateCallsForProposalsInput.model_rebuild()
UpdateDatasetsInput.model_rebuild()
UpdateGroupsInput.model_rebuild()
UpdateObservationsInput.model_rebuild()
UpdateConfigurationRequestsInput.model_rebuild()
UpdateObservationsTimesInput.model_rebuild()
UpdateProgramUsersInput.model_rebuild()
UpdateProgramNotesInput.model_rebuild()
UpdateProgramsInput.model_rebuild()
UpdateProposalInput.model_rebuild()
UpdateTargetsInput.model_rebuild()
WhereDatasetChronicleEntry.model_rebuild()
RecordFlamingos2StepInput.model_rebuild()
RecordFlamingos2VisitInput.model_rebuild()
Flamingos2DynamicInput.model_rebuild()
Flamingos2FpuMaskInput.model_rebuild()
Flamingos2LongSlitInput.model_rebuild()
GroupPropertiesInput.model_rebuild()
CreateGroupInput.model_rebuild()
ImagingScienceRequirementsInput.model_rebuild()
CreateConfigurationRequestInput.model_rebuild()
TimeChargeCorrectionInput.model_rebuild()
WhereAngle.model_rebuild()
WhereCallForProposals.model_rebuild()
WhereAttachment.model_rebuild()
WhereDataset.model_rebuild()
WhereDatasetReference.model_rebuild()
WhereExecutionEvent.model_rebuild()
WhereObservation.model_rebuild()
WhereConfigurationRequest.model_rebuild()
WhereObservationReference.model_rebuild()
WhereGroup.model_rebuild()
WhereProposalReference.model_rebuild()
WherePartnerLink.model_rebuild()
WhereProgram.model_rebuild()
WhereProgramReference.model_rebuild()
WhereProgramNote.model_rebuild()
WhereProgramUser.model_rebuild()
WhereProposal.model_rebuild()
WhereProposalPartnerEntry.model_rebuild()
WhereProposalPartners.model_rebuild()
WhereSpectroscopyConfigOption.model_rebuild()
WhereImagingConfigOption.model_rebuild()
WhereTarget.model_rebuild()
WhereUser.model_rebuild()
WhereUserProfile.model_rebuild()
WhereWavelength.model_rebuild()
WhereCalculatedObservationWorkflow.model_rebuild()
