# Generated by Django 3.1.13 on 2021-10-25 22:21

import uuid

import django.utils.timezone
import model_utils.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='MetadataFieldOverwrite',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('field_name', models.CharField(max_length=200)),
                ('field_type', models.CharField(choices=[('datetime', 'DATETIME'), ('int', 'INTEGER'), ('str', 'CHARACTER'), ('bool', 'BOOLEAN')], max_length=200, null=True)),
                ('field_value', models.CharField(max_length=200, null=True)),
                ('overwrite', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MetadataLedger',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('metadata_record_inactivation_date', models.DateTimeField(blank=True, null=True)),
                ('metadata_record_uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('record_lifecycle_status', models.CharField(blank=True, choices=[('Active', 'A'), ('Inactive', 'I')], max_length=10)),
                ('source_metadata', models.JSONField(blank=True)),
                ('source_metadata_extraction_date', models.DateTimeField(auto_now_add=True)),
                ('source_metadata_hash', models.CharField(max_length=200)),
                ('source_metadata_key', models.TextField()),
                ('source_metadata_key_hash', models.CharField(max_length=200)),
                ('source_metadata_transformation_date', models.DateTimeField(blank=True, null=True)),
                ('source_metadata_validation_date', models.DateTimeField(blank=True, null=True)),
                ('source_metadata_validation_status', models.CharField(blank=True, choices=[('Y', 'Yes'), ('N', 'No')], max_length=10)),
                ('target_metadata', models.JSONField(default=dict)),
                ('target_metadata_hash', models.CharField(max_length=200)),
                ('target_metadata_key', models.TextField()),
                ('target_metadata_key_hash', models.CharField(max_length=200)),
                ('target_metadata_transmission_date', models.DateTimeField(blank=True, null=True)),
                ('target_metadata_transmission_status', models.CharField(blank=True, choices=[('Successful', 'S'), ('Failed', 'F'), ('Pending', 'P'), ('Ready', 'R')], default='Ready', max_length=10)),
                ('target_metadata_transmission_status_code', models.IntegerField(blank=True, null=True)),
                ('target_metadata_validation_date', models.DateTimeField(blank=True, null=True)),
                ('target_metadata_validation_status', models.CharField(blank=True, choices=[('Y', 'Yes'), ('N', 'No')], max_length=10)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SupplementalLedger',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('metadata_record_inactivation_date', models.DateTimeField(blank=True, null=True)),
                ('metadata_record_uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('record_lifecycle_status', models.CharField(blank=True, choices=[('Active', 'A'), ('Inactive', 'I')], max_length=10)),
                ('supplemental_metadata', models.JSONField(blank=True)),
                ('supplemental_metadata_extraction_date', models.DateTimeField(auto_now_add=True)),
                ('supplemental_metadata_hash', models.CharField(max_length=200)),
                ('supplemental_metadata_key', models.TextField()),
                ('supplemental_metadata_key_hash', models.CharField(max_length=200)),
                ('supplemental_metadata_transformation_date', models.DateTimeField(blank=True, null=True)),
                ('supplemental_metadata_validation_date', models.DateTimeField(blank=True, null=True)),
                ('supplemental_metadata_transmission_date', models.DateTimeField(blank=True, null=True)),
                ('supplemental_metadata_transmission_status', models.CharField(blank=True, choices=[('Successful', 'S'), ('Failed', 'F'), ('Pending', 'P'), ('Ready', 'R')], default='Ready', max_length=10)),
                ('supplemental_metadata_transmission_status_code', models.IntegerField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='XIAConfiguration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('publisher', models.CharField(help_text='Enter the publisher name', max_length=200)),
                ('source_metadata_schema', models.CharField(help_text='Enter the schema file', max_length=200)),
                ('source_target_mapping', models.CharField(help_text='Enter the schema file to map target.', max_length=200)),
                ('target_metadata_schema', models.CharField(help_text='Enter the target schema file to validate from.', max_length=200)),
                ('source_file', models.FileField(help_text='Upload the source file', upload_to='')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='XISConfiguration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('xis_metadata_api_endpoint', models.CharField(help_text='Enter the XIS Metadata Ledger API endpoint', max_length=200)),
                ('xis_supplemental_api_endpoint', models.CharField(help_text='Enter the XIS Supplemental Ledger API endpoint', max_length=200)),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
