# Generated by Django 2.0.2 on 2018-02-27 03:02

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='EngineAspiration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_on', models.DateTimeField(auto_now=True, db_index=True)),
                ('name', models.CharField(max_length=12)),
            ],
            options={
                'ordering': ('created_on',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FuelDelivery',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_on', models.DateTimeField(auto_now=True, db_index=True)),
                ('name', models.CharField(max_length=10)),
            ],
            options={
                'ordering': ('created_on',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FuelType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_on', models.DateTimeField(auto_now=True, db_index=True)),
                ('name', models.CharField(max_length=20)),
            ],
            options={
                'ordering': ('created_on',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Vehicle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_on', models.DateTimeField(auto_now=True, db_index=True)),
            ],
        ),
        migrations.CreateModel(
            name='VehicleEngine',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_on', models.DateTimeField(auto_now=True, db_index=True)),
                ('configuration', models.CharField(db_index=True, max_length=3)),
                ('liters', models.DecimalField(db_index=True, decimal_places=1, max_digits=3, null=True)),
                ('engine_code', models.CharField(db_index=True, max_length=100, null=True)),
                ('aspiration', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='engines', to='django_vehiclefitment.EngineAspiration')),
                ('fuel_delivery', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='engines', to='django_vehiclefitment.FuelDelivery')),
                ('fuel_type', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='engines', to='django_vehiclefitment.FuelType')),
            ],
        ),
        migrations.CreateModel(
            name='VehicleMake',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_on', models.DateTimeField(auto_now=True, db_index=True)),
                ('name', models.CharField(db_index=True, max_length=100, unique=True)),
            ],
            options={
                'ordering': ('created_on',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='VehicleModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_on', models.DateTimeField(auto_now=True, db_index=True)),
                ('name', models.CharField(db_index=True, max_length=100)),
                ('make', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_vehiclefitment.VehicleMake')),
            ],
        ),
        migrations.CreateModel(
            name='VehicleSubModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_on', models.DateTimeField(auto_now=True, db_index=True)),
                ('name', models.CharField(db_index=True, max_length=100)),
                ('model', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_vehiclefitment.VehicleModel')),
            ],
        ),
        migrations.CreateModel(
            name='VehicleYear',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_on', models.DateTimeField(auto_now=True, db_index=True)),
                ('year', models.PositiveIntegerField(db_index=True)),
                ('vehicle', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_vehiclefitment.Vehicle')),
            ],
        ),
        migrations.AddField(
            model_name='vehicle',
            name='engine',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='django_vehiclefitment.VehicleEngine'),
        ),
        migrations.AddField(
            model_name='vehicle',
            name='make',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_vehiclefitment.VehicleMake'),
        ),
        migrations.AddField(
            model_name='vehicle',
            name='model',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_vehiclefitment.VehicleModel'),
        ),
        migrations.AddField(
            model_name='vehicle',
            name='sub_model',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='django_vehiclefitment.VehicleSubModel'),
        ),
        migrations.AlterUniqueTogether(
            name='vehicleyear',
            unique_together={('vehicle', 'year')},
        ),
        migrations.AlterUniqueTogether(
            name='vehiclesubmodel',
            unique_together={('name', 'model')},
        ),
        migrations.AlterUniqueTogether(
            name='vehiclemodel',
            unique_together={('name', 'make')},
        ),
        migrations.AlterUniqueTogether(
            name='vehicleengine',
            unique_together={('configuration', 'liters', 'fuel_type', 'fuel_delivery', 'aspiration', 'engine_code')},
        ),
        migrations.AlterUniqueTogether(
            name='vehicle',
            unique_together={('make', 'model', 'sub_model', 'engine')},
        ),
    ]
