# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from bandwidth.models.call_state import CallState
from bandwidth.models.create_call import CreateCall
from bandwidth.models.create_call_response import CreateCallResponse
from bandwidth.models.update_call import UpdateCall

from bandwidth.api_client import ApiClient, RequestSerialized
from bandwidth.api_response import ApiResponse
from bandwidth.rest import RESTResponseType


class CallsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_call(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        create_call: Annotated[CreateCall, Field(description="JSON object containing information to create an outbound call")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> CreateCallResponse:
        """Create Call

        Creates an outbound phone call.  All calls are initially queued. Your outbound calls will initiated at a specific dequeueing rate, enabling your application to \"fire and forget\" when creating calls. Queued calls may not be modified until they are dequeued and placed, but may be removed from your queue on demand.  <b>Please note:</b> Calls submitted to your queue will be placed approximately in order, but exact ordering is not guaranteed.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param create_call: JSON object containing information to create an outbound call (required)
        :type create_call: CreateCall
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_call_serialize(
            account_id=account_id,
            create_call=create_call,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateCallResponse",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_call_with_http_info(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        create_call: Annotated[CreateCall, Field(description="JSON object containing information to create an outbound call")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[CreateCallResponse]:
        """Create Call

        Creates an outbound phone call.  All calls are initially queued. Your outbound calls will initiated at a specific dequeueing rate, enabling your application to \"fire and forget\" when creating calls. Queued calls may not be modified until they are dequeued and placed, but may be removed from your queue on demand.  <b>Please note:</b> Calls submitted to your queue will be placed approximately in order, but exact ordering is not guaranteed.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param create_call: JSON object containing information to create an outbound call (required)
        :type create_call: CreateCall
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_call_serialize(
            account_id=account_id,
            create_call=create_call,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateCallResponse",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_call_without_preload_content(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        create_call: Annotated[CreateCall, Field(description="JSON object containing information to create an outbound call")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Create Call

        Creates an outbound phone call.  All calls are initially queued. Your outbound calls will initiated at a specific dequeueing rate, enabling your application to \"fire and forget\" when creating calls. Queued calls may not be modified until they are dequeued and placed, but may be removed from your queue on demand.  <b>Please note:</b> Calls submitted to your queue will be placed approximately in order, but exact ordering is not guaranteed.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param create_call: JSON object containing information to create an outbound call (required)
        :type create_call: CreateCall
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_call_serialize(
            account_id=account_id,
            create_call=create_call,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateCallResponse",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_call_serialize(
        self,
        account_id,
        create_call,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://voice.bandwidth.com/api/v2'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if account_id is not None:
            _path_params['accountId'] = account_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_call is not None:
            _body_params = create_call


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Basic'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/accounts/{accountId}/calls',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_call_state(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> CallState:
        """Get Call State Information

        Retrieve the current state of a specific call. This information is near-realtime, so it may take a few minutes for your call to be accessible using this endpoint.  **Note**: Call information is kept for 7 days after the calls are hung up. If you attempt to retrieve information for a call that is older than 7 days, you will get an HTTP 404 response.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_call_state_serialize(
            account_id=account_id,
            call_id=call_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CallState",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_call_state_with_http_info(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[CallState]:
        """Get Call State Information

        Retrieve the current state of a specific call. This information is near-realtime, so it may take a few minutes for your call to be accessible using this endpoint.  **Note**: Call information is kept for 7 days after the calls are hung up. If you attempt to retrieve information for a call that is older than 7 days, you will get an HTTP 404 response.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_call_state_serialize(
            account_id=account_id,
            call_id=call_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CallState",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_call_state_without_preload_content(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Get Call State Information

        Retrieve the current state of a specific call. This information is near-realtime, so it may take a few minutes for your call to be accessible using this endpoint.  **Note**: Call information is kept for 7 days after the calls are hung up. If you attempt to retrieve information for a call that is older than 7 days, you will get an HTTP 404 response.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_call_state_serialize(
            account_id=account_id,
            call_id=call_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CallState",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_call_state_serialize(
        self,
        account_id,
        call_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://voice.bandwidth.com/api/v2'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if account_id is not None:
            _path_params['accountId'] = account_id
        if call_id is not None:
            _path_params['callId'] = call_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Basic'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/accounts/{accountId}/calls/{callId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_calls(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        to: Annotated[Optional[StrictStr], Field(description="Filter results by the `to` field.")] = None,
        var_from: Annotated[Optional[StrictStr], Field(description="Filter results by the `from` field.")] = None,
        min_start_time: Annotated[Optional[StrictStr], Field(description="Filter results to calls which have a `startTime` after or including `minStartTime` (in ISO8601 format).")] = None,
        max_start_time: Annotated[Optional[StrictStr], Field(description="Filter results to calls which have a `startTime` before or including `maxStartTime` (in ISO8601 format).")] = None,
        disconnect_cause: Annotated[Optional[StrictStr], Field(description="Filter results to calls with specified call Disconnect Cause.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]], Field(description="Specifies the max number of calls that will be returned.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="Not intended for explicit use. To use pagination, follow the links in the `Link` header of the response, as indicated in the endpoint description.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> List[CallState]:
        """Get Calls

        Returns a max of 10000 calls, sorted by `createdTime` from oldest to newest.  **NOTE:** If the number of calls in the account is bigger than `pageSize`, a `Link` header (with format `<{url}>; rel=\"next\"`) will be returned in the response. The url can be used to retrieve the next page of call records. Also, call information is kept for 7 days after the calls are hung up. If you attempt to retrieve information for a call that is older than 7 days, you will get an empty array [] in response.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param to: Filter results by the `to` field.
        :type to: str
        :param var_from: Filter results by the `from` field.
        :type var_from: str
        :param min_start_time: Filter results to calls which have a `startTime` after or including `minStartTime` (in ISO8601 format).
        :type min_start_time: str
        :param max_start_time: Filter results to calls which have a `startTime` before or including `maxStartTime` (in ISO8601 format).
        :type max_start_time: str
        :param disconnect_cause: Filter results to calls with specified call Disconnect Cause.
        :type disconnect_cause: str
        :param page_size: Specifies the max number of calls that will be returned.
        :type page_size: int
        :param page_token: Not intended for explicit use. To use pagination, follow the links in the `Link` header of the response, as indicated in the endpoint description.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_calls_serialize(
            account_id=account_id,
            to=to,
            var_from=var_from,
            min_start_time=min_start_time,
            max_start_time=max_start_time,
            disconnect_cause=disconnect_cause,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CallState]",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_calls_with_http_info(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        to: Annotated[Optional[StrictStr], Field(description="Filter results by the `to` field.")] = None,
        var_from: Annotated[Optional[StrictStr], Field(description="Filter results by the `from` field.")] = None,
        min_start_time: Annotated[Optional[StrictStr], Field(description="Filter results to calls which have a `startTime` after or including `minStartTime` (in ISO8601 format).")] = None,
        max_start_time: Annotated[Optional[StrictStr], Field(description="Filter results to calls which have a `startTime` before or including `maxStartTime` (in ISO8601 format).")] = None,
        disconnect_cause: Annotated[Optional[StrictStr], Field(description="Filter results to calls with specified call Disconnect Cause.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]], Field(description="Specifies the max number of calls that will be returned.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="Not intended for explicit use. To use pagination, follow the links in the `Link` header of the response, as indicated in the endpoint description.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[List[CallState]]:
        """Get Calls

        Returns a max of 10000 calls, sorted by `createdTime` from oldest to newest.  **NOTE:** If the number of calls in the account is bigger than `pageSize`, a `Link` header (with format `<{url}>; rel=\"next\"`) will be returned in the response. The url can be used to retrieve the next page of call records. Also, call information is kept for 7 days after the calls are hung up. If you attempt to retrieve information for a call that is older than 7 days, you will get an empty array [] in response.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param to: Filter results by the `to` field.
        :type to: str
        :param var_from: Filter results by the `from` field.
        :type var_from: str
        :param min_start_time: Filter results to calls which have a `startTime` after or including `minStartTime` (in ISO8601 format).
        :type min_start_time: str
        :param max_start_time: Filter results to calls which have a `startTime` before or including `maxStartTime` (in ISO8601 format).
        :type max_start_time: str
        :param disconnect_cause: Filter results to calls with specified call Disconnect Cause.
        :type disconnect_cause: str
        :param page_size: Specifies the max number of calls that will be returned.
        :type page_size: int
        :param page_token: Not intended for explicit use. To use pagination, follow the links in the `Link` header of the response, as indicated in the endpoint description.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_calls_serialize(
            account_id=account_id,
            to=to,
            var_from=var_from,
            min_start_time=min_start_time,
            max_start_time=max_start_time,
            disconnect_cause=disconnect_cause,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CallState]",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_calls_without_preload_content(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        to: Annotated[Optional[StrictStr], Field(description="Filter results by the `to` field.")] = None,
        var_from: Annotated[Optional[StrictStr], Field(description="Filter results by the `from` field.")] = None,
        min_start_time: Annotated[Optional[StrictStr], Field(description="Filter results to calls which have a `startTime` after or including `minStartTime` (in ISO8601 format).")] = None,
        max_start_time: Annotated[Optional[StrictStr], Field(description="Filter results to calls which have a `startTime` before or including `maxStartTime` (in ISO8601 format).")] = None,
        disconnect_cause: Annotated[Optional[StrictStr], Field(description="Filter results to calls with specified call Disconnect Cause.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]], Field(description="Specifies the max number of calls that will be returned.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="Not intended for explicit use. To use pagination, follow the links in the `Link` header of the response, as indicated in the endpoint description.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Get Calls

        Returns a max of 10000 calls, sorted by `createdTime` from oldest to newest.  **NOTE:** If the number of calls in the account is bigger than `pageSize`, a `Link` header (with format `<{url}>; rel=\"next\"`) will be returned in the response. The url can be used to retrieve the next page of call records. Also, call information is kept for 7 days after the calls are hung up. If you attempt to retrieve information for a call that is older than 7 days, you will get an empty array [] in response.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param to: Filter results by the `to` field.
        :type to: str
        :param var_from: Filter results by the `from` field.
        :type var_from: str
        :param min_start_time: Filter results to calls which have a `startTime` after or including `minStartTime` (in ISO8601 format).
        :type min_start_time: str
        :param max_start_time: Filter results to calls which have a `startTime` before or including `maxStartTime` (in ISO8601 format).
        :type max_start_time: str
        :param disconnect_cause: Filter results to calls with specified call Disconnect Cause.
        :type disconnect_cause: str
        :param page_size: Specifies the max number of calls that will be returned.
        :type page_size: int
        :param page_token: Not intended for explicit use. To use pagination, follow the links in the `Link` header of the response, as indicated in the endpoint description.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_calls_serialize(
            account_id=account_id,
            to=to,
            var_from=var_from,
            min_start_time=min_start_time,
            max_start_time=max_start_time,
            disconnect_cause=disconnect_cause,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CallState]",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_calls_serialize(
        self,
        account_id,
        to,
        var_from,
        min_start_time,
        max_start_time,
        disconnect_cause,
        page_size,
        page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://voice.bandwidth.com/api/v2'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if account_id is not None:
            _path_params['accountId'] = account_id
        # process the query parameters
        if to is not None:
            
            _query_params.append(('to', to))
            
        if var_from is not None:
            
            _query_params.append(('from', var_from))
            
        if min_start_time is not None:
            
            _query_params.append(('minStartTime', min_start_time))
            
        if max_start_time is not None:
            
            _query_params.append(('maxStartTime', max_start_time))
            
        if disconnect_cause is not None:
            
            _query_params.append(('disconnectCause', disconnect_cause))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Basic'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/accounts/{accountId}/calls',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_call(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        update_call: Annotated[UpdateCall, Field(description="JSON object containing information to redirect an existing call to a new BXML document")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """Update Call

        Interrupts and redirects a call to a different URL that should return a BXML document.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param update_call: JSON object containing information to redirect an existing call to a new BXML document (required)
        :type update_call: UpdateCall
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_call_serialize(
            account_id=account_id,
            call_id=call_id,
            update_call=update_call,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '409': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_call_with_http_info(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        update_call: Annotated[UpdateCall, Field(description="JSON object containing information to redirect an existing call to a new BXML document")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """Update Call

        Interrupts and redirects a call to a different URL that should return a BXML document.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param update_call: JSON object containing information to redirect an existing call to a new BXML document (required)
        :type update_call: UpdateCall
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_call_serialize(
            account_id=account_id,
            call_id=call_id,
            update_call=update_call,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '409': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_call_without_preload_content(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        update_call: Annotated[UpdateCall, Field(description="JSON object containing information to redirect an existing call to a new BXML document")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Update Call

        Interrupts and redirects a call to a different URL that should return a BXML document.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param update_call: JSON object containing information to redirect an existing call to a new BXML document (required)
        :type update_call: UpdateCall
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_call_serialize(
            account_id=account_id,
            call_id=call_id,
            update_call=update_call,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '409': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_call_serialize(
        self,
        account_id,
        call_id,
        update_call,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://voice.bandwidth.com/api/v2'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if account_id is not None:
            _path_params['accountId'] = account_id
        if call_id is not None:
            _path_params['callId'] = call_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_call is not None:
            _body_params = update_call


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Basic'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/accounts/{accountId}/calls/{callId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_call_bxml(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        body: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """Update Call BXML

        Interrupts and replaces an active call's BXML document.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param body: (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_call_bxml_serialize(
            account_id=account_id,
            call_id=call_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '409': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_call_bxml_with_http_info(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        body: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """Update Call BXML

        Interrupts and replaces an active call's BXML document.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param body: (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_call_bxml_serialize(
            account_id=account_id,
            call_id=call_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '409': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_call_bxml_without_preload_content(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        body: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Update Call BXML

        Interrupts and replaces an active call's BXML document.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param body: (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_call_bxml_serialize(
            account_id=account_id,
            call_id=call_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '409': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_call_bxml_serialize(
        self,
        account_id,
        call_id,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://voice.bandwidth.com/api/v2'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if account_id is not None:
            _path_params['accountId'] = account_id
        if call_id is not None:
            _path_params['callId'] = call_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/xml'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Basic'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/accounts/{accountId}/calls/{callId}/bxml',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


