# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from bandwidth.models.list_message_direction_enum import ListMessageDirectionEnum
from bandwidth.models.message import Message
from bandwidth.models.message_request import MessageRequest
from bandwidth.models.message_status_enum import MessageStatusEnum
from bandwidth.models.message_type_enum import MessageTypeEnum
from bandwidth.models.messages_list import MessagesList

from bandwidth.api_client import ApiClient, RequestSerialized
from bandwidth.api_response import ApiResponse
from bandwidth.rest import RESTResponseType


class MessagesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_message(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        message_request: MessageRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> Message:
        """Create Message

        Endpoint for sending text messages and picture messages using V2 messaging.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param message_request: (required)
        :type message_request: MessageRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_message_serialize(
            account_id=account_id,
            message_request=message_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "Message",
            '400': "CreateMessageRequestError",
            '401': "MessagingRequestError",
            '403': "MessagingRequestError",
            '404': "MessagingRequestError",
            '405': "MessagingRequestError",
            '406': "MessagingRequestError",
            '415': "MessagingRequestError",
            '429': "MessagingRequestError",
            '500': "MessagingRequestError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_message_with_http_info(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        message_request: MessageRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[Message]:
        """Create Message

        Endpoint for sending text messages and picture messages using V2 messaging.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param message_request: (required)
        :type message_request: MessageRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_message_serialize(
            account_id=account_id,
            message_request=message_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "Message",
            '400': "CreateMessageRequestError",
            '401': "MessagingRequestError",
            '403': "MessagingRequestError",
            '404': "MessagingRequestError",
            '405': "MessagingRequestError",
            '406': "MessagingRequestError",
            '415': "MessagingRequestError",
            '429': "MessagingRequestError",
            '500': "MessagingRequestError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_message_without_preload_content(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        message_request: MessageRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Create Message

        Endpoint for sending text messages and picture messages using V2 messaging.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param message_request: (required)
        :type message_request: MessageRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_message_serialize(
            account_id=account_id,
            message_request=message_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "Message",
            '400': "CreateMessageRequestError",
            '401': "MessagingRequestError",
            '403': "MessagingRequestError",
            '404': "MessagingRequestError",
            '405': "MessagingRequestError",
            '406': "MessagingRequestError",
            '415': "MessagingRequestError",
            '429': "MessagingRequestError",
            '500': "MessagingRequestError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_message_serialize(
        self,
        account_id,
        message_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://messaging.bandwidth.com/api/v2'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if account_id is not None:
            _path_params['accountId'] = account_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if message_request is not None:
            _body_params = message_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Basic'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/users/{accountId}/messages',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_messages(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        message_id: Annotated[Optional[StrictStr], Field(description="The ID of the message to search for. Special characters need to be encoded using URL encoding. Message IDs could come in different formats, e.g., 9e0df4ca-b18d-40d7-a59f-82fcdf5ae8e6 and 1589228074636lm4k2je7j7jklbn2 are valid message ID formats. Note that you must include at least one query parameter.")] = None,
        source_tn: Annotated[Optional[StrictStr], Field(description="The phone number that sent the message. Accepted values are: a single full phone number a comma separated list of full phone numbers (maximum of 10) or a single partial phone number (minimum of 5 characters e.g. '%2B1919').")] = None,
        destination_tn: Annotated[Optional[StrictStr], Field(description="The phone number that received the message. Accepted values are: a single full phone number a comma separated list of full phone numbers (maximum of 10) or a single partial phone number (minimum of 5 characters e.g. '%2B1919').")] = None,
        message_status: Annotated[Optional[MessageStatusEnum], Field(description="The status of the message. One of RECEIVED QUEUED SENDING SENT FAILED DELIVERED ACCEPTED UNDELIVERED.")] = None,
        message_direction: Annotated[Optional[ListMessageDirectionEnum], Field(description="The direction of the message. One of INBOUND OUTBOUND.")] = None,
        carrier_name: Annotated[Optional[StrictStr], Field(description="The name of the carrier used for this message. Possible values include but are not limited to Verizon and TMobile. Special characters need to be encoded using URL encoding (i.e. AT&T should be passed as AT%26T).")] = None,
        message_type: Annotated[Optional[MessageTypeEnum], Field(description="The type of message. Either sms or mms.")] = None,
        error_code: Annotated[Optional[StrictInt], Field(description="The error code of the message.")] = None,
        from_date_time: Annotated[Optional[StrictStr], Field(description="The start of the date range to search in ISO 8601 format. Uses the message receive time. The date range to search in is currently 14 days.")] = None,
        to_date_time: Annotated[Optional[StrictStr], Field(description="The end of the date range to search in ISO 8601 format. Uses the message receive time. The date range to search in is currently 14 days.")] = None,
        campaign_id: Annotated[Optional[StrictStr], Field(description="The campaign ID of the message.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The field and direction to sort by combined with a colon. Direction is either asc or desc.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A base64 encoded value used for pagination of results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="The maximum records requested in search result. Default 100. The sum of limit and after cannot be more than 10000.")] = None,
        limit_total_count: Annotated[Optional[StrictBool], Field(description="When set to true, the response's totalCount field will have a maximum value of 10,000. When set to false, or excluded, this will give an accurate totalCount of all messages that match the provided filters. If you are experiencing latency, try using this parameter to limit your results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> MessagesList:
        """List Messages

        Returns a list of messages based on query parameters.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param message_id: The ID of the message to search for. Special characters need to be encoded using URL encoding. Message IDs could come in different formats, e.g., 9e0df4ca-b18d-40d7-a59f-82fcdf5ae8e6 and 1589228074636lm4k2je7j7jklbn2 are valid message ID formats. Note that you must include at least one query parameter.
        :type message_id: str
        :param source_tn: The phone number that sent the message. Accepted values are: a single full phone number a comma separated list of full phone numbers (maximum of 10) or a single partial phone number (minimum of 5 characters e.g. '%2B1919').
        :type source_tn: str
        :param destination_tn: The phone number that received the message. Accepted values are: a single full phone number a comma separated list of full phone numbers (maximum of 10) or a single partial phone number (minimum of 5 characters e.g. '%2B1919').
        :type destination_tn: str
        :param message_status: The status of the message. One of RECEIVED QUEUED SENDING SENT FAILED DELIVERED ACCEPTED UNDELIVERED.
        :type message_status: MessageStatusEnum
        :param message_direction: The direction of the message. One of INBOUND OUTBOUND.
        :type message_direction: ListMessageDirectionEnum
        :param carrier_name: The name of the carrier used for this message. Possible values include but are not limited to Verizon and TMobile. Special characters need to be encoded using URL encoding (i.e. AT&T should be passed as AT%26T).
        :type carrier_name: str
        :param message_type: The type of message. Either sms or mms.
        :type message_type: MessageTypeEnum
        :param error_code: The error code of the message.
        :type error_code: int
        :param from_date_time: The start of the date range to search in ISO 8601 format. Uses the message receive time. The date range to search in is currently 14 days.
        :type from_date_time: str
        :param to_date_time: The end of the date range to search in ISO 8601 format. Uses the message receive time. The date range to search in is currently 14 days.
        :type to_date_time: str
        :param campaign_id: The campaign ID of the message.
        :type campaign_id: str
        :param sort: The field and direction to sort by combined with a colon. Direction is either asc or desc.
        :type sort: str
        :param page_token: A base64 encoded value used for pagination of results.
        :type page_token: str
        :param limit: The maximum records requested in search result. Default 100. The sum of limit and after cannot be more than 10000.
        :type limit: int
        :param limit_total_count: When set to true, the response's totalCount field will have a maximum value of 10,000. When set to false, or excluded, this will give an accurate totalCount of all messages that match the provided filters. If you are experiencing latency, try using this parameter to limit your results.
        :type limit_total_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_messages_serialize(
            account_id=account_id,
            message_id=message_id,
            source_tn=source_tn,
            destination_tn=destination_tn,
            message_status=message_status,
            message_direction=message_direction,
            carrier_name=carrier_name,
            message_type=message_type,
            error_code=error_code,
            from_date_time=from_date_time,
            to_date_time=to_date_time,
            campaign_id=campaign_id,
            sort=sort,
            page_token=page_token,
            limit=limit,
            limit_total_count=limit_total_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MessagesList",
            '400': "MessagingRequestError",
            '401': "MessagingRequestError",
            '403': "MessagingRequestError",
            '404': "MessagingRequestError",
            '415': "MessagingRequestError",
            '429': "MessagingRequestError",
            '500': "MessagingRequestError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_messages_with_http_info(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        message_id: Annotated[Optional[StrictStr], Field(description="The ID of the message to search for. Special characters need to be encoded using URL encoding. Message IDs could come in different formats, e.g., 9e0df4ca-b18d-40d7-a59f-82fcdf5ae8e6 and 1589228074636lm4k2je7j7jklbn2 are valid message ID formats. Note that you must include at least one query parameter.")] = None,
        source_tn: Annotated[Optional[StrictStr], Field(description="The phone number that sent the message. Accepted values are: a single full phone number a comma separated list of full phone numbers (maximum of 10) or a single partial phone number (minimum of 5 characters e.g. '%2B1919').")] = None,
        destination_tn: Annotated[Optional[StrictStr], Field(description="The phone number that received the message. Accepted values are: a single full phone number a comma separated list of full phone numbers (maximum of 10) or a single partial phone number (minimum of 5 characters e.g. '%2B1919').")] = None,
        message_status: Annotated[Optional[MessageStatusEnum], Field(description="The status of the message. One of RECEIVED QUEUED SENDING SENT FAILED DELIVERED ACCEPTED UNDELIVERED.")] = None,
        message_direction: Annotated[Optional[ListMessageDirectionEnum], Field(description="The direction of the message. One of INBOUND OUTBOUND.")] = None,
        carrier_name: Annotated[Optional[StrictStr], Field(description="The name of the carrier used for this message. Possible values include but are not limited to Verizon and TMobile. Special characters need to be encoded using URL encoding (i.e. AT&T should be passed as AT%26T).")] = None,
        message_type: Annotated[Optional[MessageTypeEnum], Field(description="The type of message. Either sms or mms.")] = None,
        error_code: Annotated[Optional[StrictInt], Field(description="The error code of the message.")] = None,
        from_date_time: Annotated[Optional[StrictStr], Field(description="The start of the date range to search in ISO 8601 format. Uses the message receive time. The date range to search in is currently 14 days.")] = None,
        to_date_time: Annotated[Optional[StrictStr], Field(description="The end of the date range to search in ISO 8601 format. Uses the message receive time. The date range to search in is currently 14 days.")] = None,
        campaign_id: Annotated[Optional[StrictStr], Field(description="The campaign ID of the message.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The field and direction to sort by combined with a colon. Direction is either asc or desc.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A base64 encoded value used for pagination of results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="The maximum records requested in search result. Default 100. The sum of limit and after cannot be more than 10000.")] = None,
        limit_total_count: Annotated[Optional[StrictBool], Field(description="When set to true, the response's totalCount field will have a maximum value of 10,000. When set to false, or excluded, this will give an accurate totalCount of all messages that match the provided filters. If you are experiencing latency, try using this parameter to limit your results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[MessagesList]:
        """List Messages

        Returns a list of messages based on query parameters.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param message_id: The ID of the message to search for. Special characters need to be encoded using URL encoding. Message IDs could come in different formats, e.g., 9e0df4ca-b18d-40d7-a59f-82fcdf5ae8e6 and 1589228074636lm4k2je7j7jklbn2 are valid message ID formats. Note that you must include at least one query parameter.
        :type message_id: str
        :param source_tn: The phone number that sent the message. Accepted values are: a single full phone number a comma separated list of full phone numbers (maximum of 10) or a single partial phone number (minimum of 5 characters e.g. '%2B1919').
        :type source_tn: str
        :param destination_tn: The phone number that received the message. Accepted values are: a single full phone number a comma separated list of full phone numbers (maximum of 10) or a single partial phone number (minimum of 5 characters e.g. '%2B1919').
        :type destination_tn: str
        :param message_status: The status of the message. One of RECEIVED QUEUED SENDING SENT FAILED DELIVERED ACCEPTED UNDELIVERED.
        :type message_status: MessageStatusEnum
        :param message_direction: The direction of the message. One of INBOUND OUTBOUND.
        :type message_direction: ListMessageDirectionEnum
        :param carrier_name: The name of the carrier used for this message. Possible values include but are not limited to Verizon and TMobile. Special characters need to be encoded using URL encoding (i.e. AT&T should be passed as AT%26T).
        :type carrier_name: str
        :param message_type: The type of message. Either sms or mms.
        :type message_type: MessageTypeEnum
        :param error_code: The error code of the message.
        :type error_code: int
        :param from_date_time: The start of the date range to search in ISO 8601 format. Uses the message receive time. The date range to search in is currently 14 days.
        :type from_date_time: str
        :param to_date_time: The end of the date range to search in ISO 8601 format. Uses the message receive time. The date range to search in is currently 14 days.
        :type to_date_time: str
        :param campaign_id: The campaign ID of the message.
        :type campaign_id: str
        :param sort: The field and direction to sort by combined with a colon. Direction is either asc or desc.
        :type sort: str
        :param page_token: A base64 encoded value used for pagination of results.
        :type page_token: str
        :param limit: The maximum records requested in search result. Default 100. The sum of limit and after cannot be more than 10000.
        :type limit: int
        :param limit_total_count: When set to true, the response's totalCount field will have a maximum value of 10,000. When set to false, or excluded, this will give an accurate totalCount of all messages that match the provided filters. If you are experiencing latency, try using this parameter to limit your results.
        :type limit_total_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_messages_serialize(
            account_id=account_id,
            message_id=message_id,
            source_tn=source_tn,
            destination_tn=destination_tn,
            message_status=message_status,
            message_direction=message_direction,
            carrier_name=carrier_name,
            message_type=message_type,
            error_code=error_code,
            from_date_time=from_date_time,
            to_date_time=to_date_time,
            campaign_id=campaign_id,
            sort=sort,
            page_token=page_token,
            limit=limit,
            limit_total_count=limit_total_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MessagesList",
            '400': "MessagingRequestError",
            '401': "MessagingRequestError",
            '403': "MessagingRequestError",
            '404': "MessagingRequestError",
            '415': "MessagingRequestError",
            '429': "MessagingRequestError",
            '500': "MessagingRequestError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_messages_without_preload_content(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        message_id: Annotated[Optional[StrictStr], Field(description="The ID of the message to search for. Special characters need to be encoded using URL encoding. Message IDs could come in different formats, e.g., 9e0df4ca-b18d-40d7-a59f-82fcdf5ae8e6 and 1589228074636lm4k2je7j7jklbn2 are valid message ID formats. Note that you must include at least one query parameter.")] = None,
        source_tn: Annotated[Optional[StrictStr], Field(description="The phone number that sent the message. Accepted values are: a single full phone number a comma separated list of full phone numbers (maximum of 10) or a single partial phone number (minimum of 5 characters e.g. '%2B1919').")] = None,
        destination_tn: Annotated[Optional[StrictStr], Field(description="The phone number that received the message. Accepted values are: a single full phone number a comma separated list of full phone numbers (maximum of 10) or a single partial phone number (minimum of 5 characters e.g. '%2B1919').")] = None,
        message_status: Annotated[Optional[MessageStatusEnum], Field(description="The status of the message. One of RECEIVED QUEUED SENDING SENT FAILED DELIVERED ACCEPTED UNDELIVERED.")] = None,
        message_direction: Annotated[Optional[ListMessageDirectionEnum], Field(description="The direction of the message. One of INBOUND OUTBOUND.")] = None,
        carrier_name: Annotated[Optional[StrictStr], Field(description="The name of the carrier used for this message. Possible values include but are not limited to Verizon and TMobile. Special characters need to be encoded using URL encoding (i.e. AT&T should be passed as AT%26T).")] = None,
        message_type: Annotated[Optional[MessageTypeEnum], Field(description="The type of message. Either sms or mms.")] = None,
        error_code: Annotated[Optional[StrictInt], Field(description="The error code of the message.")] = None,
        from_date_time: Annotated[Optional[StrictStr], Field(description="The start of the date range to search in ISO 8601 format. Uses the message receive time. The date range to search in is currently 14 days.")] = None,
        to_date_time: Annotated[Optional[StrictStr], Field(description="The end of the date range to search in ISO 8601 format. Uses the message receive time. The date range to search in is currently 14 days.")] = None,
        campaign_id: Annotated[Optional[StrictStr], Field(description="The campaign ID of the message.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The field and direction to sort by combined with a colon. Direction is either asc or desc.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A base64 encoded value used for pagination of results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="The maximum records requested in search result. Default 100. The sum of limit and after cannot be more than 10000.")] = None,
        limit_total_count: Annotated[Optional[StrictBool], Field(description="When set to true, the response's totalCount field will have a maximum value of 10,000. When set to false, or excluded, this will give an accurate totalCount of all messages that match the provided filters. If you are experiencing latency, try using this parameter to limit your results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """List Messages

        Returns a list of messages based on query parameters.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param message_id: The ID of the message to search for. Special characters need to be encoded using URL encoding. Message IDs could come in different formats, e.g., 9e0df4ca-b18d-40d7-a59f-82fcdf5ae8e6 and 1589228074636lm4k2je7j7jklbn2 are valid message ID formats. Note that you must include at least one query parameter.
        :type message_id: str
        :param source_tn: The phone number that sent the message. Accepted values are: a single full phone number a comma separated list of full phone numbers (maximum of 10) or a single partial phone number (minimum of 5 characters e.g. '%2B1919').
        :type source_tn: str
        :param destination_tn: The phone number that received the message. Accepted values are: a single full phone number a comma separated list of full phone numbers (maximum of 10) or a single partial phone number (minimum of 5 characters e.g. '%2B1919').
        :type destination_tn: str
        :param message_status: The status of the message. One of RECEIVED QUEUED SENDING SENT FAILED DELIVERED ACCEPTED UNDELIVERED.
        :type message_status: MessageStatusEnum
        :param message_direction: The direction of the message. One of INBOUND OUTBOUND.
        :type message_direction: ListMessageDirectionEnum
        :param carrier_name: The name of the carrier used for this message. Possible values include but are not limited to Verizon and TMobile. Special characters need to be encoded using URL encoding (i.e. AT&T should be passed as AT%26T).
        :type carrier_name: str
        :param message_type: The type of message. Either sms or mms.
        :type message_type: MessageTypeEnum
        :param error_code: The error code of the message.
        :type error_code: int
        :param from_date_time: The start of the date range to search in ISO 8601 format. Uses the message receive time. The date range to search in is currently 14 days.
        :type from_date_time: str
        :param to_date_time: The end of the date range to search in ISO 8601 format. Uses the message receive time. The date range to search in is currently 14 days.
        :type to_date_time: str
        :param campaign_id: The campaign ID of the message.
        :type campaign_id: str
        :param sort: The field and direction to sort by combined with a colon. Direction is either asc or desc.
        :type sort: str
        :param page_token: A base64 encoded value used for pagination of results.
        :type page_token: str
        :param limit: The maximum records requested in search result. Default 100. The sum of limit and after cannot be more than 10000.
        :type limit: int
        :param limit_total_count: When set to true, the response's totalCount field will have a maximum value of 10,000. When set to false, or excluded, this will give an accurate totalCount of all messages that match the provided filters. If you are experiencing latency, try using this parameter to limit your results.
        :type limit_total_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_messages_serialize(
            account_id=account_id,
            message_id=message_id,
            source_tn=source_tn,
            destination_tn=destination_tn,
            message_status=message_status,
            message_direction=message_direction,
            carrier_name=carrier_name,
            message_type=message_type,
            error_code=error_code,
            from_date_time=from_date_time,
            to_date_time=to_date_time,
            campaign_id=campaign_id,
            sort=sort,
            page_token=page_token,
            limit=limit,
            limit_total_count=limit_total_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MessagesList",
            '400': "MessagingRequestError",
            '401': "MessagingRequestError",
            '403': "MessagingRequestError",
            '404': "MessagingRequestError",
            '415': "MessagingRequestError",
            '429': "MessagingRequestError",
            '500': "MessagingRequestError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_messages_serialize(
        self,
        account_id,
        message_id,
        source_tn,
        destination_tn,
        message_status,
        message_direction,
        carrier_name,
        message_type,
        error_code,
        from_date_time,
        to_date_time,
        campaign_id,
        sort,
        page_token,
        limit,
        limit_total_count,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://messaging.bandwidth.com/api/v2'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if account_id is not None:
            _path_params['accountId'] = account_id
        # process the query parameters
        if message_id is not None:
            
            _query_params.append(('messageId', message_id))
            
        if source_tn is not None:
            
            _query_params.append(('sourceTn', source_tn))
            
        if destination_tn is not None:
            
            _query_params.append(('destinationTn', destination_tn))
            
        if message_status is not None:
            
            _query_params.append(('messageStatus', message_status.value))
            
        if message_direction is not None:
            
            _query_params.append(('messageDirection', message_direction.value))
            
        if carrier_name is not None:
            
            _query_params.append(('carrierName', carrier_name))
            
        if message_type is not None:
            
            _query_params.append(('messageType', message_type.value))
            
        if error_code is not None:
            
            _query_params.append(('errorCode', error_code))
            
        if from_date_time is not None:
            
            _query_params.append(('fromDateTime', from_date_time))
            
        if to_date_time is not None:
            
            _query_params.append(('toDateTime', to_date_time))
            
        if campaign_id is not None:
            
            _query_params.append(('campaignId', campaign_id))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if limit_total_count is not None:
            
            _query_params.append(('limitTotalCount', limit_total_count))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Basic'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/users/{accountId}/messages',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


