# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import List
from typing_extensions import Annotated
from bandwidth.models.call_transcription_metadata import CallTranscriptionMetadata
from bandwidth.models.call_transcription_response import CallTranscriptionResponse

from bandwidth.api_client import ApiClient, RequestSerialized
from bandwidth.api_response import ApiResponse
from bandwidth.rest import RESTResponseType


class TranscriptionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def delete_real_time_transcription(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        transcription_id: Annotated[StrictStr, Field(description="Programmable Voice API Transcription ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """Delete a specific transcription

        Delete the specified transcription that was created on this call via [startTranscription](/docs/voice/bxml/startTranscription).  Note: After the deletion is requested and a `200` is returned, the transcription will not be accessible anymore. However, it is not deleted immediately. This deletion process, while transparent and irreversible, can take an additional 24 to 48 hours.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param transcription_id: Programmable Voice API Transcription ID. (required)
        :type transcription_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_real_time_transcription_serialize(
            account_id=account_id,
            call_id=call_id,
            transcription_id=transcription_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_real_time_transcription_with_http_info(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        transcription_id: Annotated[StrictStr, Field(description="Programmable Voice API Transcription ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """Delete a specific transcription

        Delete the specified transcription that was created on this call via [startTranscription](/docs/voice/bxml/startTranscription).  Note: After the deletion is requested and a `200` is returned, the transcription will not be accessible anymore. However, it is not deleted immediately. This deletion process, while transparent and irreversible, can take an additional 24 to 48 hours.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param transcription_id: Programmable Voice API Transcription ID. (required)
        :type transcription_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_real_time_transcription_serialize(
            account_id=account_id,
            call_id=call_id,
            transcription_id=transcription_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_real_time_transcription_without_preload_content(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        transcription_id: Annotated[StrictStr, Field(description="Programmable Voice API Transcription ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Delete a specific transcription

        Delete the specified transcription that was created on this call via [startTranscription](/docs/voice/bxml/startTranscription).  Note: After the deletion is requested and a `200` is returned, the transcription will not be accessible anymore. However, it is not deleted immediately. This deletion process, while transparent and irreversible, can take an additional 24 to 48 hours.

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param transcription_id: Programmable Voice API Transcription ID. (required)
        :type transcription_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_real_time_transcription_serialize(
            account_id=account_id,
            call_id=call_id,
            transcription_id=transcription_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_real_time_transcription_serialize(
        self,
        account_id,
        call_id,
        transcription_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://voice.bandwidth.com/api/v2'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if account_id is not None:
            _path_params['accountId'] = account_id
        if call_id is not None:
            _path_params['callId'] = call_id
        if transcription_id is not None:
            _path_params['transcriptionId'] = transcription_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Basic'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/accounts/{accountId}/calls/{callId}/transcriptions/{transcriptionId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_real_time_transcription(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        transcription_id: Annotated[StrictStr, Field(description="Programmable Voice API Transcription ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> CallTranscriptionResponse:
        """Retrieve a specific transcription

        Retrieve the specified transcription that was created on this call via [startTranscription](/docs/voice/bxml/startTranscription).

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param transcription_id: Programmable Voice API Transcription ID. (required)
        :type transcription_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_real_time_transcription_serialize(
            account_id=account_id,
            call_id=call_id,
            transcription_id=transcription_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CallTranscriptionResponse",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_real_time_transcription_with_http_info(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        transcription_id: Annotated[StrictStr, Field(description="Programmable Voice API Transcription ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[CallTranscriptionResponse]:
        """Retrieve a specific transcription

        Retrieve the specified transcription that was created on this call via [startTranscription](/docs/voice/bxml/startTranscription).

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param transcription_id: Programmable Voice API Transcription ID. (required)
        :type transcription_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_real_time_transcription_serialize(
            account_id=account_id,
            call_id=call_id,
            transcription_id=transcription_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CallTranscriptionResponse",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_real_time_transcription_without_preload_content(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        transcription_id: Annotated[StrictStr, Field(description="Programmable Voice API Transcription ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Retrieve a specific transcription

        Retrieve the specified transcription that was created on this call via [startTranscription](/docs/voice/bxml/startTranscription).

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param transcription_id: Programmable Voice API Transcription ID. (required)
        :type transcription_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_real_time_transcription_serialize(
            account_id=account_id,
            call_id=call_id,
            transcription_id=transcription_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CallTranscriptionResponse",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_real_time_transcription_serialize(
        self,
        account_id,
        call_id,
        transcription_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://voice.bandwidth.com/api/v2'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if account_id is not None:
            _path_params['accountId'] = account_id
        if call_id is not None:
            _path_params['callId'] = call_id
        if transcription_id is not None:
            _path_params['transcriptionId'] = transcription_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Basic'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/accounts/{accountId}/calls/{callId}/transcriptions/{transcriptionId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_real_time_transcriptions(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> List[CallTranscriptionMetadata]:
        """Enumerate transcriptions made with StartTranscription

        Enumerates the transcriptions created on this call via [startTranscription](/docs/voice/bxml/startTranscription).

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_real_time_transcriptions_serialize(
            account_id=account_id,
            call_id=call_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CallTranscriptionMetadata]",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_real_time_transcriptions_with_http_info(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[List[CallTranscriptionMetadata]]:
        """Enumerate transcriptions made with StartTranscription

        Enumerates the transcriptions created on this call via [startTranscription](/docs/voice/bxml/startTranscription).

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_real_time_transcriptions_serialize(
            account_id=account_id,
            call_id=call_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CallTranscriptionMetadata]",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_real_time_transcriptions_without_preload_content(
        self,
        account_id: Annotated[StrictStr, Field(description="Your Bandwidth Account ID.")],
        call_id: Annotated[StrictStr, Field(description="Programmable Voice API Call ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Enumerate transcriptions made with StartTranscription

        Enumerates the transcriptions created on this call via [startTranscription](/docs/voice/bxml/startTranscription).

        :param account_id: Your Bandwidth Account ID. (required)
        :type account_id: str
        :param call_id: Programmable Voice API Call ID. (required)
        :type call_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_real_time_transcriptions_serialize(
            account_id=account_id,
            call_id=call_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CallTranscriptionMetadata]",
            '400': "VoiceApiError",
            '401': "VoiceApiError",
            '403': "VoiceApiError",
            '404': "VoiceApiError",
            '405': "VoiceApiError",
            '415': "VoiceApiError",
            '429': "VoiceApiError",
            '500': "VoiceApiError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_real_time_transcriptions_serialize(
        self,
        account_id,
        call_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://voice.bandwidth.com/api/v2'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if account_id is not None:
            _path_params['accountId'] = account_id
        if call_id is not None:
            _path_params['callId'] = call_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Basic'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/accounts/{accountId}/calls/{callId}/transcriptions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


