# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class FailureWebhook(BaseModel):
    """
    FailureWebhook
    """ # noqa: E501
    account_id: Optional[StrictStr] = Field(default=None, description="User's account ID.", alias="accountId")
    phone_number: Optional[Annotated[str, Field(min_length=12, strict=True, max_length=12)]] = Field(default=None, description="Toll-free telephone number in E.164 format.", alias="phoneNumber")
    error_code: Optional[StrictStr] = Field(default=None, description="An error code indicating what error was encountered. This code can be interpreted as an HTTP status code in regards to the error that was encountered.", alias="errorCode")
    error_message: Optional[StrictStr] = Field(default=None, description="A description of the error that was encountered.", alias="errorMessage")
    errors: Optional[List[StrictStr]] = Field(default=None, description="Details of the errors that were encountered when processing the request.")
    internal_ticket_number: Optional[StrictStr] = Field(default=None, description="Unique identifier (UUID) generated by Bandwidth to assist in tracking the verification status of a toll-free number.", alias="internalTicketNumber")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["accountId", "phoneNumber", "errorCode", "errorMessage", "errors", "internalTicketNumber"]

    @field_validator('phone_number')
    def phone_number_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\+1(800|833|844|855|866|877|888)[2-9]\d{6}$", value):
            raise ValueError(r"must validate the regular expression /^\+1(800|833|844|855|866|877|888)[2-9]\d{6}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FailureWebhook from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FailureWebhook from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountId": obj.get("accountId"),
            "phoneNumber": obj.get("phoneNumber"),
            "errorCode": obj.get("errorCode"),
            "errorMessage": obj.get("errorMessage"),
            "errors": obj.get("errors"),
            "internalTicketNumber": obj.get("internalTicketNumber")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


