# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from bandwidth.models.message_direction_enum import MessageDirectionEnum
from bandwidth.models.multi_channel_message_channel_enum import MultiChannelMessageChannelEnum
from bandwidth.models.multi_channel_message_content import MultiChannelMessageContent
from bandwidth.models.priority_enum import PriorityEnum
from bandwidth.models.rbm_location_response import RbmLocationResponse
from bandwidth.models.rbm_suggestion_response import RbmSuggestionResponse
from typing import Optional, Set
from typing_extensions import Self

class InboundCallbackMessage(BaseModel):
    """
    InboundCallbackMessage
    """ # noqa: E501
    id: StrictStr = Field(description="A unique identifier of the message.")
    owner: StrictStr = Field(description="The Bandwidth phone number or alphanumeric identifier associated with the message.")
    application_id: StrictStr = Field(description="The ID of the Application your from number or senderId is associated with in the Bandwidth Phone Number Dashboard.", alias="applicationId")
    time: datetime
    segment_count: StrictInt = Field(description="The number of segments the user's message is broken into before sending over carrier networks.", alias="segmentCount")
    direction: MessageDirectionEnum
    to: List[StrictStr] = Field(description="The phone number recipients of the message.")
    var_from: StrictStr = Field(description="The Bandwidth phone number or alphanumeric identifier the message was sent from.", alias="from")
    text: Optional[StrictStr] = None
    tag: Optional[StrictStr] = Field(default=None, description="A custom string that will be included in callback events of the message. Max 1024 characters.")
    media: Optional[List[StrictStr]] = Field(default=None, description="Optional media, not applicable for sms")
    priority: Optional[PriorityEnum] = None
    channel: Optional[MultiChannelMessageChannelEnum] = None
    content: Optional[MultiChannelMessageContent] = None
    suggestion_response: Optional[RbmSuggestionResponse] = Field(default=None, alias="suggestionResponse")
    location_response: Optional[RbmLocationResponse] = Field(default=None, alias="locationResponse")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "owner", "applicationId", "time", "segmentCount", "direction", "to", "from", "text", "tag", "media", "priority", "channel", "content", "suggestionResponse", "locationResponse"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InboundCallbackMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of content
        if self.content:
            _dict['content'] = self.content.to_dict()
        # override the default output from pydantic by calling `to_dict()` of suggestion_response
        if self.suggestion_response:
            _dict['suggestionResponse'] = self.suggestion_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of location_response
        if self.location_response:
            _dict['locationResponse'] = self.location_response.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InboundCallbackMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "owner": obj.get("owner"),
            "applicationId": obj.get("applicationId"),
            "time": obj.get("time"),
            "segmentCount": obj.get("segmentCount"),
            "direction": obj.get("direction"),
            "to": obj.get("to"),
            "from": obj.get("from"),
            "text": obj.get("text"),
            "tag": obj.get("tag"),
            "media": obj.get("media"),
            "priority": obj.get("priority"),
            "channel": obj.get("channel"),
            "content": MultiChannelMessageContent.from_dict(obj["content"]) if obj.get("content") is not None else None,
            "suggestionResponse": RbmSuggestionResponse.from_dict(obj["suggestionResponse"]) if obj.get("suggestionResponse") is not None else None,
            "locationResponse": RbmLocationResponse.from_dict(obj["locationResponse"]) if obj.get("locationResponse") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


