# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class LookupResult(BaseModel):
    """
    Carrier information results for the specified telephone number.
    """ # noqa: E501
    response_code: Optional[StrictInt] = Field(default=None, description="Our vendor's response code.", alias="Response Code")
    message: Optional[StrictStr] = Field(default=None, description="Message associated with the response code.", alias="Message")
    e_164_format: Optional[StrictStr] = Field(default=None, description="The telephone number in E.164 format.", alias="E.164 Format")
    formatted: Optional[StrictStr] = Field(default=None, description="The formatted version of the telephone number.", alias="Formatted")
    country: Optional[StrictStr] = Field(default=None, description="The country of the telephone number.", alias="Country")
    line_type: Optional[StrictStr] = Field(default=None, description="The line type of the telephone number.", alias="Line Type")
    line_provider: Optional[StrictStr] = Field(default=None, description="The messaging service provider of the telephone number.", alias="Line Provider")
    mobile_country_code: Optional[StrictStr] = Field(default=None, description="The first half of the Home Network Identity (HNI).", alias="Mobile Country Code")
    mobile_network_code: Optional[StrictStr] = Field(default=None, description="The second half of the HNI.", alias="Mobile Network Code")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["Response Code", "Message", "E.164 Format", "Formatted", "Country", "Line Type", "Line Provider", "Mobile Country Code", "Mobile Network Code"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LookupResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LookupResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Response Code": obj.get("Response Code"),
            "Message": obj.get("Message"),
            "E.164 Format": obj.get("E.164 Format"),
            "Formatted": obj.get("Formatted"),
            "Country": obj.get("Country"),
            "Line Type": obj.get("Line Type"),
            "Line Provider": obj.get("Line Provider"),
            "Mobile Country Code": obj.get("Mobile Country Code"),
            "Mobile Network Code": obj.get("Mobile Network Code")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


