# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from bandwidth.models.multi_channel_action_calendar_event import MultiChannelActionCalendarEvent
from bandwidth.models.rbm_action_base import RbmActionBase
from bandwidth.models.rbm_action_dial import RbmActionDial
from bandwidth.models.rbm_action_open_url import RbmActionOpenUrl
from bandwidth.models.rbm_action_view_location import RbmActionViewLocation
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

MULTICHANNELACTION_ONE_OF_SCHEMAS = ["MultiChannelActionCalendarEvent", "RbmActionBase", "RbmActionDial", "RbmActionOpenUrl", "RbmActionViewLocation"]

class MultiChannelAction(BaseModel):
    """
    MultiChannelAction
    """
    # data type: RbmActionBase
    oneof_schema_1_validator: Optional[RbmActionBase] = None
    # data type: RbmActionDial
    oneof_schema_2_validator: Optional[RbmActionDial] = None
    # data type: RbmActionViewLocation
    oneof_schema_3_validator: Optional[RbmActionViewLocation] = None
    # data type: MultiChannelActionCalendarEvent
    oneof_schema_4_validator: Optional[MultiChannelActionCalendarEvent] = None
    # data type: RbmActionOpenUrl
    oneof_schema_5_validator: Optional[RbmActionOpenUrl] = None
    actual_instance: Optional[Union[MultiChannelActionCalendarEvent, RbmActionBase, RbmActionDial, RbmActionOpenUrl, RbmActionViewLocation]] = None
    one_of_schemas: Set[str] = { "MultiChannelActionCalendarEvent", "RbmActionBase", "RbmActionDial", "RbmActionOpenUrl", "RbmActionViewLocation" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = MultiChannelAction.model_construct()
        error_messages = []
        match = 0
        # validate data type: RbmActionBase
        if not isinstance(v, RbmActionBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RbmActionBase`")
        else:
            match += 1
        # validate data type: RbmActionDial
        if not isinstance(v, RbmActionDial):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RbmActionDial`")
        else:
            match += 1
        # validate data type: RbmActionViewLocation
        if not isinstance(v, RbmActionViewLocation):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RbmActionViewLocation`")
        else:
            match += 1
        # validate data type: MultiChannelActionCalendarEvent
        if not isinstance(v, MultiChannelActionCalendarEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MultiChannelActionCalendarEvent`")
        else:
            match += 1
        # validate data type: RbmActionOpenUrl
        if not isinstance(v, RbmActionOpenUrl):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RbmActionOpenUrl`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in MultiChannelAction with oneOf schemas: MultiChannelActionCalendarEvent, RbmActionBase, RbmActionDial, RbmActionOpenUrl, RbmActionViewLocation. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in MultiChannelAction with oneOf schemas: MultiChannelActionCalendarEvent, RbmActionBase, RbmActionDial, RbmActionOpenUrl, RbmActionViewLocation. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into RbmActionBase
        try:
            instance.actual_instance = RbmActionBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RbmActionDial
        try:
            instance.actual_instance = RbmActionDial.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RbmActionViewLocation
        try:
            instance.actual_instance = RbmActionViewLocation.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MultiChannelActionCalendarEvent
        try:
            instance.actual_instance = MultiChannelActionCalendarEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RbmActionOpenUrl
        try:
            instance.actual_instance = RbmActionOpenUrl.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into MultiChannelAction with oneOf schemas: MultiChannelActionCalendarEvent, RbmActionBase, RbmActionDial, RbmActionOpenUrl, RbmActionViewLocation. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into MultiChannelAction with oneOf schemas: MultiChannelActionCalendarEvent, RbmActionBase, RbmActionDial, RbmActionOpenUrl, RbmActionViewLocation. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], MultiChannelActionCalendarEvent, RbmActionBase, RbmActionDial, RbmActionOpenUrl, RbmActionViewLocation]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


