# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from bandwidth.models.mms_message_content import MmsMessageContent
from bandwidth.models.rbm_message_content_rich_card import RbmMessageContentRichCard
from bandwidth.models.rbm_message_content_text import RbmMessageContentText
from bandwidth.models.rbm_message_media import RbmMessageMedia
from bandwidth.models.sms_message_content import SmsMessageContent
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

MULTICHANNELCHANNELLISTOBJECTCONTENT_ONE_OF_SCHEMAS = ["MmsMessageContent", "RbmMessageContentRichCard", "RbmMessageContentText", "RbmMessageMedia", "SmsMessageContent"]

class MultiChannelChannelListObjectContent(BaseModel):
    """
    The content of the message.
    """
    # data type: RbmMessageContentText
    oneof_schema_1_validator: Optional[RbmMessageContentText] = None
    # data type: RbmMessageMedia
    oneof_schema_2_validator: Optional[RbmMessageMedia] = None
    # data type: RbmMessageContentRichCard
    oneof_schema_3_validator: Optional[RbmMessageContentRichCard] = None
    # data type: SmsMessageContent
    oneof_schema_4_validator: Optional[SmsMessageContent] = None
    # data type: MmsMessageContent
    oneof_schema_5_validator: Optional[MmsMessageContent] = None
    actual_instance: Optional[Union[MmsMessageContent, RbmMessageContentRichCard, RbmMessageContentText, RbmMessageMedia, SmsMessageContent]] = None
    one_of_schemas: Set[str] = { "MmsMessageContent", "RbmMessageContentRichCard", "RbmMessageContentText", "RbmMessageMedia", "SmsMessageContent" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = MultiChannelChannelListObjectContent.model_construct()
        error_messages = []
        match = 0
        # validate data type: RbmMessageContentText
        if not isinstance(v, RbmMessageContentText):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RbmMessageContentText`")
        else:
            match += 1
        # validate data type: RbmMessageMedia
        if not isinstance(v, RbmMessageMedia):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RbmMessageMedia`")
        else:
            match += 1
        # validate data type: RbmMessageContentRichCard
        if not isinstance(v, RbmMessageContentRichCard):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RbmMessageContentRichCard`")
        else:
            match += 1
        # validate data type: SmsMessageContent
        if not isinstance(v, SmsMessageContent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SmsMessageContent`")
        else:
            match += 1
        # validate data type: MmsMessageContent
        if not isinstance(v, MmsMessageContent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MmsMessageContent`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in MultiChannelChannelListObjectContent with oneOf schemas: MmsMessageContent, RbmMessageContentRichCard, RbmMessageContentText, RbmMessageMedia, SmsMessageContent. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in MultiChannelChannelListObjectContent with oneOf schemas: MmsMessageContent, RbmMessageContentRichCard, RbmMessageContentText, RbmMessageMedia, SmsMessageContent. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into RbmMessageContentText
        try:
            instance.actual_instance = RbmMessageContentText.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RbmMessageMedia
        try:
            instance.actual_instance = RbmMessageMedia.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RbmMessageContentRichCard
        try:
            instance.actual_instance = RbmMessageContentRichCard.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SmsMessageContent
        try:
            instance.actual_instance = SmsMessageContent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MmsMessageContent
        try:
            instance.actual_instance = MmsMessageContent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into MultiChannelChannelListObjectContent with oneOf schemas: MmsMessageContent, RbmMessageContentRichCard, RbmMessageContentText, RbmMessageMedia, SmsMessageContent. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into MultiChannelChannelListObjectContent with oneOf schemas: MmsMessageContent, RbmMessageContentRichCard, RbmMessageContentText, RbmMessageMedia, SmsMessageContent. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], MmsMessageContent, RbmMessageContentRichCard, RbmMessageContentText, RbmMessageMedia, SmsMessageContent]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


