# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from bandwidth.models.card_width_enum import CardWidthEnum
from bandwidth.models.multi_channel_action import MultiChannelAction
from bandwidth.models.rbm_card_content import RbmCardContent
from typing import Optional, Set
from typing_extensions import Self

class RbmMessageCarouselCard(BaseModel):
    """
    RbmMessageCarouselCard
    """ # noqa: E501
    card_width: CardWidthEnum = Field(alias="cardWidth")
    card_contents: Annotated[List[RbmCardContent], Field(max_length=10)] = Field(alias="cardContents")
    suggestions: Optional[Annotated[List[MultiChannelAction], Field(max_length=11)]] = Field(default=None, description="An array of suggested actions for the recipient.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["cardWidth", "cardContents", "suggestions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RbmMessageCarouselCard from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in card_contents (list)
        _items = []
        if self.card_contents:
            for _item_card_contents in self.card_contents:
                if _item_card_contents:
                    _items.append(_item_card_contents.to_dict())
            _dict['cardContents'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in suggestions (list)
        _items = []
        if self.suggestions:
            for _item_suggestions in self.suggestions:
                if _item_suggestions:
                    _items.append(_item_suggestions.to_dict())
            _dict['suggestions'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RbmMessageCarouselCard from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cardWidth": obj.get("cardWidth"),
            "cardContents": [RbmCardContent.from_dict(_item) for _item in obj["cardContents"]] if obj.get("cardContents") is not None else None,
            "suggestions": [MultiChannelAction.from_dict(_item) for _item in obj["suggestions"]] if obj.get("suggestions") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


