# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from bandwidth.models.webhook_subscription_basic_authentication import WebhookSubscriptionBasicAuthentication
from bandwidth.models.webhook_subscription_type_enum import WebhookSubscriptionTypeEnum
from typing import Optional, Set
from typing_extensions import Self

class WebhookSubscription(BaseModel):
    """
    Information about a webhook that Bandwidth should send upon the completion of event customer has subscribed to.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    account_id: Optional[StrictStr] = Field(default=None, alias="accountId")
    callback_url: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=2000)]] = Field(description="Callback URL to receive status updates from Bandwidth. When a webhook subscription is registered with Bandwidth under a given account ID, it will be used to send status updates for all requests submitted under that account ID.", alias="callbackUrl")
    type: Optional[WebhookSubscriptionTypeEnum] = None
    basic_authentication: Optional[WebhookSubscriptionBasicAuthentication] = Field(default=None, alias="basicAuthentication")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "accountId", "callbackUrl", "type", "basicAuthentication", "createdDate", "modifiedDate"]

    @field_validator('callback_url')
    def callback_url_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^$|(https?:\/\/)?(www\.)?[-a-zA-Z0-9@:%._\+~#=]{1,253}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#()?&\/\/=]*)", value):
            raise ValueError(r"must validate the regular expression /^$|(https?:\/\/)?(www\.)?[-a-zA-Z0-9@:%._\+~#=]{1,253}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#()?&\/\/=]*)/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookSubscription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of basic_authentication
        if self.basic_authentication:
            _dict['basicAuthentication'] = self.basic_authentication.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if callback_url (nullable) is None
        # and model_fields_set contains the field
        if self.callback_url is None and "callback_url" in self.model_fields_set:
            _dict['callbackUrl'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookSubscription from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "accountId": obj.get("accountId"),
            "callbackUrl": obj.get("callbackUrl"),
            "type": obj.get("type"),
            "basicAuthentication": WebhookSubscriptionBasicAuthentication.from_dict(obj["basicAuthentication"]) if obj.get("basicAuthentication") is not None else None,
            "createdDate": obj.get("createdDate"),
            "modifiedDate": obj.get("modifiedDate")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


