# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from bandwidth.models.tfv_basic_authentication import TfvBasicAuthentication
from typing import Optional, Set
from typing_extensions import Self

class WebhookSubscriptionRequestSchema(BaseModel):
    """
    WebhookSubscriptionRequestSchema
    """ # noqa: E501
    basic_authentication: Optional[TfvBasicAuthentication] = Field(default=None, alias="basicAuthentication")
    callback_url: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=2000)]] = Field(description="Callback URL to receive status updates from Bandwidth. When a webhook subscription is registered with Bandwidth under a given account ID, it will be used to send status updates for all requests submitted under that account ID.", alias="callbackUrl")
    shared_secret_key: Optional[Annotated[str, Field(min_length=16, strict=True, max_length=64)]] = Field(default=None, description="An ASCII string submitted by the user as a shared secret key for generating an HMAC header for callbacks.", alias="sharedSecretKey")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["basicAuthentication", "callbackUrl", "sharedSecretKey"]

    @field_validator('callback_url')
    def callback_url_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^$|(https?:\/\/)?(www\.)?[-a-zA-Z0-9@:%._\+~#=]{1,253}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#()?&\/\/=]*)", value):
            raise ValueError(r"must validate the regular expression /^$|(https?:\/\/)?(www\.)?[-a-zA-Z0-9@:%._\+~#=]{1,253}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#()?&\/\/=]*)/")
        return value

    @field_validator('shared_secret_key')
    def shared_secret_key_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[ -~]{16,64}$", value):
            raise ValueError(r"must validate the regular expression /^[ -~]{16,64}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookSubscriptionRequestSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of basic_authentication
        if self.basic_authentication:
            _dict['basicAuthentication'] = self.basic_authentication.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if callback_url (nullable) is None
        # and model_fields_set contains the field
        if self.callback_url is None and "callback_url" in self.model_fields_set:
            _dict['callbackUrl'] = None

        # set to None if shared_secret_key (nullable) is None
        # and model_fields_set contains the field
        if self.shared_secret_key is None and "shared_secret_key" in self.model_fields_set:
            _dict['sharedSecretKey'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookSubscriptionRequestSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "basicAuthentication": TfvBasicAuthentication.from_dict(obj["basicAuthentication"]) if obj.get("basicAuthentication") is not None else None,
            "callbackUrl": obj.get("callbackUrl"),
            "sharedSecretKey": obj.get("sharedSecretKey")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


