# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest
from datetime import datetime, timedelta
from zoneinfo import ZoneInfo

from hamcrest import *
from test.utils.env_variables import *
from bandwidth import ApiClient, Configuration
from bandwidth.api.multi_channel_api import MultiChannelApi
from bandwidth.models.multi_channel_message_request import MultiChannelMessageRequest
from bandwidth.models.multi_channel_channel_list_object import MultiChannelChannelListObject
from bandwidth.models.multi_channel_message_channel_enum import MultiChannelMessageChannelEnum
from bandwidth.models.rbm_message_content_text import RbmMessageContentText
from bandwidth.models.multi_channel_channel_list_object_content import MultiChannelChannelListObjectContent


class TestMultiChannelApi(unittest.TestCase):
    """MultiChannelApi unit test stubs"""

    def setUp(self) -> None:
        configuration = Configuration(
            username=BW_USERNAME,
            password=BW_PASSWORD,
        )
        api_client = ApiClient(configuration)
        self.multi_channel_api_instance = MultiChannelApi(api_client)

        self.expiration = datetime.now(ZoneInfo('America/New_York')) + timedelta(minutes=1)

    @unittest.skip("Still in Beta, skip for now")
    def test_create_multi_channel_message(self) -> None:
        """Test case for create_multi_channel_message

        Create Multi-Channel Message
        """

        channel_list_item = MultiChannelChannelListObject(
            var_from = BW_NUMBER,
            application_id = BW_MESSAGING_APPLICATION_ID,
            channel = MultiChannelMessageChannelEnum('RBM'),
            content = MultiChannelChannelListObjectContent(
                RbmMessageContentText(
                    text = 'Hello, this is a test message.',
                )
            )
        )
        multi_channel_message_request = MultiChannelMessageRequest(
            to = USER_NUMBER,
            channel_list = [channel_list_item],
            tag = 'tag',
            priority = 'high',
            expiration = self.expiration
        )

        response = self.multi_channel_api_instance.create_multi_channel_message_with_http_info(
            BW_ACCOUNT_ID,
            multi_channel_message_request
        )        
        assert_that(response.status_code, equal_to(202))

if __name__ == '__main__':
    unittest.main()
