# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest
from datetime import datetime

from hamcrest import *
from test.utils.env_variables import *
from bandwidth import ApiClient, Configuration
from bandwidth.api.conferences_api import ConferencesApi
from bandwidth.models.conference import Conference
from bandwidth.models.callback_method_enum import CallbackMethodEnum
from bandwidth.models.conference_member import ConferenceMember
from bandwidth.models.update_conference import UpdateConference
from bandwidth.models.conference_state_enum import ConferenceStateEnum
from bandwidth.models.conference_recording_metadata import ConferenceRecordingMetadata
from bandwidth.models.file_format_enum import FileFormatEnum


class TestConferencesApi(unittest.TestCase):
    """ConferencesApi unit test stubs"""

    def setUp(self) -> None:
        configuration = Configuration(
            username=BW_USERNAME,
            password=BW_PASSWORD,
            host='http://127.0.0.1:4010',
            ignore_operation_servers=True
        )
        api_client = ApiClient(configuration)
        self.conferences_api_instance = ConferencesApi(api_client)

    def test_list_conferences(self) -> None:
        """Test case for list_conferences

        Get Conferences
        """
        response = self.conferences_api_instance.list_conferences_with_http_info(BW_ACCOUNT_ID)

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(list))
        assert_that(response.data[0], instance_of(Conference))
        assert_that(response.data[0].id, has_length(50))
        assert_that(response.data[0].name, instance_of(str))
        assert_that(response.data[0].created_time, instance_of(datetime))
        assert_that(response.data[0].completed_time, instance_of(datetime))
        assert_that(response.data[0].conference_event_url, starts_with('http'))
        assert_that(response.data[0].conference_event_method, is_in(CallbackMethodEnum))
        assert_that(response.data[0].tag, instance_of(str))

    def test_get_conference(self) -> None:
        """Test case for get_conference

        Get Conference Information
        """
        response = self.conferences_api_instance.get_conference_with_http_info(BW_ACCOUNT_ID, 'conferenceId')

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(Conference))
        assert_that(response.data.id, has_length(50))
        assert_that(response.data.name, instance_of(str))
        assert_that(response.data.created_time, instance_of(datetime))
        assert_that(response.data.completed_time, instance_of(datetime))
        assert_that(response.data.conference_event_url, starts_with('http'))
        assert_that(response.data.conference_event_method, is_in(CallbackMethodEnum))
        assert_that(response.data.tag, instance_of(str))

    def test_get_conference_member(self) -> None:
        """Test case for get_conference_member

        Get Conference Member
        """
        response = self.conferences_api_instance.get_conference_member_with_http_info(
            BW_ACCOUNT_ID, 'conferenceId', 'memberId')

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(ConferenceMember))
        assert_that(response.data.call_id, has_length(47))
        assert_that(response.data.conference_id, has_length(50))
        assert_that(response.data.member_url, starts_with('http'))
        assert_that(response.data.mute, instance_of(bool))
        assert_that(response.data.hold, instance_of(bool))
        assert_that(response.data.call_ids_to_coach, instance_of(list))

    def test_update_conference_member(self) -> None:
        """Test case for update_conference_member

        Update Conference Member
        """
        update_conference_member = { 'mute': True }

        response = self.conferences_api_instance.update_conference_member_with_http_info(
            BW_ACCOUNT_ID, 'conferenceId', 'memberId', update_conference_member)

        assert_that(response.status_code, equal_to(204))

    def test_update_conference(self) -> None:
        """Test case for update_conference

        Update Conference
        """
        update_conference = UpdateConference(
            status=ConferenceStateEnum('active')
        )

        response = self.conferences_api_instance.update_conference_with_http_info(
            BW_ACCOUNT_ID, 'conferenceId', update_conference)
        
        assert_that(response.status_code, equal_to(204))

    def test_update_conference_bxml(self) -> None:
        """Test case for update_conference_bxml

        Update Conference BXML
        """
        update_conference_bxml = 'updateConferenceBxml'

        response = self.conferences_api_instance.update_conference_bxml_with_http_info(
            BW_ACCOUNT_ID, 'conferenceId', update_conference_bxml)

        assert_that(response.status_code, equal_to(204))

    def test_list_conference_recordings(self) -> None:
        """Test case for list_conference_recordings

        Get Conference Recordings
        """
        response = self.conferences_api_instance.list_conference_recordings_with_http_info(BW_ACCOUNT_ID, 'conferenceId')

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(list))
        assert_that(response.data[0], instance_of(ConferenceRecordingMetadata))
        assert_that(response.data[0].account_id, has_length(7))
        assert_that(response.data[0].conference_id, has_length(50))
        assert_that(response.data[0].name, instance_of(str))
        assert_that(response.data[0].recording_id, has_length(47))
        assert_that(response.data[0].duration, starts_with('PT'))
        assert_that(response.data[0].channels, instance_of(int))
        assert_that(response.data[0].start_time, instance_of(datetime))
        assert_that(response.data[0].end_time, instance_of(datetime))
        assert_that(response.data[0].file_format, is_in(FileFormatEnum))
        assert_that(response.data[0].status, instance_of(str))
        assert_that(response.data[0].media_url, starts_with('http'))

    def test_get_conference_recording(self) -> None:
        """Test case for get_conference_recording

        Get Conference Recording Information
        """
        response = self.conferences_api_instance.get_conference_recording_with_http_info(
            BW_ACCOUNT_ID, 'conferenceId', 'recordingId')

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(ConferenceRecordingMetadata))
        assert_that(response.data.account_id, has_length(7))
        assert_that(response.data.conference_id, has_length(50))
        assert_that(response.data.name, instance_of(str))
        assert_that(response.data.recording_id, has_length(47))
        assert_that(response.data.duration, starts_with('PT'))
        assert_that(response.data.channels, instance_of(int))
        assert_that(response.data.start_time, instance_of(datetime))
        assert_that(response.data.end_time, instance_of(datetime))
        assert_that(response.data.file_format, is_in(FileFormatEnum))
        assert_that(response.data.status, instance_of(str))
        assert_that(response.data.media_url, starts_with('http'))

    def test_download_conference_recording(self) -> None:
        """Test case for download_conference_recording

        Download Conference Recording
        """
        response = self.conferences_api_instance.download_conference_recording_with_http_info(
            BW_ACCOUNT_ID, 'conferenceId', 'recordingId', _headers={'Accept': 'audio/vnd.wave'})
        # might be an issue with the client, cause I think the accept header gets written to
        # application/json no matter what
        
        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(bytes))


if __name__ == '__main__':
    unittest.main()
