# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from hamcrest import *
from test.utils.env_variables import *
from bandwidth import ApiClient, Configuration
from bandwidth.api.mfa_api import MFAApi
from bandwidth.models.code_request import CodeRequest
from bandwidth.models.messaging_code_response import MessagingCodeResponse
from bandwidth.models.voice_code_response import VoiceCodeResponse
from bandwidth.models.verify_code_request import VerifyCodeRequest
from bandwidth.models.verify_code_response import VerifyCodeResponse


class TestMFAApi(unittest.TestCase):
    """MFAApi unit test stubs"""

    def setUp(self) -> None:
        configuration = Configuration(
            username=BW_USERNAME,
            password=BW_PASSWORD,
            host='http://127.0.0.1:4010',
            ignore_operation_servers=True
        )
        api_client = ApiClient(configuration)
        self.mfa_api_instance = MFAApi(api_client)

    def test_generate_messaging_code(self) -> None:
        """Test case for generate_messaging_code

        Messaging Authentication Code
        """
        code_request = CodeRequest(
            application_id=BW_MESSAGING_APPLICATION_ID,
            to=USER_NUMBER,
            var_from=BW_NUMBER,
            message="Your temporary {NAME} {SCOPE} code is {CODE}",
            digits=6
        )

        response = self.mfa_api_instance.generate_messaging_code_with_http_info(BW_ACCOUNT_ID, code_request)
        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(MessagingCodeResponse))
        assert_that(response.data.message_id, has_length(29))

    def test_generate_voice_code(self) -> None:
        """Test case for generate_voice_code

        Voice Authentication Code
        """
        code_request = CodeRequest(
            application_id=BW_VOICE_APPLICATION_ID,
            to=USER_NUMBER,
            var_from=BW_NUMBER,
            message="Your temporary {NAME} {SCOPE} code is {CODE}",
            digits=6
        )

        response = self.mfa_api_instance.generate_voice_code_with_http_info(BW_ACCOUNT_ID, code_request)
        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(VoiceCodeResponse))
        assert_that(response.data.call_id, has_length(47))

    def test_verify_code(self) -> None:
        """Test case for verify_code

        Verify Authentication Code
        """
        verify_request = VerifyCodeRequest(
            to=USER_NUMBER,
            scope='2FA',
            expiration_time_in_minutes=3,
            code='12345'
        )

        response = self.mfa_api_instance.verify_code_with_http_info(BW_ACCOUNT_ID, verify_request)
        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(VerifyCodeResponse))
        assert_that(response.data.valid, instance_of(bool))

if __name__ == '__main__':
    unittest.main()
