# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from hamcrest import *
from test.utils.env_variables import *
from bandwidth import ApiClient, Configuration
from bandwidth.api.multi_channel_api import MultiChannelApi
from bandwidth.models.multi_channel_message_request import MultiChannelMessageRequest
from bandwidth.models.multi_channel_channel_list_object import MultiChannelChannelListObject
from bandwidth.models.sms_message_content import SmsMessageContent
from bandwidth.models.multi_channel_message_channel_enum import MultiChannelMessageChannelEnum
from bandwidth.models.multi_channel_channel_list_object_content import MultiChannelChannelListObjectContent


class TestMultiChannelApi(unittest.TestCase):
    """MultiChannelApi unit test stubs"""

    def setUp(self) -> None:
        configuration = Configuration(
            username=BW_USERNAME,
            password=BW_PASSWORD,
            host='http://127.0.0.1:4010',
            ignore_operation_servers=True
        )
        api_client = ApiClient(configuration)
        self.multi_channel_api_instance = MultiChannelApi(api_client)

    @unittest.skip("skip because prism can't handle a oneOf with differing required fields")
    def test_create_multi_channel_message(self) -> None:
        """Test case for create_multi_channel_message

        Create Multi-Channel Message
        """

        channel_list_item = MultiChannelChannelListObject(
            var_from = BW_NUMBER,
            application_id = BW_MESSAGING_APPLICATION_ID,
            channel = MultiChannelMessageChannelEnum('SMS'),
            content = MultiChannelChannelListObjectContent(
                SmsMessageContent(
                    text = 'Hello, this is a test message.',
                )
            )
        )
        multi_channel_message_request = MultiChannelMessageRequest(
            to = USER_NUMBER,
            channel_list = [channel_list_item],
            tag = 'tag',
            priority = 'high',
            expiration = '2023-10-01T00:00:00Z',
        )

        response = self.multi_channel_api_instance.create_multi_channel_message_with_http_info(BW_ACCOUNT_ID, multi_channel_message_request)        
        assert_that(response.status_code, equal_to(202))

if __name__ == '__main__':
    unittest.main()
