# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest
from datetime import datetime

from hamcrest import *
from test.utils.env_variables import *
from bandwidth import ApiClient, Configuration
from bandwidth.api.toll_free_verification_api import TollFreeVerificationApi
from bandwidth.models.webhook_subscription_request_schema import WebhookSubscriptionRequestSchema
from bandwidth.models.tfv_basic_authentication import TfvBasicAuthentication
from bandwidth.models.webhook_subscription import WebhookSubscription
from bandwidth.models.webhook_subscription_type_enum import WebhookSubscriptionTypeEnum
from bandwidth.models.webhook_subscription_basic_authentication import WebhookSubscriptionBasicAuthentication
from bandwidth.models.tfv_status import TfvStatus
from bandwidth.models.tfv_status_enum import TfvStatusEnum
from bandwidth.models.webhook_subscriptions_list_body import WebhookSubscriptionsListBody
from bandwidth.models.links_object import LinksObject
from bandwidth.models.telephone_number import TelephoneNumber
from bandwidth.models.address import Address
from bandwidth.models.contact import Contact
from bandwidth.models.opt_in_workflow import OptInWorkflow
from bandwidth.models.verification_request import VerificationRequest
from bandwidth.models.tfv_submission_wrapper import TfvSubmissionWrapper


class TestTollFreeVerificationApi(unittest.TestCase):
    """TollFreeVerificationApi unit test stubs"""

    def setUp(self) -> None:
        configuration = Configuration(
            username=BW_USERNAME,
            password=BW_PASSWORD,
            host='http://127.0.0.1:4010',
            ignore_operation_servers=True
        )
        api_client = ApiClient(configuration)
        self.tfv_api_instance = TollFreeVerificationApi(api_client)

        self.subscription_id = 'test-id-1234'
        self.tf_phone_number = '+18005551234'

        self.webhook_subscription_request_schema = WebhookSubscriptionRequestSchema(
            basic_authentication=TfvBasicAuthentication(
                username='username',
                password='password'
            ),
            callback_url='https://example.com',
            shared_secret_key='shared-secret-key'
        )

        self.verification = {
            'businessAddress': Address(
                name='name',
                addr1='addr1',
                addr2='addr2',
                city='city',
                state='state',
                zip='zip',
                url='https://example.com'
            ),
            'businessContact': Contact(
                firstName='first-name',
                lastName='last-name',
                email='email@email.com',
                phoneNumber='+19195551234'
            ),
            'messageVolume': 12,
            'useCase': 'useCase',
            'useCaseSummary': 'useCaseSummary',
            'productionMessageContent': 'productionMessageContent',
            'optInWorkflow': OptInWorkflow(
                description='description',
                image_urls=['https://example.com']
            ),
            'additionalInformation': 'additionalInformation',
            'isvReseller': 'isvReseller'
        }

    def test_create_webhook_subscription(self) -> None:
        """Test case for create_webhook_subscription

        Create Webhook Subscription
        """
        response = self.tfv_api_instance.create_webhook_subscription_with_http_info(BW_ACCOUNT_ID, self.webhook_subscription_request_schema)

        assert_that(response.status_code, equal_to(201))
        assert_that(response.data, instance_of(WebhookSubscription))
        assert_that(response.data.id, instance_of(str))
        assert_that(response.data.account_id, has_length(7))
        assert_that(response.data.callback_url, instance_of(str))
        assert_that(response.data.type, is_in(WebhookSubscriptionTypeEnum))
        assert_that(response.data.basic_authentication, instance_of(WebhookSubscriptionBasicAuthentication))
        assert_that(response.data.basic_authentication.username, instance_of(str))
        assert_that(response.data.basic_authentication.password, instance_of(str))
        assert_that(response.data.created_date, instance_of(datetime))
        assert_that(response.data.modified_date, instance_of(datetime))

    def test_delete_webhook_subscription(self) -> None:
        """Test case for delete_webhook_subscription

        Delete Webhook Subscription
        """
        response = self.tfv_api_instance.delete_webhook_subscription_with_http_info(BW_ACCOUNT_ID, self.subscription_id)

        assert_that(response.status_code, equal_to(204))

    def test_get_toll_free_verification_status(self) -> None:
        """Test case for get_toll_free_verification_status

        Get Toll-Free Verification Status
        """
        response = self.tfv_api_instance.get_toll_free_verification_status_with_http_info(BW_ACCOUNT_ID, self.tf_phone_number)

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(TfvStatus))
        assert_that(response.data.phone_number, instance_of(str))
        assert_that(response.data.status, is_in(TfvStatusEnum))
        assert_that(response.data.internal_ticket_number, instance_of(str))
        assert_that(response.data.decline_reason_description, instance_of(str))
        assert_that(response.data.resubmit_allowed, instance_of(bool))
        assert_that(response.data.created_date_time, instance_of(datetime))
        assert_that(response.data.modified_date_time, instance_of(datetime))

    def test_delete_verification_request(self) -> None:
        """Test case for delete_verification_request

        Delete Verification Request
        """
        response = self.tfv_api_instance.delete_verification_request_with_http_info(BW_ACCOUNT_ID, self.tf_phone_number)

        assert_that(response.status_code, equal_to(204))

    def test_list_toll_free_use_cases(self) -> None:
        """Test case for list_toll_free_use_cases

        List Toll-Free Use Cases
        """
        response = self.tfv_api_instance.list_toll_free_use_cases_with_http_info()

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(list))
        assert_that(response.data[0], instance_of(str))

    def test_list_webhook_subscriptions(self) -> None:
        """Test case for list_webhook_subscriptions

        List Webhook Subscriptions
        """
        response = self.tfv_api_instance.list_webhook_subscriptions_with_http_info(BW_ACCOUNT_ID)

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(WebhookSubscriptionsListBody))
        assert_that(response.data.links, instance_of(LinksObject))
        assert_that(response.data.links.first, instance_of(str))
        assert_that(response.data.links.next, instance_of(str))
        assert_that(response.data.links.previous, instance_of(str))
        assert_that(response.data.links.last, instance_of(str))
        assert_that(response.data.errors, instance_of(list))
        assert_that(response.data.errors[0].code, instance_of(int))
        assert_that(response.data.errors[0].description, instance_of(str))
        assert_that(response.data.errors[0].telephone_numbers, instance_of(list))
        assert_that(response.data.errors[0].telephone_numbers[0], instance_of(TelephoneNumber))
        assert_that(response.data.errors[0].telephone_numbers[0].telephone_number, instance_of(str))
        assert_that(response.data.data, instance_of(list))
        assert_that(response.data.data[0], instance_of(WebhookSubscription))
        assert_that(response.data.data[0].id, instance_of(str))
        assert_that(response.data.data[0].account_id, instance_of(str))
        assert_that(response.data.data[0].callback_url, instance_of(str))
        assert_that(response.data.data[0].type, is_in(WebhookSubscriptionTypeEnum))
        assert_that(response.data.data[0].basic_authentication, instance_of(WebhookSubscriptionBasicAuthentication))
        assert_that(response.data.data[0].basic_authentication.username, instance_of(str))
        assert_that(response.data.data[0].basic_authentication.password, instance_of(str))
        assert_that(response.data.data[0].created_date, instance_of(datetime))
        assert_that(response.data.data[0].modified_date, instance_of(datetime))

    def test_request_toll_free_verification(self) -> None:
        """Test case for request_toll_free_verification

        Request Toll-Free Verification
        """
        verification_request = VerificationRequest.from_dict(self.verification | { 'phoneNumbers': [self.tf_phone_number] })
        response = self.tfv_api_instance.request_toll_free_verification_with_http_info(BW_ACCOUNT_ID, verification_request)

        assert_that(response.status_code, equal_to(202))

    def test_update_toll_free_verification_request(self) -> None:
        """Test case for update_toll_free_verification_request

        Update Toll-Free Verification Request
        """
        tfv_submission_wrapper = TfvSubmissionWrapper.from_dict({ 'submission': self.verification })
        response = self.tfv_api_instance.update_toll_free_verification_request_with_http_info(BW_ACCOUNT_ID, self.tf_phone_number, tfv_submission_wrapper)

        assert_that(response.status_code, equal_to(202))

    def test_update_webhook_subscription(self) -> None:
        """Test case for update_webhook_subscription

        Update Webhook Subscription
        """
        response = self.tfv_api_instance.update_webhook_subscription_with_http_info(BW_ACCOUNT_ID, self.subscription_id, self.webhook_subscription_request_schema)

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(WebhookSubscription))
        assert_that(response.data.id, instance_of(str))
        assert_that(response.data.account_id, has_length(7))
        assert_that(response.data.callback_url, instance_of(str))
        assert_that(response.data.type, is_in(WebhookSubscriptionTypeEnum))
        assert_that(response.data.basic_authentication, instance_of(WebhookSubscriptionBasicAuthentication))
        assert_that(response.data.basic_authentication.username, instance_of(str))
        assert_that(response.data.basic_authentication.password, instance_of(str))
        assert_that(response.data.created_date, instance_of(datetime))
        assert_that(response.data.modified_date, instance_of(datetime))


if __name__ == '__main__':
    unittest.main()
