# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from bandwidth.models.verification_denial_webhook import VerificationDenialWebhook

class TestVerificationDenialWebhook(unittest.TestCase):
    """VerificationDenialWebhook unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> VerificationDenialWebhook:
        """Test VerificationDenialWebhook
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        if include_optional:
            return VerificationDenialWebhook(
                account_id = '1234567',
                additional_denial_reasons = [{"statusCode":512,"reason":"Reason A","resubmitAllowed":True},{"statusCode":513,"reason":"Reason B","resubmitAllowed":True}],
                decline_reason_description = 'Invalid Information - Can\'t Validate URL - Website is not accessible / not available',
                denial_status_code = 511,
                internal_ticket_number = 'acde070d-8c4c-4f0d-9d8a-162843c10333',
                phone_number = '+18005555555',
                resubmit_allowed = True,
                status = 'UNVERIFIED',
                blocked = True,
                blocked_reason = 'Blocked Reason'
            )
        else:
            return VerificationDenialWebhook(
        )

    def testVerificationDenialWebhook(self):
        """Test VerificationDenialWebhook"""
        instance = self.make_instance(True)
        assert instance is not None
        assert isinstance(instance, VerificationDenialWebhook)
        assert instance.account_id == '1234567'
        assert isinstance(instance.additional_denial_reasons, list)
        assert len(instance.additional_denial_reasons) == 2
        assert instance.additional_denial_reasons[0].status_code == 512
        assert instance.additional_denial_reasons[0].reason == 'Reason A'
        assert instance.additional_denial_reasons[0].resubmit_allowed == True
        assert instance.additional_denial_reasons[1].status_code == 513
        assert instance.additional_denial_reasons[1].reason == 'Reason B'
        assert instance.additional_denial_reasons[1].resubmit_allowed == True
        assert instance.decline_reason_description == 'Invalid Information - Can\'t Validate URL - Website is not accessible / not available'
        assert instance.denial_status_code == 511
        assert instance.internal_ticket_number == 'acde070d-8c4c-4f0d-9d8a-162843c10333'
        assert instance.phone_number == '+18005555555'
        assert instance.resubmit_allowed == True
        assert instance.status == 'UNVERIFIED'
        assert instance.blocked == True
        assert instance.blocked_reason == 'Blocked Reason'

if __name__ == '__main__':
    unittest.main()
