# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest
from datetime import datetime

from bandwidth.models.webhook_subscriptions_list_body import WebhookSubscriptionsListBody
from bandwidth.models.links_object import LinksObject
from bandwidth.models.error import Error
from bandwidth.models.telephone_number import TelephoneNumber
from bandwidth.models.webhook_subscription import WebhookSubscription
from bandwidth.models.webhook_subscription_basic_authentication import WebhookSubscriptionBasicAuthentication

class TestWebhookSubscriptionsListBody(unittest.TestCase):
    """WebhookSubscriptionsListBody unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> WebhookSubscriptionsListBody:
        """Test WebhookSubscriptionsListBody
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        if include_optional:
            return WebhookSubscriptionsListBody(
                links = LinksObject(
                    first = 'https://api.com/abc/first', 
                    next = 'https://api.com/abc/next', 
                    previous = 'https://api.com/abc/previous', 
                    last = 'https://api.com/abc/last', ),
                errors = [
                    Error(
                        code = 56, 
                        description = 'description', 
                        telephone_numbers = [
                            TelephoneNumber(
                                telephone_number = '+19195551234', )
                            ], )
                    ],
                data = [
                    WebhookSubscription(
                        id = '7hICGStfAfeGxEq3N0lQwO', 
                        account_id = '1234567', 
                        callback_url = 'https://www.example.com/path/to/resource', 
                        type = 'TOLLFREE_VERIFICATION_STATUS', 
                        basic_authentication = WebhookSubscriptionBasicAuthentication(
                            username = 'username', 
                            password = 'password', ), 
                        created_date = '2023-05-15T13:56:39.965Z', 
                        modified_date = '2023-05-15T13:56:39.965Z', )
                    ]
            )
        else:
            return WebhookSubscriptionsListBody(
                data = [
                    WebhookSubscription(
                        id = '7hICGStfAfeGxEq3N0lQwO', 
                        account_id = '1234567', 
                        callback_url = 'https://www.example.com/path/to/resource', 
                        type = 'TOLLFREE_VERIFICATION_STATUS', 
                        basic_authentication = WebhookSubscriptionBasicAuthentication(
                            username = 'username', 
                            password = 'password', ), 
                        created_date = '2023-05-15T13:56:39.965Z', 
                        modified_date = '2023-05-15T13:56:39.965Z', )
                    ],
        )

    def testWebhookSubscriptionsListBody(self):
        """Test WebhookSubscriptionsListBody"""
        instance = self.make_instance(True)
        assert instance is not None
        assert isinstance(instance, WebhookSubscriptionsListBody)
        assert isinstance(instance.links, LinksObject)
        assert instance.links.first == 'https://api.com/abc/first'
        assert instance.links.next == 'https://api.com/abc/next'
        assert instance.links.previous == 'https://api.com/abc/previous'
        assert instance.links.last == 'https://api.com/abc/last'
        assert isinstance(instance.errors, list)
        assert len(instance.errors) == 1
        assert isinstance(instance.errors[0], Error)
        assert instance.errors[0].code == 56
        assert instance.errors[0].description == 'description'
        assert isinstance(instance.errors[0].telephone_numbers, list)
        assert len(instance.errors[0].telephone_numbers) == 1
        assert isinstance(instance.errors[0].telephone_numbers[0], TelephoneNumber)
        assert instance.errors[0].telephone_numbers[0].telephone_number == '+19195551234'
        assert isinstance(instance.data, list)
        assert len(instance.data) == 1
        assert isinstance(instance.data[0], WebhookSubscription)
        assert instance.data[0].id == '7hICGStfAfeGxEq3N0lQwO'
        assert instance.data[0].account_id == '1234567'
        assert instance.data[0].callback_url == 'https://www.example.com/path/to/resource'
        assert instance.data[0].type == 'TOLLFREE_VERIFICATION_STATUS'
        assert instance.data[0].basic_authentication.username == 'username'
        assert instance.data[0].basic_authentication.password == 'password'
        assert isinstance(instance.data[0].created_date, datetime)
        assert isinstance(instance.data[0].modified_date, datetime)

if __name__ == '__main__':
    unittest.main()
