# Guides

Task-based guides for common FraiseQL workflows and patterns.

## Getting Started Guides

- **[Understanding FraiseQL](understanding-fraiseql.md)** - 10-minute architecture overview
  - Database-first GraphQL philosophy
  - CQRS pattern and JSONB views
  - Trinity identifiers explained
  - Performance patterns

## Query & Filtering Guides

- **[Nested Array Filtering](nested-array-filtering.md)** - Advanced filtering with logical operators
  - AND/OR/NOT combinations
  - Array field filtering
  - Specialized type operators
  - Performance considerations

## Troubleshooting & Debugging

- **[Troubleshooting Guide](troubleshooting.md)** - Common issues and solutions
  - Error-message-focused solutions
  - PostgreSQL connection issues
  - Type mismatches and validation errors
  - Server startup problems

- **[Troubleshooting Decision Tree](troubleshooting-decision-tree.md)** - Diagnostic flowchart
  - Category-based issue diagnosis
  - Installation, database, performance, deployment
  - Step-by-step debugging process

## Performance & Optimization

- **[Performance Guide](performance-guide.md)** - Optimization strategies
  - Query optimization techniques
  - Caching strategies
  - Rust pipeline optimization
  - Profiling and monitoring

## Quick Navigation

**New users?** Start with [Understanding FraiseQL](understanding-fraiseql.md) to grasp the core concepts.

**Having issues?** Check [Troubleshooting Guide](troubleshooting.md) for common problems and solutions.

**Need advanced features?** See [Nested Array Filtering](nested-array-filtering.md) for complex query patterns.

**Related Documentation:**
- [Getting Started](../getting-started/) - Quickstart and first hour tutorials
- [Core Concepts](../core/) - In-depth documentation on FraiseQL fundamentals
- [Reference](../reference/) - API reference and quick lookup
