# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class AgentManagerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def agent_manager_delete_firewall_instance(self, agent_id_uuid, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """DeleteFirewallInstance  # noqa: E501

        Deletes the firewall instance from the DB. It does not directly impact the deployment of the firewall instance in the agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_delete_firewall_instance(agent_id_uuid, firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id_uuid: Unique object ID. (required)
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: RimeDeleteFirewallInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_delete_firewall_instance_with_http_info(agent_id_uuid, firewall_instance_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_delete_firewall_instance_with_http_info(agent_id_uuid, firewall_instance_id_uuid, **kwargs)  # noqa: E501
            return data

    def agent_manager_delete_firewall_instance_with_http_info(self, agent_id_uuid, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """DeleteFirewallInstance  # noqa: E501

        Deletes the firewall instance from the DB. It does not directly impact the deployment of the firewall instance in the agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_delete_firewall_instance_with_http_info(agent_id_uuid, firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id_uuid: Unique object ID. (required)
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: RimeDeleteFirewallInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_id_uuid', 'firewall_instance_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_delete_firewall_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_id_uuid' is set
        if ('agent_id_uuid' not in params or
                params['agent_id_uuid'] is None):
            raise ValueError("Missing the required parameter `agent_id_uuid` when calling `agent_manager_delete_firewall_instance`")  # noqa: E501
        # verify the required parameter 'firewall_instance_id_uuid' is set
        if ('firewall_instance_id_uuid' not in params or
                params['firewall_instance_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_instance_id_uuid` when calling `agent_manager_delete_firewall_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_id_uuid' in params:
            path_params['agentId.uuid'] = params['agent_id_uuid']  # noqa: E501
        if 'firewall_instance_id_uuid' in params:
            path_params['firewallInstanceId.uuid'] = params['firewall_instance_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/internal/agents/firewall/{agentId.uuid}/firewall-instance/{firewallInstanceId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteFirewallInstanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def agent_manager_firewall_instance_heartbeat(self, body, agent_id_uuid, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """FirewallInstanceHeartbeat accepts heartbeat signals from firewall instances. This allows us to confirm that the firewall instance is still running.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_firewall_instance_heartbeat(body, agent_id_uuid, firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallInstanceIdUuidHeartbeatBody body: (required)
        :param str agent_id_uuid: Unique object ID. (required)
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: RimeFirewallInstanceHeartbeatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_firewall_instance_heartbeat_with_http_info(body, agent_id_uuid, firewall_instance_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_firewall_instance_heartbeat_with_http_info(body, agent_id_uuid, firewall_instance_id_uuid, **kwargs)  # noqa: E501
            return data

    def agent_manager_firewall_instance_heartbeat_with_http_info(self, body, agent_id_uuid, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """FirewallInstanceHeartbeat accepts heartbeat signals from firewall instances. This allows us to confirm that the firewall instance is still running.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_firewall_instance_heartbeat_with_http_info(body, agent_id_uuid, firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallInstanceIdUuidHeartbeatBody body: (required)
        :param str agent_id_uuid: Unique object ID. (required)
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: RimeFirewallInstanceHeartbeatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'agent_id_uuid', 'firewall_instance_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_firewall_instance_heartbeat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `agent_manager_firewall_instance_heartbeat`")  # noqa: E501
        # verify the required parameter 'agent_id_uuid' is set
        if ('agent_id_uuid' not in params or
                params['agent_id_uuid'] is None):
            raise ValueError("Missing the required parameter `agent_id_uuid` when calling `agent_manager_firewall_instance_heartbeat`")  # noqa: E501
        # verify the required parameter 'firewall_instance_id_uuid' is set
        if ('firewall_instance_id_uuid' not in params or
                params['firewall_instance_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_instance_id_uuid` when calling `agent_manager_firewall_instance_heartbeat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_id_uuid' in params:
            path_params['agentId.uuid'] = params['agent_id_uuid']  # noqa: E501
        if 'firewall_instance_id_uuid' in params:
            path_params['firewallInstanceId.uuid'] = params['firewall_instance_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/internal/agents/firewall/{agentId.uuid}/firewall-instance/{firewallInstanceId.uuid}/heartbeat', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeFirewallInstanceHeartbeatResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def agent_manager_heartbeat(self, body, agent_id_uuid, **kwargs):  # noqa: E501
        """Heartbeat accepts heartbeat signal from agent indicating that they are still running.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_heartbeat(body, agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HeartbeatAgentIdUuidBody body: (required)
        :param str agent_id_uuid: Unique object ID. (required)
        :return: RimeHeartbeatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_heartbeat_with_http_info(body, agent_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_heartbeat_with_http_info(body, agent_id_uuid, **kwargs)  # noqa: E501
            return data

    def agent_manager_heartbeat_with_http_info(self, body, agent_id_uuid, **kwargs):  # noqa: E501
        """Heartbeat accepts heartbeat signal from agent indicating that they are still running.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_heartbeat_with_http_info(body, agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HeartbeatAgentIdUuidBody body: (required)
        :param str agent_id_uuid: Unique object ID. (required)
        :return: RimeHeartbeatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'agent_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_heartbeat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `agent_manager_heartbeat`")  # noqa: E501
        # verify the required parameter 'agent_id_uuid' is set
        if ('agent_id_uuid' not in params or
                params['agent_id_uuid'] is None):
            raise ValueError("Missing the required parameter `agent_id_uuid` when calling `agent_manager_heartbeat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_id_uuid' in params:
            path_params['agentId.uuid'] = params['agent_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/internal/agents/heartbeat/{agentId.uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeHeartbeatResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def agent_manager_register_external_agent(self, body, **kwargs):  # noqa: E501
        """RegisterExternalAgent is used by external agents during startup to upload the signing key to the backend. This call is idempotent; it will be called by the external agent upon every restart. No matter there is a signing key exists in the DB, the key is uploaded and created in the DB.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_register_external_agent(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeRegisterExternalAgentRequest body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_register_external_agent_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_register_external_agent_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def agent_manager_register_external_agent_with_http_info(self, body, **kwargs):  # noqa: E501
        """RegisterExternalAgent is used by external agents during startup to upload the signing key to the backend. This call is idempotent; it will be called by the external agent upon every restart. No matter there is a signing key exists in the DB, the key is uploaded and created in the DB.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_register_external_agent_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeRegisterExternalAgentRequest body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_register_external_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `agent_manager_register_external_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/internal/agents/external', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def agent_manager_register_firewall_agent(self, body, **kwargs):  # noqa: E501
        """RegisterFirewallAgent is used by firewall agents during startup to upload the signing key to the CP backend. In addtion, the CP will return a public key that is used to verify user API tokens.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_register_firewall_agent(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeRegisterFirewallAgentRequest body: (required)
        :return: RimeRegisterFirewallAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_register_firewall_agent_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_register_firewall_agent_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def agent_manager_register_firewall_agent_with_http_info(self, body, **kwargs):  # noqa: E501
        """RegisterFirewallAgent is used by firewall agents during startup to upload the signing key to the CP backend. In addtion, the CP will return a public key that is used to verify user API tokens.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_register_firewall_agent_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeRegisterFirewallAgentRequest body: (required)
        :return: RimeRegisterFirewallAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_register_firewall_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `agent_manager_register_firewall_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/internal/agents/firewall', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRegisterFirewallAgentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def agent_manager_update_upgrade_status_for_agent(self, body, agent_id_uuid, **kwargs):  # noqa: E501
        """UpdateUpgradeStatusForAgent updates the status of the upgrade for the agent.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_update_upgrade_status_for_agent(body, agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AgentIdUuidUpgradeBody body: (required)
        :param str agent_id_uuid: Unique object ID. (required)
        :return: RimeUpdateUpgradeStatusForAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_update_upgrade_status_for_agent_with_http_info(body, agent_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_update_upgrade_status_for_agent_with_http_info(body, agent_id_uuid, **kwargs)  # noqa: E501
            return data

    def agent_manager_update_upgrade_status_for_agent_with_http_info(self, body, agent_id_uuid, **kwargs):  # noqa: E501
        """UpdateUpgradeStatusForAgent updates the status of the upgrade for the agent.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_update_upgrade_status_for_agent_with_http_info(body, agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AgentIdUuidUpgradeBody body: (required)
        :param str agent_id_uuid: Unique object ID. (required)
        :return: RimeUpdateUpgradeStatusForAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'agent_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_update_upgrade_status_for_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `agent_manager_update_upgrade_status_for_agent`")  # noqa: E501
        # verify the required parameter 'agent_id_uuid' is set
        if ('agent_id_uuid' not in params or
                params['agent_id_uuid'] is None):
            raise ValueError("Missing the required parameter `agent_id_uuid` when calling `agent_manager_update_upgrade_status_for_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_id_uuid' in params:
            path_params['agentId.uuid'] = params['agent_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/internal/agents/{agentId.uuid}/upgrade', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateUpgradeStatusForAgentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def agent_manager_upsert_firewall_instance(self, body, fw_instance_agent_id_uuid, **kwargs):  # noqa: E501
        """UpsertFirewallInstance  # noqa: E501

        Creates a new firewall instance record in the DB owned by the CP. It does not directly deploy the firewall instance in the firewall agent. This is intended to be called by the firewall agent to update the metadata in the CP.  Example flow: user uses the sdk connected directly to the DP -> agent is created in the DP -> DP calls UpsertFirewallInstance to update the CP and stay in sync  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_upsert_firewall_instance(body, fw_instance_agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpsertFirewallInstanceRequestIsTheRequestForUpsertFirewallInstance body: (required)
        :param str fw_instance_agent_id_uuid: Unique object ID. (required)
        :return: RimeUpsertFirewallInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_upsert_firewall_instance_with_http_info(body, fw_instance_agent_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_upsert_firewall_instance_with_http_info(body, fw_instance_agent_id_uuid, **kwargs)  # noqa: E501
            return data

    def agent_manager_upsert_firewall_instance_with_http_info(self, body, fw_instance_agent_id_uuid, **kwargs):  # noqa: E501
        """UpsertFirewallInstance  # noqa: E501

        Creates a new firewall instance record in the DB owned by the CP. It does not directly deploy the firewall instance in the firewall agent. This is intended to be called by the firewall agent to update the metadata in the CP.  Example flow: user uses the sdk connected directly to the DP -> agent is created in the DP -> DP calls UpsertFirewallInstance to update the CP and stay in sync  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_upsert_firewall_instance_with_http_info(body, fw_instance_agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpsertFirewallInstanceRequestIsTheRequestForUpsertFirewallInstance body: (required)
        :param str fw_instance_agent_id_uuid: Unique object ID. (required)
        :return: RimeUpsertFirewallInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'fw_instance_agent_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_upsert_firewall_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `agent_manager_upsert_firewall_instance`")  # noqa: E501
        # verify the required parameter 'fw_instance_agent_id_uuid' is set
        if ('fw_instance_agent_id_uuid' not in params or
                params['fw_instance_agent_id_uuid'] is None):
            raise ValueError("Missing the required parameter `fw_instance_agent_id_uuid` when calling `agent_manager_upsert_firewall_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'fw_instance_agent_id_uuid' in params:
            path_params['fwInstance.agentId.uuid'] = params['fw_instance_agent_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/internal/agents/firewall/{fwInstance.agentId.uuid}/firewall-instance', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpsertFirewallInstanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_agent(self, body, **kwargs):  # noqa: E501
        """CreateAgent  # noqa: E501

        Creates agent and returns the configuration for installing the agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_agent(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateAgentRequest body: (required)
        :return: RimeCreateAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_agent_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_agent_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_agent_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateAgent  # noqa: E501

        Creates agent and returns the configuration for installing the agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_agent_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateAgentRequest body: (required)
        :return: RimeCreateAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/agents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateAgentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_firewall_agent(self, body, **kwargs):  # noqa: E501
        """CreateFirewallAgent  # noqa: E501

        Creates a firewall agent and returns the api key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_firewall_agent(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateFirewallAgentRequest body: (required)
        :return: RimeCreateFirewallAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_firewall_agent_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_firewall_agent_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_firewall_agent_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateFirewallAgent  # noqa: E501

        Creates a firewall agent and returns the api key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_firewall_agent_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateFirewallAgentRequest body: (required)
        :return: RimeCreateFirewallAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_firewall_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_firewall_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/agents/firewall', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateFirewallAgentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_agent(self, agent_id_uuid, **kwargs):  # noqa: E501
        """DeleteAgent  # noqa: E501

        Deletes a specified agent. Must be called on an already deactivated agent. An error is returned if the deletion fails or if the agent is not in a deletable state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_agent(agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id_uuid: Unique object ID. (required)
        :return: RimeDeleteAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_agent_with_http_info(agent_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_agent_with_http_info(agent_id_uuid, **kwargs)  # noqa: E501
            return data

    def delete_agent_with_http_info(self, agent_id_uuid, **kwargs):  # noqa: E501
        """DeleteAgent  # noqa: E501

        Deletes a specified agent. Must be called on an already deactivated agent. An error is returned if the deletion fails or if the agent is not in a deletable state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_agent_with_http_info(agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id_uuid: Unique object ID. (required)
        :return: RimeDeleteAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_id_uuid' is set
        if ('agent_id_uuid' not in params or
                params['agent_id_uuid'] is None):
            raise ValueError("Missing the required parameter `agent_id_uuid` when calling `delete_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_id_uuid' in params:
            path_params['agentId.uuid'] = params['agent_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/agents/{agentId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteAgentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_agent(self, agent_id_uuid, **kwargs):  # noqa: E501
        """GetAgent  # noqa: E501

        Returns the agent that matches the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agent(agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id_uuid: Unique object ID. (required)
        :return: RimeGetAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_agent_with_http_info(agent_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_agent_with_http_info(agent_id_uuid, **kwargs)  # noqa: E501
            return data

    def get_agent_with_http_info(self, agent_id_uuid, **kwargs):  # noqa: E501
        """GetAgent  # noqa: E501

        Returns the agent that matches the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agent_with_http_info(agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id_uuid: Unique object ID. (required)
        :return: RimeGetAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_id_uuid' is set
        if ('agent_id_uuid' not in params or
                params['agent_id_uuid'] is None):
            raise ValueError("Missing the required parameter `agent_id_uuid` when calling `get_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_id_uuid' in params:
            path_params['agentId.uuid'] = params['agent_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/agents/{agentId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetAgentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_upgrade_for_agent(self, agent_id_uuid, agent_namespace, **kwargs):  # noqa: E501
        """GetUpgradeForAgent returns the desired state of the agent and the current status of the upgrade.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upgrade_for_agent(agent_id_uuid, agent_namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id_uuid: Unique object ID. (required)
        :param str agent_namespace: The namespace in which the agent is deployed. Since namespace is not known in the CP, it must be provided by the launcher when calling GetUpgradeForAgent. (required)
        :param bool return_rendered_manifests: Whether to render and return the Kubernetes manifests
        :return: RimeGetUpgradeForAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_upgrade_for_agent_with_http_info(agent_id_uuid, agent_namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.get_upgrade_for_agent_with_http_info(agent_id_uuid, agent_namespace, **kwargs)  # noqa: E501
            return data

    def get_upgrade_for_agent_with_http_info(self, agent_id_uuid, agent_namespace, **kwargs):  # noqa: E501
        """GetUpgradeForAgent returns the desired state of the agent and the current status of the upgrade.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upgrade_for_agent_with_http_info(agent_id_uuid, agent_namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id_uuid: Unique object ID. (required)
        :param str agent_namespace: The namespace in which the agent is deployed. Since namespace is not known in the CP, it must be provided by the launcher when calling GetUpgradeForAgent. (required)
        :param bool return_rendered_manifests: Whether to render and return the Kubernetes manifests
        :return: RimeGetUpgradeForAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_id_uuid', 'agent_namespace', 'return_rendered_manifests']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_upgrade_for_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_id_uuid' is set
        if ('agent_id_uuid' not in params or
                params['agent_id_uuid'] is None):
            raise ValueError("Missing the required parameter `agent_id_uuid` when calling `get_upgrade_for_agent`")  # noqa: E501
        # verify the required parameter 'agent_namespace' is set
        if ('agent_namespace' not in params or
                params['agent_namespace'] is None):
            raise ValueError("Missing the required parameter `agent_namespace` when calling `get_upgrade_for_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_id_uuid' in params:
            path_params['agentId.uuid'] = params['agent_id_uuid']  # noqa: E501

        query_params = []
        if 'return_rendered_manifests' in params:
            query_params.append(('returnRenderedManifests', params['return_rendered_manifests']))  # noqa: E501
        if 'agent_namespace' in params:
            query_params.append(('agentNamespace', params['agent_namespace']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/agents/{agentId.uuid}/upgrade', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetUpgradeForAgentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_agents(self, **kwargs):  # noqa: E501
        """ListAgents  # noqa: E501

        Returns a paginated list of agents.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_agents(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: The maximum number of Agent objects to return in a single page.
        :param str page_token: Specifies a page of the list returned by a ListAgents query. The ListAgents query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageQuery field.
        :param list[str] first_page_query_agent_status_types: Specifies a set of agent status types. The query filters for results that match the specified types.   - AGENT_STATUS_PENDING: Resources have been created for the agent but the agent has not started yet.  - AGENT_STATUS_ACTIVE: Agent can run jobs.  - AGENT_STATUS_UNRESPONSIVE: No agent heartbeat for three minutes.  - AGENT_STATUS_DEACTIVATED: Agent can no longer run jobs and can be deleted. (Deprecated after Deactivation and Deletion endpoints are combined)
        :param list[str] first_page_query_agent_ids: Specifies a set of agent IDs. The query filters for results that match the specified IDs.
        :param str first_page_query_type: Specifies the type of agent (validation or firewall). The query filters for results that match the specified type.   - AGENT_TYPE_VALIDATION: We use the zero value for VALIDATION for backwards compatibility with existing agents. protolint:disable:next ENUM_FIELD_NAMES_ZERO_VALUE_END_WITH
        :return: RimeListAgentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_agents_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_agents_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_agents_with_http_info(self, **kwargs):  # noqa: E501
        """ListAgents  # noqa: E501

        Returns a paginated list of agents.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_agents_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: The maximum number of Agent objects to return in a single page.
        :param str page_token: Specifies a page of the list returned by a ListAgents query. The ListAgents query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageQuery field.
        :param list[str] first_page_query_agent_status_types: Specifies a set of agent status types. The query filters for results that match the specified types.   - AGENT_STATUS_PENDING: Resources have been created for the agent but the agent has not started yet.  - AGENT_STATUS_ACTIVE: Agent can run jobs.  - AGENT_STATUS_UNRESPONSIVE: No agent heartbeat for three minutes.  - AGENT_STATUS_DEACTIVATED: Agent can no longer run jobs and can be deleted. (Deprecated after Deactivation and Deletion endpoints are combined)
        :param list[str] first_page_query_agent_ids: Specifies a set of agent IDs. The query filters for results that match the specified IDs.
        :param str first_page_query_type: Specifies the type of agent (validation or firewall). The query filters for results that match the specified type.   - AGENT_TYPE_VALIDATION: We use the zero value for VALIDATION for backwards compatibility with existing agents. protolint:disable:next ENUM_FIELD_NAMES_ZERO_VALUE_END_WITH
        :return: RimeListAgentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_token', 'first_page_query_agent_status_types', 'first_page_query_agent_ids', 'first_page_query_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_agents" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'first_page_query_agent_status_types' in params:
            query_params.append(('firstPageQuery.agentStatusTypes', params['first_page_query_agent_status_types']))  # noqa: E501
            collection_formats['firstPageQuery.agentStatusTypes'] = 'multi'  # noqa: E501
        if 'first_page_query_agent_ids' in params:
            query_params.append(('firstPageQuery.agentIds', params['first_page_query_agent_ids']))  # noqa: E501
            collection_formats['firstPageQuery.agentIds'] = 'multi'  # noqa: E501
        if 'first_page_query_type' in params:
            query_params.append(('firstPageQuery.type', params['first_page_query_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/agents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListAgentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_firewall_instances(self, body, **kwargs):  # noqa: E501
        """ListFirewallInstances  # noqa: E501

        Returns a paginated list of firewall instances.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_firewall_instances(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeListFirewallInstancesRequest body: (required)
        :return: RimeListFirewallInstancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_firewall_instances_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.list_firewall_instances_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def list_firewall_instances_with_http_info(self, body, **kwargs):  # noqa: E501
        """ListFirewallInstances  # noqa: E501

        Returns a paginated list of firewall instances.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_firewall_instances_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeListFirewallInstancesRequest body: (required)
        :return: RimeListFirewallInstancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_firewall_instances" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `list_firewall_instances`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/agents/firewall/instances', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListFirewallInstancesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def request_firewall_instance(self, body, agent_id_uuid, **kwargs):  # noqa: E501
        """RequestFirewallInstance  # noqa: E501

        Creates a new firewall instance record in the DB with REQUESTED status. Expects firewall agent in the DP to check for and eventually deploy the firewall instance.  This is intended to be used by external clients of the CP.  Example flow: user logs into the UI connected to the CP -> user tries to create agent in the UI -> UI calls RequestFirewallInstance -> CP tries to create the agent with the DP and then update the status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_firewall_instance(body, agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallinstanceRequestBody body: (required)
        :param str agent_id_uuid: Unique object ID. (required)
        :return: RimeRequestFirewallInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.request_firewall_instance_with_http_info(body, agent_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.request_firewall_instance_with_http_info(body, agent_id_uuid, **kwargs)  # noqa: E501
            return data

    def request_firewall_instance_with_http_info(self, body, agent_id_uuid, **kwargs):  # noqa: E501
        """RequestFirewallInstance  # noqa: E501

        Creates a new firewall instance record in the DB with REQUESTED status. Expects firewall agent in the DP to check for and eventually deploy the firewall instance.  This is intended to be used by external clients of the CP.  Example flow: user logs into the UI connected to the CP -> user tries to create agent in the UI -> UI calls RequestFirewallInstance -> CP tries to create the agent with the DP and then update the status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_firewall_instance_with_http_info(body, agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallinstanceRequestBody body: (required)
        :param str agent_id_uuid: Unique object ID. (required)
        :return: RimeRequestFirewallInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'agent_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_firewall_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `request_firewall_instance`")  # noqa: E501
        # verify the required parameter 'agent_id_uuid' is set
        if ('agent_id_uuid' not in params or
                params['agent_id_uuid'] is None):
            raise ValueError("Missing the required parameter `agent_id_uuid` when calling `request_firewall_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_id_uuid' in params:
            path_params['agentId.uuid'] = params['agent_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/agents/firewall/{agentId.uuid}/firewall-instance/request', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRequestFirewallInstanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upgrade_agent(self, body, agent_id_uuid, **kwargs):  # noqa: E501
        """UpgradeAgent starts the process of upgrading the agent to the version of the control plane  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upgrade_agent(body, agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AgentIdUuidUpgradeBody1 body: (required)
        :param str agent_id_uuid: Unique object ID. (required)
        :return: RimeUpgradeAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upgrade_agent_with_http_info(body, agent_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.upgrade_agent_with_http_info(body, agent_id_uuid, **kwargs)  # noqa: E501
            return data

    def upgrade_agent_with_http_info(self, body, agent_id_uuid, **kwargs):  # noqa: E501
        """UpgradeAgent starts the process of upgrading the agent to the version of the control plane  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upgrade_agent_with_http_info(body, agent_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AgentIdUuidUpgradeBody1 body: (required)
        :param str agent_id_uuid: Unique object ID. (required)
        :return: RimeUpgradeAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'agent_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upgrade_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `upgrade_agent`")  # noqa: E501
        # verify the required parameter 'agent_id_uuid' is set
        if ('agent_id_uuid' not in params or
                params['agent_id_uuid'] is None):
            raise ValueError("Missing the required parameter `agent_id_uuid` when calling `upgrade_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_id_uuid' in params:
            path_params['agentId.uuid'] = params['agent_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/agents/{agentId.uuid}/upgrade', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpgradeAgentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
