# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class CustomerManagedKeyServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_customer_managed_key(self, body, **kwargs):  # noqa: E501
        """CreateCustomerManagedKey  # noqa: E501

        Creates a new customer managed key. At most one key can exist per deployment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer_managed_key(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateCustomerManagedKeyRequest body: (required)
        :return: RimeCreateCustomerManagedKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_customer_managed_key_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_customer_managed_key_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_customer_managed_key_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateCustomerManagedKey  # noqa: E501

        Creates a new customer managed key. At most one key can exist per deployment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer_managed_key_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateCustomerManagedKeyRequest body: (required)
        :return: RimeCreateCustomerManagedKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_customer_managed_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_customer_managed_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/customer-managed-key', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateCustomerManagedKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_customer_managed_key(self, cmk_config_kms_key_arn, **kwargs):  # noqa: E501
        """DeleteCustomerManagedKey  # noqa: E501

        Delete the customer managed key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_managed_key(cmk_config_kms_key_arn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cmk_config_kms_key_arn: The ARN of the AWS KMS key to use as the customer managed key. (required)
        :param str cmk_config_key_provider:  - KEY_PROVIDER_AWS_KMS: AWS Key Management Service
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_customer_managed_key_with_http_info(cmk_config_kms_key_arn, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_customer_managed_key_with_http_info(cmk_config_kms_key_arn, **kwargs)  # noqa: E501
            return data

    def delete_customer_managed_key_with_http_info(self, cmk_config_kms_key_arn, **kwargs):  # noqa: E501
        """DeleteCustomerManagedKey  # noqa: E501

        Delete the customer managed key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_managed_key_with_http_info(cmk_config_kms_key_arn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cmk_config_kms_key_arn: The ARN of the AWS KMS key to use as the customer managed key. (required)
        :param str cmk_config_key_provider:  - KEY_PROVIDER_AWS_KMS: AWS Key Management Service
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cmk_config_kms_key_arn', 'cmk_config_key_provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_customer_managed_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cmk_config_kms_key_arn' is set
        if ('cmk_config_kms_key_arn' not in params or
                params['cmk_config_kms_key_arn'] is None):
            raise ValueError("Missing the required parameter `cmk_config_kms_key_arn` when calling `delete_customer_managed_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cmk_config_key_provider' in params:
            query_params.append(('cmkConfig.keyProvider', params['cmk_config_key_provider']))  # noqa: E501
        if 'cmk_config_kms_key_arn' in params:
            query_params.append(('cmkConfig.kmsKeyArn', params['cmk_config_kms_key_arn']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/customer-managed-key', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_managed_key(self, cmk_config_kms_key_arn, **kwargs):  # noqa: E501
        """GetCustomerManagedKey  # noqa: E501

        Returns a customer managed key if one has been created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_managed_key(cmk_config_kms_key_arn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cmk_config_kms_key_arn: The ARN of the AWS KMS key to use as the customer managed key. (required)
        :param str cmk_config_key_provider:  - KEY_PROVIDER_AWS_KMS: AWS Key Management Service
        :return: RimeGetCustomerManagedKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_managed_key_with_http_info(cmk_config_kms_key_arn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_managed_key_with_http_info(cmk_config_kms_key_arn, **kwargs)  # noqa: E501
            return data

    def get_customer_managed_key_with_http_info(self, cmk_config_kms_key_arn, **kwargs):  # noqa: E501
        """GetCustomerManagedKey  # noqa: E501

        Returns a customer managed key if one has been created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_managed_key_with_http_info(cmk_config_kms_key_arn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cmk_config_kms_key_arn: The ARN of the AWS KMS key to use as the customer managed key. (required)
        :param str cmk_config_key_provider:  - KEY_PROVIDER_AWS_KMS: AWS Key Management Service
        :return: RimeGetCustomerManagedKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cmk_config_kms_key_arn', 'cmk_config_key_provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_managed_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cmk_config_kms_key_arn' is set
        if ('cmk_config_kms_key_arn' not in params or
                params['cmk_config_kms_key_arn'] is None):
            raise ValueError("Missing the required parameter `cmk_config_kms_key_arn` when calling `get_customer_managed_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cmk_config_key_provider' in params:
            query_params.append(('cmkConfig.keyProvider', params['cmk_config_key_provider']))  # noqa: E501
        if 'cmk_config_kms_key_arn' in params:
            query_params.append(('cmkConfig.kmsKeyArn', params['cmk_config_kms_key_arn']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/customer-managed-key', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetCustomerManagedKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_key_status(self, **kwargs):  # noqa: E501
        """GetKeyStatus  # noqa: E501

        Return whether the customer managed key is active or revoked.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_key_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RimeGetKeyStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_key_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_key_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_key_status_with_http_info(self, **kwargs):  # noqa: E501
        """GetKeyStatus  # noqa: E501

        Return whether the customer managed key is active or revoked.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_key_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RimeGetKeyStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_key_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/customer-managed-key/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetKeyStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
