# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class FileScanningApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_file_scan_result(self, file_scan_id_uuid, **kwargs):  # noqa: E501
        """DeleteFileScanResult  # noqa: E501

        Deletes a File Scan result by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_scan_result(file_scan_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_scan_id_uuid: Unique object ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_file_scan_result_with_http_info(file_scan_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_file_scan_result_with_http_info(file_scan_id_uuid, **kwargs)  # noqa: E501
            return data

    def delete_file_scan_result_with_http_info(self, file_scan_id_uuid, **kwargs):  # noqa: E501
        """DeleteFileScanResult  # noqa: E501

        Deletes a File Scan result by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_scan_result_with_http_info(file_scan_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_scan_id_uuid: Unique object ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_scan_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file_scan_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_scan_id_uuid' is set
        if ('file_scan_id_uuid' not in params or
                params['file_scan_id_uuid'] is None):
            raise ValueError("Missing the required parameter `file_scan_id_uuid` when calling `delete_file_scan_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_scan_id_uuid' in params:
            path_params['fileScanId.uuid'] = params['file_scan_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/file-scan-results/{fileScanId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_scan_result(self, file_scan_id_uuid, **kwargs):  # noqa: E501
        """GetFileScanResult  # noqa: E501

        Returns a File Scan result by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_scan_result(file_scan_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_scan_id_uuid: Unique object ID. (required)
        :return: RimeGetFileScanResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_scan_result_with_http_info(file_scan_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_scan_result_with_http_info(file_scan_id_uuid, **kwargs)  # noqa: E501
            return data

    def get_file_scan_result_with_http_info(self, file_scan_id_uuid, **kwargs):  # noqa: E501
        """GetFileScanResult  # noqa: E501

        Returns a File Scan result by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_scan_result_with_http_info(file_scan_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_scan_id_uuid: Unique object ID. (required)
        :return: RimeGetFileScanResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_scan_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_scan_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_scan_id_uuid' is set
        if ('file_scan_id_uuid' not in params or
                params['file_scan_id_uuid'] is None):
            raise ValueError("Missing the required parameter `file_scan_id_uuid` when calling `get_file_scan_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_scan_id_uuid' in params:
            path_params['fileScanId.uuid'] = params['file_scan_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/file-scan-results/{fileScanId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetFileScanResultResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_file_scan_results(self, **kwargs):  # noqa: E501
        """ListFileScanResults  # noqa: E501

        Returns a paginated list of all File Scan results for the project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_file_scan_results(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str first_page_query_project_id_uuid: Unique object ID.
        :param str first_page_query_model_id_uuid: Unique object ID.
        :param str page_token: Specifies a page of the list returned by a ListFileScan query beyond the first page.
        :param str page_size: Defines the maximum number of results on a given page. API call pagination navigates through the entire set of results in groups of the specified page size.
        :return: RimeListFileScanResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_file_scan_results_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_file_scan_results_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_file_scan_results_with_http_info(self, **kwargs):  # noqa: E501
        """ListFileScanResults  # noqa: E501

        Returns a paginated list of all File Scan results for the project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_file_scan_results_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str first_page_query_project_id_uuid: Unique object ID.
        :param str first_page_query_model_id_uuid: Unique object ID.
        :param str page_token: Specifies a page of the list returned by a ListFileScan query beyond the first page.
        :param str page_size: Defines the maximum number of results on a given page. API call pagination navigates through the entire set of results in groups of the specified page size.
        :return: RimeListFileScanResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['first_page_query_project_id_uuid', 'first_page_query_model_id_uuid', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_file_scan_results" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'first_page_query_project_id_uuid' in params:
            query_params.append(('firstPageQuery.projectId.uuid', params['first_page_query_project_id_uuid']))  # noqa: E501
        if 'first_page_query_model_id_uuid' in params:
            query_params.append(('firstPageQuery.modelId.uuid', params['first_page_query_model_id_uuid']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/file-scan-results', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListFileScanResultsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
