# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class FirewallApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def effective_config(self, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """GetFirewallEffectiveConfig  # noqa: E501

        Retrieve the effective config of the firewall. The effective config is the users config plus all defaults. This request will be routed to a specific FirewallInstance. There can be multiple FirewallInstances in the cluster with different configurations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.effective_config(firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: GenerativefirewallGetFirewallEffectiveConfigResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.effective_config_with_http_info(firewall_instance_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.effective_config_with_http_info(firewall_instance_id_uuid, **kwargs)  # noqa: E501
            return data

    def effective_config_with_http_info(self, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """GetFirewallEffectiveConfig  # noqa: E501

        Retrieve the effective config of the firewall. The effective config is the users config plus all defaults. This request will be routed to a specific FirewallInstance. There can be multiple FirewallInstances in the cluster with different configurations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.effective_config_with_http_info(firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: GenerativefirewallGetFirewallEffectiveConfigResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_instance_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method effective_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_instance_id_uuid' is set
        if ('firewall_instance_id_uuid' not in params or
                params['firewall_instance_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_instance_id_uuid` when calling `effective_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_instance_id_uuid' in params:
            path_params['firewallInstanceId.uuid'] = params['firewall_instance_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/firewall/{firewallInstanceId.uuid}/effective-config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenerativefirewallGetFirewallEffectiveConfigResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def health(self, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """Health  # noqa: E501

        Health performs a health check on the firewall. This request returns a 200 OK if the firewall instance is healthy. We are adding a separate health endpoint to the firewall instance to allow for more granular monitoring and alerting since the firewall is a critical component of the system. This endpoint is routinely called by the instance manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.health(firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: GenerativefirewallInstanceHealthResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.health_with_http_info(firewall_instance_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.health_with_http_info(firewall_instance_id_uuid, **kwargs)  # noqa: E501
            return data

    def health_with_http_info(self, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """Health  # noqa: E501

        Health performs a health check on the firewall. This request returns a 200 OK if the firewall instance is healthy. We are adding a separate health endpoint to the firewall instance to allow for more granular monitoring and alerting since the firewall is a critical component of the system. This endpoint is routinely called by the instance manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.health_with_http_info(firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: GenerativefirewallInstanceHealthResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_instance_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method health" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_instance_id_uuid' is set
        if ('firewall_instance_id_uuid' not in params or
                params['firewall_instance_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_instance_id_uuid` when calling `health`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_instance_id_uuid' in params:
            path_params['firewallInstanceId.uuid'] = params['firewall_instance_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/firewall/{firewallInstanceId.uuid}/health', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenerativefirewallInstanceHealthResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate(self, body, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """Validate  # noqa: E501

        Validate performs real-time validation on a single query to the model. This request will be routed to a specific FirewallInstance. There can be multiple FirewallInstances in the cluster with different configurations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate(body, firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallInstanceIdUuidValidateBody body: (required)
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: GenerativefirewallValidateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validate_with_http_info(body, firewall_instance_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.validate_with_http_info(body, firewall_instance_id_uuid, **kwargs)  # noqa: E501
            return data

    def validate_with_http_info(self, body, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """Validate  # noqa: E501

        Validate performs real-time validation on a single query to the model. This request will be routed to a specific FirewallInstance. There can be multiple FirewallInstances in the cluster with different configurations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_with_http_info(body, firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallInstanceIdUuidValidateBody body: (required)
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: GenerativefirewallValidateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'firewall_instance_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `validate`")  # noqa: E501
        # verify the required parameter 'firewall_instance_id_uuid' is set
        if ('firewall_instance_id_uuid' not in params or
                params['firewall_instance_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_instance_id_uuid` when calling `validate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_instance_id_uuid' in params:
            path_params['firewallInstanceId.uuid'] = params['firewall_instance_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/firewall/{firewallInstanceId.uuid}/validate', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenerativefirewallValidateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
