# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class FirewallInstanceManagerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_instance(self, body, **kwargs):  # noqa: E501
        """CreateFirewallInstance  # noqa: E501

        This creates a new Firewall Instance with the desired user configuration. It will take time for the new instance to become available; use the `GetFirewallInstance` API to track the status of the deployment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instance(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenerativefirewallCreateFirewallInstanceRequest body: (required)
        :return: GenerativefirewallCreateFirewallInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_instance_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_instance_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_instance_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateFirewallInstance  # noqa: E501

        This creates a new Firewall Instance with the desired user configuration. It will take time for the new instance to become available; use the `GetFirewallInstance` API to track the status of the deployment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instance_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenerativefirewallCreateFirewallInstanceRequest body: (required)
        :return: GenerativefirewallCreateFirewallInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/firewall-instance', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenerativefirewallCreateFirewallInstanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_instance(self, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """DeleteFirewallInstance  # noqa: E501

        This hard-deletes a Firewall Instance from the cluster. Be careful with this API because it will interrupt in-flight validation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_instance(firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_instance_with_http_info(firewall_instance_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_instance_with_http_info(firewall_instance_id_uuid, **kwargs)  # noqa: E501
            return data

    def delete_instance_with_http_info(self, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """DeleteFirewallInstance  # noqa: E501

        This hard-deletes a Firewall Instance from the cluster. Be careful with this API because it will interrupt in-flight validation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_instance_with_http_info(firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_instance_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_instance_id_uuid' is set
        if ('firewall_instance_id_uuid' not in params or
                params['firewall_instance_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_instance_id_uuid` when calling `delete_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_instance_id_uuid' in params:
            path_params['firewallInstanceId.uuid'] = params['firewall_instance_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/firewall-instance/{firewallInstanceId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instance(self, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """GetFirewallInstance  # noqa: E501

        This retrieves information about a single Firewall Instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instance(firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: GenerativefirewallGetFirewallInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instance_with_http_info(firewall_instance_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instance_with_http_info(firewall_instance_id_uuid, **kwargs)  # noqa: E501
            return data

    def get_instance_with_http_info(self, firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """GetFirewallInstance  # noqa: E501

        This retrieves information about a single Firewall Instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instance_with_http_info(firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_instance_id_uuid: Unique object ID. (required)
        :return: GenerativefirewallGetFirewallInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_instance_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_instance_id_uuid' is set
        if ('firewall_instance_id_uuid' not in params or
                params['firewall_instance_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_instance_id_uuid` when calling `get_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_instance_id_uuid' in params:
            path_params['firewallInstanceId.uuid'] = params['firewall_instance_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/firewall-instance/{firewallInstanceId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenerativefirewallGetFirewallInstanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_instances(self, **kwargs):  # noqa: E501
        """ListFirewallInstances  # noqa: E501

        This lists the Firewall Instances on the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_instances(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApigenerativefirewallListFirewallInstancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_instances_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_instances_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_instances_with_http_info(self, **kwargs):  # noqa: E501
        """ListFirewallInstances  # noqa: E501

        This lists the Firewall Instances on the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApigenerativefirewallListFirewallInstancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_instances" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/firewall-instance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApigenerativefirewallListFirewallInstancesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_instance(self, body, firewall_instance_firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """UpdateFirewallInstance  # noqa: E501

        Update an existing FirewallInstance. This redeploys the firewall instance. The status will be REDEPLOYING until the new version of the firewall instance reaches READY.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instance(body, firewall_instance_firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallinstanceFirewallInstanceFirewallInstanceIdUuidBody body: (required)
        :param str firewall_instance_firewall_instance_id_uuid: Unique object ID. (required)
        :param str mask:
        :return: GenerativefirewallUpdateFirewallInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_instance_with_http_info(body, firewall_instance_firewall_instance_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_instance_with_http_info(body, firewall_instance_firewall_instance_id_uuid, **kwargs)  # noqa: E501
            return data

    def update_instance_with_http_info(self, body, firewall_instance_firewall_instance_id_uuid, **kwargs):  # noqa: E501
        """UpdateFirewallInstance  # noqa: E501

        Update an existing FirewallInstance. This redeploys the firewall instance. The status will be REDEPLOYING until the new version of the firewall instance reaches READY.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instance_with_http_info(body, firewall_instance_firewall_instance_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallinstanceFirewallInstanceFirewallInstanceIdUuidBody body: (required)
        :param str firewall_instance_firewall_instance_id_uuid: Unique object ID. (required)
        :param str mask:
        :return: GenerativefirewallUpdateFirewallInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'firewall_instance_firewall_instance_id_uuid', 'mask']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_instance`")  # noqa: E501
        # verify the required parameter 'firewall_instance_firewall_instance_id_uuid' is set
        if ('firewall_instance_firewall_instance_id_uuid' not in params or
                params['firewall_instance_firewall_instance_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_instance_firewall_instance_id_uuid` when calling `update_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_instance_firewall_instance_id_uuid' in params:
            path_params['firewallInstance.firewallInstanceId.uuid'] = params['firewall_instance_firewall_instance_id_uuid']  # noqa: E501

        query_params = []
        if 'mask' in params:
            query_params.append(('mask', params['mask']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/firewall-instance/{firewallInstance.firewallInstanceId.uuid}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenerativefirewallUpdateFirewallInstanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
