# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class GenerativeValidationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def quick_scan(self, body, **kwargs):  # noqa: E501
        """Start Generative AI Validation Quick Scan  # noqa: E501

        Starts an AI Validation quick scan on the specified generative model.  Results for this are not comprehensive. The status of the job can be tracked through the [JobReader service](#tag/JobReader). The results can of the test  can be retrieved using the [Results endpoint](#tag/GenerativeModelTesting/operation/Results).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.quick_scan(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenerativevalidationStartTestRequest body: (required)
        :return: GenerativevalidationStartTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.quick_scan_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.quick_scan_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def quick_scan_with_http_info(self, body, **kwargs):  # noqa: E501
        """Start Generative AI Validation Quick Scan  # noqa: E501

        Starts an AI Validation quick scan on the specified generative model.  Results for this are not comprehensive. The status of the job can be tracked through the [JobReader service](#tag/JobReader). The results can of the test  can be retrieved using the [Results endpoint](#tag/GenerativeModelTesting/operation/Results).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.quick_scan_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenerativevalidationStartTestRequest body: (required)
        :return: GenerativevalidationStartTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method quick_scan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `quick_scan`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/generative/testing/quick', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenerativevalidationStartTestResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def results(self, job_id_uuid, **kwargs):  # noqa: E501
        """Get Generative AI Validation Results  # noqa: E501

        Retrieve the results of a generative model testing for a successful job. This is a paginated API.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results(job_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id_uuid: Unique object ID. (required)
        :param str page_token: A token representing one page from the list returned by a GetResults API. The GetResults API returns a page_token when there is more than one page of results.
        :param str page_size: The maximum number of objects to return in a single page.  Maximum page size is 1000.
        :return: GenerativevalidationGetResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.results_with_http_info(job_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.results_with_http_info(job_id_uuid, **kwargs)  # noqa: E501
            return data

    def results_with_http_info(self, job_id_uuid, **kwargs):  # noqa: E501
        """Get Generative AI Validation Results  # noqa: E501

        Retrieve the results of a generative model testing for a successful job. This is a paginated API.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_with_http_info(job_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id_uuid: Unique object ID. (required)
        :param str page_token: A token representing one page from the list returned by a GetResults API. The GetResults API returns a page_token when there is more than one page of results.
        :param str page_size: The maximum number of objects to return in a single page.  Maximum page size is 1000.
        :return: GenerativevalidationGetResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id_uuid', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method results" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_id_uuid' is set
        if ('job_id_uuid' not in params or
                params['job_id_uuid'] is None):
            raise ValueError("Missing the required parameter `job_id_uuid` when calling `results`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id_uuid' in params:
            path_params['jobId.uuid'] = params['job_id_uuid']  # noqa: E501

        query_params = []
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/generative/testing/{jobId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenerativevalidationGetResultsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_generative_test(self, body, **kwargs):  # noqa: E501
        """Start a Generative AI Validation Test  # noqa: E501

        Starts an AI validation test on the specified generative model. Generative testing is designed to work with a model that is served over an HTTP endpoint that returns JSON. It assumes that the model is a Q&A style model which takes a prompt as an input and returns a single textual response. See the API details for supported features, such as system prompt.  The status of the job can be tracked through the [JobReader service](#tag/JobReader). The results of the test can be retrieved using the [Results endpoint](#tag/GenerativeModelTesting/operation/Results).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_generative_test(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenerativevalidationStartTestRequest body: (required)
        :return: GenerativevalidationStartTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.start_generative_test_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.start_generative_test_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def start_generative_test_with_http_info(self, body, **kwargs):  # noqa: E501
        """Start a Generative AI Validation Test  # noqa: E501

        Starts an AI validation test on the specified generative model. Generative testing is designed to work with a model that is served over an HTTP endpoint that returns JSON. It assumes that the model is a Q&A style model which takes a prompt as an input and returns a single textual response. See the API details for supported features, such as system prompt.  The status of the job can be tracked through the [JobReader service](#tag/JobReader). The results of the test can be retrieved using the [Results endpoint](#tag/GenerativeModelTesting/operation/Results).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_generative_test_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenerativevalidationStartTestRequest body: (required)
        :return: GenerativevalidationStartTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_generative_test" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `start_generative_test`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/generative/testing', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenerativevalidationStartTestResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
