# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class NotificationSettingApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_notification(self, body, **kwargs):  # noqa: E501
        """CreateNotification  # noqa: E501

        Creates a new notification setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateNotificationRequest body: (required)
        :return: RimeCreateNotificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_notification_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_notification_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_notification_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateNotification  # noqa: E501

        Creates a new notification setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateNotificationRequest body: (required)
        :return: RimeCreateNotificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/notif-settings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateNotificationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_notification(self, id_uuid, **kwargs):  # noqa: E501
        """DeleteNotification  # noqa: E501

        Hard-delete a notification setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification(id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_uuid: Unique object ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_notification_with_http_info(id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_notification_with_http_info(id_uuid, **kwargs)  # noqa: E501
            return data

    def delete_notification_with_http_info(self, id_uuid, **kwargs):  # noqa: E501
        """DeleteNotification  # noqa: E501

        Hard-delete a notification setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_with_http_info(id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_uuid: Unique object ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_uuid' is set
        if ('id_uuid' not in params or
                params['id_uuid'] is None):
            raise ValueError("Missing the required parameter `id_uuid` when calling `delete_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_uuid' in params:
            path_params['id.uuid'] = params['id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/notif-settings/{id.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_notifications(self, **kwargs):  # noqa: E501
        """ListNotifications  # noqa: E501

        Lists notification settings with options to filter by project or the type of notification.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_notifications(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] list_notifications_query_object_types: Specifies a set of object types. Filters results by the specified set of object types.   - OBJECT_TYPE_UNSPECIFIED: Unspecified is an invalid object type - do not use.  - OBJECT_TYPE_PROJECT: Used for notifications associated with an project. The Notification object ID is the Project ID.
        :param list[str] list_notifications_query_object_ids: Specifies a set of object IDs. Filters results by the specified set of object IDs.
        :param str page_token: Specifies a page of the list returned by a ListNotifications query. The ListNotifications query returns a pageToken when there is more than one page of results. Specify either this field or the listNotificationsQuery field.
        :param str page_size: The maximum number of Notification objects to return in a single page.
        :return: RimeListNotificationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_notifications_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_notifications_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_notifications_with_http_info(self, **kwargs):  # noqa: E501
        """ListNotifications  # noqa: E501

        Lists notification settings with options to filter by project or the type of notification.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_notifications_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] list_notifications_query_object_types: Specifies a set of object types. Filters results by the specified set of object types.   - OBJECT_TYPE_UNSPECIFIED: Unspecified is an invalid object type - do not use.  - OBJECT_TYPE_PROJECT: Used for notifications associated with an project. The Notification object ID is the Project ID.
        :param list[str] list_notifications_query_object_ids: Specifies a set of object IDs. Filters results by the specified set of object IDs.
        :param str page_token: Specifies a page of the list returned by a ListNotifications query. The ListNotifications query returns a pageToken when there is more than one page of results. Specify either this field or the listNotificationsQuery field.
        :param str page_size: The maximum number of Notification objects to return in a single page.
        :return: RimeListNotificationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_notifications_query_object_types', 'list_notifications_query_object_ids', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_notifications" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'list_notifications_query_object_types' in params:
            query_params.append(('listNotificationsQuery.objectTypes', params['list_notifications_query_object_types']))  # noqa: E501
            collection_formats['listNotificationsQuery.objectTypes'] = 'multi'  # noqa: E501
        if 'list_notifications_query_object_ids' in params:
            query_params.append(('listNotificationsQuery.objectIds', params['list_notifications_query_object_ids']))  # noqa: E501
            collection_formats['listNotificationsQuery.objectIds'] = 'multi'  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/notif-settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListNotificationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_notification(self, body, notification_id_uuid, **kwargs):  # noqa: E501
        """UpdateNotification  # noqa: E501

        Updates an existing notification setting. The ID in the provided notification is used to identify it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_notification(body, notification_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NotifsettingsNotificationIdUuidBody body: (required)
        :param str notification_id_uuid: Unique object ID. (required)
        :return: RimeUpdateNotificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_notification_with_http_info(body, notification_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_notification_with_http_info(body, notification_id_uuid, **kwargs)  # noqa: E501
            return data

    def update_notification_with_http_info(self, body, notification_id_uuid, **kwargs):  # noqa: E501
        """UpdateNotification  # noqa: E501

        Updates an existing notification setting. The ID in the provided notification is used to identify it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_notification_with_http_info(body, notification_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NotifsettingsNotificationIdUuidBody body: (required)
        :param str notification_id_uuid: Unique object ID. (required)
        :return: RimeUpdateNotificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'notification_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_notification`")  # noqa: E501
        # verify the required parameter 'notification_id_uuid' is set
        if ('notification_id_uuid' not in params or
                params['notification_id_uuid'] is None):
            raise ValueError("Missing the required parameter `notification_id_uuid` when calling `update_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_id_uuid' in params:
            path_params['notification.id.uuid'] = params['notification_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/notif-settings/{notification.id.uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateNotificationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
