# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class ProjectServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def activate_schedule_for_project(self, body, project_id_uuid, schedule_id_uuid, **kwargs):  # noqa: E501
        """ActivateScheduleForProject  # noqa: E501

        Add a Schedule to run automatic tests for a Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.activate_schedule_for_project(body, project_id_uuid, schedule_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScheduleIdUuidActivateBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :param str schedule_id_uuid: Unique object ID. (required)
        :return: ProjectActivateScheduleForProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.activate_schedule_for_project_with_http_info(body, project_id_uuid, schedule_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.activate_schedule_for_project_with_http_info(body, project_id_uuid, schedule_id_uuid, **kwargs)  # noqa: E501
            return data

    def activate_schedule_for_project_with_http_info(self, body, project_id_uuid, schedule_id_uuid, **kwargs):  # noqa: E501
        """ActivateScheduleForProject  # noqa: E501

        Add a Schedule to run automatic tests for a Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.activate_schedule_for_project_with_http_info(body, project_id_uuid, schedule_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScheduleIdUuidActivateBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :param str schedule_id_uuid: Unique object ID. (required)
        :return: ProjectActivateScheduleForProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid', 'schedule_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method activate_schedule_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `activate_schedule_for_project`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `activate_schedule_for_project`")  # noqa: E501
        # verify the required parameter 'schedule_id_uuid' is set
        if ('schedule_id_uuid' not in params or
                params['schedule_id_uuid'] is None):
            raise ValueError("Missing the required parameter `schedule_id_uuid` when calling `activate_schedule_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501
        if 'schedule_id_uuid' in params:
            path_params['scheduleId.uuid'] = params['schedule_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/projects/{projectId.uuid}/schedule/{scheduleId.uuid}/activate', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectActivateScheduleForProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_users_to_project(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """AddUsersToProject  # noqa: E501

        Grants existing Organization users permissions to a Project for a given Project ID, based on the pairs of role and User ID provided in the request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_users_to_project(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RoleUsersBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectAddUsersToProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_users_to_project_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.add_users_to_project_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
            return data

    def add_users_to_project_with_http_info(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """AddUsersToProject  # noqa: E501

        Grants existing Organization users permissions to a Project for a given Project ID, based on the pairs of role and User ID provided in the request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_users_to_project_with_http_info(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RoleUsersBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectAddUsersToProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_users_to_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_users_to_project`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `add_users_to_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId.uuid}/role/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectAddUsersToProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_project(self, body, **kwargs):  # noqa: E501
        """CreateProject  # noqa: E501

        Creates a Project with required fields. Project is an organizational entity under a Workspace that contains Test Runs, Continuous Tests, and Stress Tests, along with their configurations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectCreateProjectRequest body: (required)
        :return: ProjectCreateProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_project_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_project_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_project_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateProject  # noqa: E501

        Creates a Project with required fields. Project is an organizational entity under a Workspace that contains Test Runs, Continuous Tests, and Stress Tests, along with their configurations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectCreateProjectRequest body: (required)
        :return: ProjectCreateProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectCreateProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deactivate_schedule_for_project(self, body, project_id_uuid, schedule_id_uuid, **kwargs):  # noqa: E501
        """DeactivateScheduleForProject  # noqa: E501

        Remove a Schedule from a Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deactivate_schedule_for_project(body, project_id_uuid, schedule_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScheduleIdUuidDeactivateBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :param str schedule_id_uuid: Unique object ID. (required)
        :return: ProjectDeactivateScheduleForProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.deactivate_schedule_for_project_with_http_info(body, project_id_uuid, schedule_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.deactivate_schedule_for_project_with_http_info(body, project_id_uuid, schedule_id_uuid, **kwargs)  # noqa: E501
            return data

    def deactivate_schedule_for_project_with_http_info(self, body, project_id_uuid, schedule_id_uuid, **kwargs):  # noqa: E501
        """DeactivateScheduleForProject  # noqa: E501

        Remove a Schedule from a Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deactivate_schedule_for_project_with_http_info(body, project_id_uuid, schedule_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScheduleIdUuidDeactivateBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :param str schedule_id_uuid: Unique object ID. (required)
        :return: ProjectDeactivateScheduleForProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid', 'schedule_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deactivate_schedule_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `deactivate_schedule_for_project`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `deactivate_schedule_for_project`")  # noqa: E501
        # verify the required parameter 'schedule_id_uuid' is set
        if ('schedule_id_uuid' not in params or
                params['schedule_id_uuid'] is None):
            raise ValueError("Missing the required parameter `schedule_id_uuid` when calling `deactivate_schedule_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501
        if 'schedule_id_uuid' in params:
            path_params['scheduleId.uuid'] = params['schedule_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/projects/{projectId.uuid}/schedule/{scheduleId.uuid}/deactivate', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectDeactivateScheduleForProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_project(self, project_id_uuid, **kwargs):  # noqa: E501
        """DeleteProject  # noqa: E501

        Deletes a Project for a given Project ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectDeleteProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_project_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_project_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
            return data

    def delete_project_with_http_info(self, project_id_uuid, **kwargs):  # noqa: E501
        """DeleteProject  # noqa: E501

        Deletes a Project for a given Project ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_with_http_info(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectDeleteProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `delete_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectDeleteProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project(self, project_id_uuid, **kwargs):  # noqa: E501
        """GetProject  # noqa: E501

        Returns a Project for a given Project ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectGetProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
            return data

    def get_project_with_http_info(self, project_id_uuid, **kwargs):  # noqa: E501
        """GetProject  # noqa: E501

        Returns a Project for a given Project ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_with_http_info(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectGetProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `get_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectGetProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_url(self, project_id_uuid, **kwargs):  # noqa: E501
        """GetProjectURL  # noqa: E501

        Return the URL of a Project for a given Project ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_url(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectGetProjectURLResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_url_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_url_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
            return data

    def get_project_url_with_http_info(self, project_id_uuid, **kwargs):  # noqa: E501
        """GetProjectURL  # noqa: E501

        Return the URL of a Project for a given Project ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_url_with_http_info(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectGetProjectURLResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `get_project_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId.uuid}/url', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectGetProjectURLResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workspace_roles_for_project(self, project_id_uuid, **kwargs):  # noqa: E501
        """GetWorkspaceRoleForProject  # noqa: E501

        Returns the permissions of the Workspace members for a Project given Project ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workspace_roles_for_project(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectGetWorkspaceRolesForProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workspace_roles_for_project_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workspace_roles_for_project_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
            return data

    def get_workspace_roles_for_project_with_http_info(self, project_id_uuid, **kwargs):  # noqa: E501
        """GetWorkspaceRoleForProject  # noqa: E501

        Returns the permissions of the Workspace members for a Project given Project ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workspace_roles_for_project_with_http_info(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectGetWorkspaceRolesForProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workspace_roles_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `get_workspace_roles_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId.uuid}/role/workspace', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectGetWorkspaceRolesForProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_projects(self, **kwargs):  # noqa: E501
        """ListProjects  # noqa: E501

        Returns a paginated list of Projects for a given Workspace ID. Filters out Projects that the user does not have access to. The list is sorted by the last test run time field of each Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_projects(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID.
        :param bool first_page_query_is_published: Optional: If true, return published projects. If false, return unpublished projects. If not specified, return all projects.
        :param datetime first_page_query_creation_time_range_start_time:
        :param datetime first_page_query_creation_time_range_end_time:
        :param datetime first_page_query_last_test_run_time_range_start_time:
        :param datetime first_page_query_last_test_run_time_range_end_time:
        :param list[str] first_page_query_stress_test_categories: Optional: When specified, return all projects whose ST categories are a superset of the ST categories provided here.
        :param list[str] first_page_query_continuous_test_categories: Optional: When specified, return all projects whose CT categories are a superset of the CT categories provided here.
        :param str first_page_query_owner_email: Optional: When specified, return all projects whose owner email matches.
        :param list[str] first_page_query_model_tasks: Optional: When specified, return all projects whose model task is the provided model task.
        :param str first_page_query_status: Optional: When specified, return all projects whose status is the provided status.
        :param str first_page_query_sort_sort_order:
        :param str first_page_query_sort_sort_by:
        :param str first_page_query_search_expression:
        :param list[str] first_page_query_search_search_fields:
        :param str page_token: Specifies a page of the list returned by a ListProjects query. The ListProjects query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageQuery field.
        :param str page_size: The maximum number of Project objects to return in a single page.
        :return: ProjectListProjectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_projects_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_projects_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_projects_with_http_info(self, **kwargs):  # noqa: E501
        """ListProjects  # noqa: E501

        Returns a paginated list of Projects for a given Workspace ID. Filters out Projects that the user does not have access to. The list is sorted by the last test run time field of each Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_projects_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID.
        :param bool first_page_query_is_published: Optional: If true, return published projects. If false, return unpublished projects. If not specified, return all projects.
        :param datetime first_page_query_creation_time_range_start_time:
        :param datetime first_page_query_creation_time_range_end_time:
        :param datetime first_page_query_last_test_run_time_range_start_time:
        :param datetime first_page_query_last_test_run_time_range_end_time:
        :param list[str] first_page_query_stress_test_categories: Optional: When specified, return all projects whose ST categories are a superset of the ST categories provided here.
        :param list[str] first_page_query_continuous_test_categories: Optional: When specified, return all projects whose CT categories are a superset of the CT categories provided here.
        :param str first_page_query_owner_email: Optional: When specified, return all projects whose owner email matches.
        :param list[str] first_page_query_model_tasks: Optional: When specified, return all projects whose model task is the provided model task.
        :param str first_page_query_status: Optional: When specified, return all projects whose status is the provided status.
        :param str first_page_query_sort_sort_order:
        :param str first_page_query_sort_sort_by:
        :param str first_page_query_search_expression:
        :param list[str] first_page_query_search_search_fields:
        :param str page_token: Specifies a page of the list returned by a ListProjects query. The ListProjects query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageQuery field.
        :param str page_size: The maximum number of Project objects to return in a single page.
        :return: ProjectListProjectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id_uuid', 'first_page_query_is_published', 'first_page_query_creation_time_range_start_time', 'first_page_query_creation_time_range_end_time', 'first_page_query_last_test_run_time_range_start_time', 'first_page_query_last_test_run_time_range_end_time', 'first_page_query_stress_test_categories', 'first_page_query_continuous_test_categories', 'first_page_query_owner_email', 'first_page_query_model_tasks', 'first_page_query_status', 'first_page_query_sort_sort_order', 'first_page_query_sort_sort_by', 'first_page_query_search_expression', 'first_page_query_search_search_fields', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_projects" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'workspace_id_uuid' in params:
            query_params.append(('workspaceId.uuid', params['workspace_id_uuid']))  # noqa: E501
        if 'first_page_query_is_published' in params:
            query_params.append(('firstPageQuery.isPublished', params['first_page_query_is_published']))  # noqa: E501
        if 'first_page_query_creation_time_range_start_time' in params:
            query_params.append(('firstPageQuery.creationTimeRange.startTime', params['first_page_query_creation_time_range_start_time']))  # noqa: E501
        if 'first_page_query_creation_time_range_end_time' in params:
            query_params.append(('firstPageQuery.creationTimeRange.endTime', params['first_page_query_creation_time_range_end_time']))  # noqa: E501
        if 'first_page_query_last_test_run_time_range_start_time' in params:
            query_params.append(('firstPageQuery.lastTestRunTimeRange.startTime', params['first_page_query_last_test_run_time_range_start_time']))  # noqa: E501
        if 'first_page_query_last_test_run_time_range_end_time' in params:
            query_params.append(('firstPageQuery.lastTestRunTimeRange.endTime', params['first_page_query_last_test_run_time_range_end_time']))  # noqa: E501
        if 'first_page_query_stress_test_categories' in params:
            query_params.append(('firstPageQuery.stressTestCategories', params['first_page_query_stress_test_categories']))  # noqa: E501
            collection_formats['firstPageQuery.stressTestCategories'] = 'multi'  # noqa: E501
        if 'first_page_query_continuous_test_categories' in params:
            query_params.append(('firstPageQuery.continuousTestCategories', params['first_page_query_continuous_test_categories']))  # noqa: E501
            collection_formats['firstPageQuery.continuousTestCategories'] = 'multi'  # noqa: E501
        if 'first_page_query_owner_email' in params:
            query_params.append(('firstPageQuery.ownerEmail', params['first_page_query_owner_email']))  # noqa: E501
        if 'first_page_query_model_tasks' in params:
            query_params.append(('firstPageQuery.modelTasks', params['first_page_query_model_tasks']))  # noqa: E501
            collection_formats['firstPageQuery.modelTasks'] = 'multi'  # noqa: E501
        if 'first_page_query_status' in params:
            query_params.append(('firstPageQuery.status', params['first_page_query_status']))  # noqa: E501
        if 'first_page_query_sort_sort_order' in params:
            query_params.append(('firstPageQuery.sort.sortOrder', params['first_page_query_sort_sort_order']))  # noqa: E501
        if 'first_page_query_sort_sort_by' in params:
            query_params.append(('firstPageQuery.sort.sortBy', params['first_page_query_sort_sort_by']))  # noqa: E501
        if 'first_page_query_search_expression' in params:
            query_params.append(('firstPageQuery.search.expression', params['first_page_query_search_expression']))  # noqa: E501
        if 'first_page_query_search_search_fields' in params:
            query_params.append(('firstPageQuery.search.searchFields', params['first_page_query_search_search_fields']))  # noqa: E501
            collection_formats['firstPageQuery.search.searchFields'] = 'multi'  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectListProjectsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_users_of_project(self, project_id_uuid, **kwargs):  # noqa: E501
        """ListUsersOfProject  # noqa: E501

        Lists the users and their roles of a Project for a given Project ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_users_of_project(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :param str page_token: Specifies a page of the list returned by a ListUsersOfProject query. The ListUsersOfProject query returns a pageToken when there is more than one page of results.
        :param str page_size: The maximum number of User objects to return in a single page.
        :return: ProjectListUsersOfProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_users_of_project_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_users_of_project_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
            return data

    def list_users_of_project_with_http_info(self, project_id_uuid, **kwargs):  # noqa: E501
        """ListUsersOfProject  # noqa: E501

        Lists the users and their roles of a Project for a given Project ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_users_of_project_with_http_info(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :param str page_token: Specifies a page of the list returned by a ListUsersOfProject query. The ListUsersOfProject query returns a pageToken when there is more than one page of results.
        :param str page_size: The maximum number of User objects to return in a single page.
        :return: ProjectListUsersOfProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id_uuid', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_users_of_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `list_users_of_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId.uuid}/role/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectListUsersOfProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_user_from_project(self, project_id_uuid, user_id_uuid, **kwargs):  # noqa: E501
        """RemoveUserFromProject  # noqa: E501

        Removes all existing permissions of a user from a Project given Project ID and User ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_user_from_project(project_id_uuid, user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :param str user_id_uuid: Unique object ID. (required)
        :return: ProjectRemoveUserFromProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_user_from_project_with_http_info(project_id_uuid, user_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_user_from_project_with_http_info(project_id_uuid, user_id_uuid, **kwargs)  # noqa: E501
            return data

    def remove_user_from_project_with_http_info(self, project_id_uuid, user_id_uuid, **kwargs):  # noqa: E501
        """RemoveUserFromProject  # noqa: E501

        Removes all existing permissions of a user from a Project given Project ID and User ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_user_from_project_with_http_info(project_id_uuid, user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :param str user_id_uuid: Unique object ID. (required)
        :return: ProjectRemoveUserFromProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id_uuid', 'user_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_user_from_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `remove_user_from_project`")  # noqa: E501
        # verify the required parameter 'user_id_uuid' is set
        if ('user_id_uuid' not in params or
                params['user_id_uuid'] is None):
            raise ValueError("Missing the required parameter `user_id_uuid` when calling `remove_user_from_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501
        if 'user_id_uuid' in params:
            path_params['userId.uuid'] = params['user_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId.uuid}/role/users/{userId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectRemoveUserFromProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_project(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """UpdateProject  # noqa: E501

        Updates a Project for a given Project ID. Only updates the fields specified in the FieldMask.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectsProjectIdUuidBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectUpdateProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_project_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_project_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
            return data

    def update_project_with_http_info(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """UpdateProject  # noqa: E501

        Updates a Project for a given Project ID. Only updates the fields specified in the FieldMask.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_with_http_info(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectsProjectIdUuidBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectUpdateProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_project`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `update_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId.uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectUpdateProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_user_of_project(self, body, project_id_uuid, user_user_id_uuid, **kwargs):  # noqa: E501
        """UpdateUserOfProject  # noqa: E501

        Updates the existing permission of a user of a Project given Project ID and User ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_of_project(body, project_id_uuid, user_user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UsersUserUserIdUuidBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :param str user_user_id_uuid: Unique object ID. (required)
        :return: ProjectUpdateUserOfProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_user_of_project_with_http_info(body, project_id_uuid, user_user_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_user_of_project_with_http_info(body, project_id_uuid, user_user_id_uuid, **kwargs)  # noqa: E501
            return data

    def update_user_of_project_with_http_info(self, body, project_id_uuid, user_user_id_uuid, **kwargs):  # noqa: E501
        """UpdateUserOfProject  # noqa: E501

        Updates the existing permission of a user of a Project given Project ID and User ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_of_project_with_http_info(body, project_id_uuid, user_user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UsersUserUserIdUuidBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :param str user_user_id_uuid: Unique object ID. (required)
        :return: ProjectUpdateUserOfProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid', 'user_user_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_of_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_user_of_project`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `update_user_of_project`")  # noqa: E501
        # verify the required parameter 'user_user_id_uuid' is set
        if ('user_user_id_uuid' not in params or
                params['user_user_id_uuid'] is None):
            raise ValueError("Missing the required parameter `user_user_id_uuid` when calling `update_user_of_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501
        if 'user_user_id_uuid' in params:
            path_params['user.userId.uuid'] = params['user_user_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId.uuid}/role/users/{user.userId.uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectUpdateUserOfProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_workspace_roles_for_project(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """UpdateWorkspaceRoleForProject  # noqa: E501

        Assigns users roles(permissions) on a Project based on their roles in the Workspace that contains the Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workspace_roles_for_project(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RoleWorkspaceBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectUpdateWorkspaceRolesForProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_workspace_roles_for_project_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_workspace_roles_for_project_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
            return data

    def update_workspace_roles_for_project_with_http_info(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """UpdateWorkspaceRoleForProject  # noqa: E501

        Assigns users roles(permissions) on a Project based on their roles in the Workspace that contains the Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workspace_roles_for_project_with_http_info(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RoleWorkspaceBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :return: ProjectUpdateWorkspaceRolesForProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_workspace_roles_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_workspace_roles_for_project`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `update_workspace_roles_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId.uuid}/role/workspace', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectUpdateWorkspaceRolesForProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
