# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class RegistryServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_dataset(self, dataset_id, **kwargs):  # noqa: E501
        """DeleteDataset  # noqa: E501

        Delete a Dataset from the Registry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset(dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeDeleteDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dataset_with_http_info(dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dataset_with_http_info(dataset_id, **kwargs)  # noqa: E501
            return data

    def delete_dataset_with_http_info(self, dataset_id, **kwargs):  # noqa: E501
        """DeleteDataset  # noqa: E501

        Delete a Dataset from the Registry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset_with_http_info(dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeDeleteDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `delete_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/dataset/{datasetId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteDatasetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_model(self, model_id_uuid, **kwargs):  # noqa: E501
        """DeleteModel  # noqa: E501

        Delete a Model from the Registry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model(model_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: Unique object ID. (required)
        :return: RimeDeleteModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_model_with_http_info(model_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_model_with_http_info(model_id_uuid, **kwargs)  # noqa: E501
            return data

    def delete_model_with_http_info(self, model_id_uuid, **kwargs):  # noqa: E501
        """DeleteModel  # noqa: E501

        Delete a Model from the Registry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model_with_http_info(model_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: Unique object ID. (required)
        :return: RimeDeleteModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id_uuid' is set
        if ('model_id_uuid' not in params or
                params['model_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_id_uuid` when calling `delete_model`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id_uuid' in params:
            path_params['modelId.uuid'] = params['model_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/model/{modelId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_prediction_set(self, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """DeletePredictionSet  # noqa: E501

        Delete the Prediction set corresponding to a specified Model and Dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_prediction_set(model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: Unique object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeDeletePredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_prediction_set_with_http_info(model_id_uuid, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_prediction_set_with_http_info(model_id_uuid, dataset_id, **kwargs)  # noqa: E501
            return data

    def delete_prediction_set_with_http_info(self, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """DeletePredictionSet  # noqa: E501

        Delete the Prediction set corresponding to a specified Model and Dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_prediction_set_with_http_info(model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: Unique object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeDeletePredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id_uuid', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_prediction_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id_uuid' is set
        if ('model_id_uuid' not in params or
                params['model_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_id_uuid` when calling `delete_prediction_set`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `delete_prediction_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id_uuid' in params:
            path_params['modelId.uuid'] = params['model_id_uuid']  # noqa: E501
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/prediction/{modelId.uuid}/{datasetId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeletePredictionSetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dataset(self, **kwargs):  # noqa: E501
        """GetDataset  # noqa: E501

        Returns information about a registered Dataset. Allows for searching by ID or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_id: Uniquely specifies a Dataset.
        :param str dataset_name: Unique name of a Dataset.
        :return: RimeGetDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dataset_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_dataset_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_dataset_with_http_info(self, **kwargs):  # noqa: E501
        """GetDataset  # noqa: E501

        Returns information about a registered Dataset. Allows for searching by ID or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_id: Uniquely specifies a Dataset.
        :param str dataset_name: Unique name of a Dataset.
        :return: RimeGetDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'dataset_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataset" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dataset_id' in params:
            query_params.append(('datasetId', params['dataset_id']))  # noqa: E501
        if 'dataset_name' in params:
            query_params.append(('datasetName', params['dataset_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/dataset', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetDatasetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_model(self, **kwargs):  # noqa: E501
        """GetModel  # noqa: E501

        Returns information about a registered Model. Allows for searching by ID or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: Unique object ID.
        :param str model_name: Unique name of a Model.
        :return: RimeGetModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_model_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_model_with_http_info(self, **kwargs):  # noqa: E501
        """GetModel  # noqa: E501

        Returns information about a registered Model. Allows for searching by ID or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: Unique object ID.
        :param str model_name: Unique name of a Model.
        :return: RimeGetModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id_uuid', 'model_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'model_id_uuid' in params:
            query_params.append(('modelId.uuid', params['model_id_uuid']))  # noqa: E501
        if 'model_name' in params:
            query_params.append(('modelName', params['model_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/model', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_prediction_set(self, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """GetPredictionSet  # noqa: E501

        Returns information about a registered Prediction set.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_prediction_set(model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: Unique object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeGetPredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_prediction_set_with_http_info(model_id_uuid, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_prediction_set_with_http_info(model_id_uuid, dataset_id, **kwargs)  # noqa: E501
            return data

    def get_prediction_set_with_http_info(self, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """GetPredictionSet  # noqa: E501

        Returns information about a registered Prediction set.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_prediction_set_with_http_info(model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: Unique object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeGetPredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id_uuid', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_prediction_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id_uuid' is set
        if ('model_id_uuid' not in params or
                params['model_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_id_uuid` when calling `get_prediction_set`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `get_prediction_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id_uuid' in params:
            path_params['modelId.uuid'] = params['model_id_uuid']  # noqa: E501
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/prediction/{modelId.uuid}/{datasetId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetPredictionSetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_datasets(self, project_id_uuid, **kwargs):  # noqa: E501
        """ListDatasets  # noqa: E501

        List all Datasets in the Registry with optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_datasets(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :param datetime first_page_req_scheduled_ct_intervals_start_time:
        :param datetime first_page_req_scheduled_ct_intervals_end_time:
        :param str page_token: Specifies a page of the list returned by a ListDatasets query. The ListDatasets query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Dataset objects to return in a single page.
        :return: RimeListDatasetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_datasets_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_datasets_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
            return data

    def list_datasets_with_http_info(self, project_id_uuid, **kwargs):  # noqa: E501
        """ListDatasets  # noqa: E501

        List all Datasets in the Registry with optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_datasets_with_http_info(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :param datetime first_page_req_scheduled_ct_intervals_start_time:
        :param datetime first_page_req_scheduled_ct_intervals_end_time:
        :param str page_token: Specifies a page of the list returned by a ListDatasets query. The ListDatasets query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Dataset objects to return in a single page.
        :return: RimeListDatasetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id_uuid', 'first_page_req_scheduled_ct_intervals_start_time', 'first_page_req_scheduled_ct_intervals_end_time', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_datasets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `list_datasets`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []
        if 'first_page_req_scheduled_ct_intervals_start_time' in params:
            query_params.append(('firstPageReq.scheduledCtIntervals.startTime', params['first_page_req_scheduled_ct_intervals_start_time']))  # noqa: E501
        if 'first_page_req_scheduled_ct_intervals_end_time' in params:
            query_params.append(('firstPageReq.scheduledCtIntervals.endTime', params['first_page_req_scheduled_ct_intervals_end_time']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/{projectId.uuid}/dataset', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListDatasetsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_models(self, project_id_uuid, **kwargs):  # noqa: E501
        """ListModels  # noqa: E501

        List all Models in the Registry of the specified Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_models(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :param str page_token: Specifies a page of the list returned by a ListModels query. The ListModels query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Model objects to return in a single page.
        :return: RimeListModelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_models_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_models_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
            return data

    def list_models_with_http_info(self, project_id_uuid, **kwargs):  # noqa: E501
        """ListModels  # noqa: E501

        List all Models in the Registry of the specified Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_models_with_http_info(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :param str page_token: Specifies a page of the list returned by a ListModels query. The ListModels query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Model objects to return in a single page.
        :return: RimeListModelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id_uuid', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_models" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `list_models`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/{projectId.uuid}/model', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListModelsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_prediction_sets(self, project_id_uuid, **kwargs):  # noqa: E501
        """ListPredictionSets  # noqa: E501

        List all Prediction sets in the Registry with optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_prediction_sets(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :param str first_page_req_model_id: Uniquely specifies a Model.
        :param str first_page_req_dataset_id: Uniquely specifies a Dataset.
        :param str page_token: Specifies a page of the list returned by a ListPredictions query. The ListPredictions query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Prediction objects to return in a single page.
        :return: RimeListPredictionSetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_prediction_sets_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_prediction_sets_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
            return data

    def list_prediction_sets_with_http_info(self, project_id_uuid, **kwargs):  # noqa: E501
        """ListPredictionSets  # noqa: E501

        List all Prediction sets in the Registry with optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_prediction_sets_with_http_info(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: Unique object ID. (required)
        :param str first_page_req_model_id: Uniquely specifies a Model.
        :param str first_page_req_dataset_id: Uniquely specifies a Dataset.
        :param str page_token: Specifies a page of the list returned by a ListPredictions query. The ListPredictions query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Prediction objects to return in a single page.
        :return: RimeListPredictionSetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id_uuid', 'first_page_req_model_id', 'first_page_req_dataset_id', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_prediction_sets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `list_prediction_sets`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []
        if 'first_page_req_model_id' in params:
            query_params.append(('firstPageReq.modelId', params['first_page_req_model_id']))  # noqa: E501
        if 'first_page_req_dataset_id' in params:
            query_params.append(('firstPageReq.datasetId', params['first_page_req_dataset_id']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/{projectId.uuid}/prediction', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListPredictionSetsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_dataset(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """RegisterDataset  # noqa: E501

        Register a new Dataset for the specified Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_dataset(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectIdUuidDatasetBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :return: RimeRegisterDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_dataset_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.register_dataset_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
            return data

    def register_dataset_with_http_info(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """RegisterDataset  # noqa: E501

        Register a new Dataset for the specified Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_dataset_with_http_info(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectIdUuidDatasetBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :return: RimeRegisterDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `register_dataset`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `register_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/{projectId.uuid}/dataset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRegisterDatasetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_model(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """RegisterModel  # noqa: E501

        Register a new Model for the specified Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_model(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectIdUuidModelBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :return: RimeRegisterModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_model_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.register_model_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
            return data

    def register_model_with_http_info(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """RegisterModel  # noqa: E501

        Register a new Model for the specified Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_model_with_http_info(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectIdUuidModelBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :return: RimeRegisterModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `register_model`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `register_model`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/{projectId.uuid}/model', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRegisterModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_prediction_set(self, body, project_id_uuid, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """RegisterPredictionSet  # noqa: E501

        Register a Prediction set corresponding to a specified Model and Dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_prediction_set(body, project_id_uuid, model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatasetIdPredictionBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :param str model_id_uuid: Unique object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeRegisterPredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_prediction_set_with_http_info(body, project_id_uuid, model_id_uuid, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.register_prediction_set_with_http_info(body, project_id_uuid, model_id_uuid, dataset_id, **kwargs)  # noqa: E501
            return data

    def register_prediction_set_with_http_info(self, body, project_id_uuid, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """RegisterPredictionSet  # noqa: E501

        Register a Prediction set corresponding to a specified Model and Dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_prediction_set_with_http_info(body, project_id_uuid, model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatasetIdPredictionBody body: (required)
        :param str project_id_uuid: Unique object ID. (required)
        :param str model_id_uuid: Unique object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeRegisterPredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid', 'model_id_uuid', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_prediction_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `register_prediction_set`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `register_prediction_set`")  # noqa: E501
        # verify the required parameter 'model_id_uuid' is set
        if ('model_id_uuid' not in params or
                params['model_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_id_uuid` when calling `register_prediction_set`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `register_prediction_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501
        if 'model_id_uuid' in params:
            path_params['modelId.uuid'] = params['model_id_uuid']  # noqa: E501
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/{projectId.uuid}/model/{modelId.uuid}/dataset/{datasetId}/prediction', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRegisterPredictionSetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
