# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class ResultsReaderApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_test_run(self, test_run_id, **kwargs):  # noqa: E501
        """DeleteTestRun  # noqa: E501

        Deletes a specified test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_test_run(test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Uniquely specifies a Test Run to delete. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_test_run_with_http_info(test_run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_test_run_with_http_info(test_run_id, **kwargs)  # noqa: E501
            return data

    def delete_test_run_with_http_info(self, test_run_id, **kwargs):  # noqa: E501
        """DeleteTestRun  # noqa: E501

        Deletes a specified test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_test_run_with_http_info(test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Uniquely specifies a Test Run to delete. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_test_run" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'test_run_id' is set
        if ('test_run_id' not in params or
                params['test_run_id'] is None):
            raise ValueError("Missing the required parameter `test_run_id` when calling `delete_test_run`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_run_id' in params:
            path_params['testRunId'] = params['test_run_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-runs/{testRunId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_batch_result(self, test_run_id, test_type, **kwargs):  # noqa: E501
        """GetBatchResult  # noqa: E501

        Gets the batch result for a given Test Run ID and a test type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_batch_result(test_run_id, test_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Uniquely specifies a Test Run. (required)
        :param str test_type: The type of test, such as \"Subset Accuracy\" or \"Overall Metrics\". (required)
        :param bool show_display: A Boolean flag that toggles whether to return display HTML. info with message.
        :return: TestrunresultGetBatchResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_batch_result_with_http_info(test_run_id, test_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_batch_result_with_http_info(test_run_id, test_type, **kwargs)  # noqa: E501
            return data

    def get_batch_result_with_http_info(self, test_run_id, test_type, **kwargs):  # noqa: E501
        """GetBatchResult  # noqa: E501

        Gets the batch result for a given Test Run ID and a test type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_batch_result_with_http_info(test_run_id, test_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Uniquely specifies a Test Run. (required)
        :param str test_type: The type of test, such as \"Subset Accuracy\" or \"Overall Metrics\". (required)
        :param bool show_display: A Boolean flag that toggles whether to return display HTML. info with message.
        :return: TestrunresultGetBatchResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id', 'test_type', 'show_display']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_batch_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'test_run_id' is set
        if ('test_run_id' not in params or
                params['test_run_id'] is None):
            raise ValueError("Missing the required parameter `test_run_id` when calling `get_batch_result`")  # noqa: E501
        # verify the required parameter 'test_type' is set
        if ('test_type' not in params or
                params['test_type'] is None):
            raise ValueError("Missing the required parameter `test_type` when calling `get_batch_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_run_id' in params:
            path_params['testRunId'] = params['test_run_id']  # noqa: E501
        if 'test_type' in params:
            path_params['testType'] = params['test_type']  # noqa: E501

        query_params = []
        if 'show_display' in params:
            query_params.append(('showDisplay', params['show_display']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-runs/{testRunId}/batch-result/{testType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultGetBatchResultResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_category_results(self, test_run_id, **kwargs):  # noqa: E501
        """GetCategoryResults  # noqa: E501

        Returns all category results of a test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_category_results(test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: The ID of the test run associated with summary tests. Specify exactly one of the page_token field or this field. (required)
        :return: TestrunresultGetCategoryResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_category_results_with_http_info(test_run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_category_results_with_http_info(test_run_id, **kwargs)  # noqa: E501
            return data

    def get_category_results_with_http_info(self, test_run_id, **kwargs):  # noqa: E501
        """GetCategoryResults  # noqa: E501

        Returns all category results of a test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_category_results_with_http_info(test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: The ID of the test run associated with summary tests. Specify exactly one of the page_token field or this field. (required)
        :return: TestrunresultGetCategoryResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_category_results" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'test_run_id' is set
        if ('test_run_id' not in params or
                params['test_run_id'] is None):
            raise ValueError("Missing the required parameter `test_run_id` when calling `get_category_results`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_run_id' in params:
            path_params['testRunId'] = params['test_run_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/category-results/{testRunId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultGetCategoryResultsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_feature_result(self, test_run_id, url_safe_feature_id, **kwargs):  # noqa: E501
        """GetFeatureResult  # noqa: E501

        Returns the feature result that matches the specified test run ID and feature ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_feature_result(test_run_id, url_safe_feature_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Uniquely specifies a Test Run. (required)
        :param str url_safe_feature_id: Uniquely specifies a Feature. (required)
        :param bool show_display: A Boolean flag that specifies whether to return display HTML information.
        :return: TestrunresultGetFeatureResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_feature_result_with_http_info(test_run_id, url_safe_feature_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_feature_result_with_http_info(test_run_id, url_safe_feature_id, **kwargs)  # noqa: E501
            return data

    def get_feature_result_with_http_info(self, test_run_id, url_safe_feature_id, **kwargs):  # noqa: E501
        """GetFeatureResult  # noqa: E501

        Returns the feature result that matches the specified test run ID and feature ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_feature_result_with_http_info(test_run_id, url_safe_feature_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Uniquely specifies a Test Run. (required)
        :param str url_safe_feature_id: Uniquely specifies a Feature. (required)
        :param bool show_display: A Boolean flag that specifies whether to return display HTML information.
        :return: TestrunresultGetFeatureResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id', 'url_safe_feature_id', 'show_display']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_feature_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'test_run_id' is set
        if ('test_run_id' not in params or
                params['test_run_id'] is None):
            raise ValueError("Missing the required parameter `test_run_id` when calling `get_feature_result`")  # noqa: E501
        # verify the required parameter 'url_safe_feature_id' is set
        if ('url_safe_feature_id' not in params or
                params['url_safe_feature_id'] is None):
            raise ValueError("Missing the required parameter `url_safe_feature_id` when calling `get_feature_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_run_id' in params:
            path_params['testRunId'] = params['test_run_id']  # noqa: E501
        if 'url_safe_feature_id' in params:
            path_params['urlSafeFeatureId'] = params['url_safe_feature_id']  # noqa: E501

        query_params = []
        if 'show_display' in params:
            query_params.append(('showDisplay', params['show_display']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-runs/{testRunId}/feature-result/{urlSafeFeatureId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultGetFeatureResultResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_config(self, test_run_id, config_name, **kwargs):  # noqa: E501
        """GetTestConfig  # noqa: E501

        Returns the test configuration of the specified test run as bytes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_config(test_run_id, config_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Uniquely specifies a Test Run. (required)
        :param str config_name: The name of the test config requested. (required)
        :return: TestrunresultGetTestConfigResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_test_config_with_http_info(test_run_id, config_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_test_config_with_http_info(test_run_id, config_name, **kwargs)  # noqa: E501
            return data

    def get_test_config_with_http_info(self, test_run_id, config_name, **kwargs):  # noqa: E501
        """GetTestConfig  # noqa: E501

        Returns the test configuration of the specified test run as bytes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_config_with_http_info(test_run_id, config_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Uniquely specifies a Test Run. (required)
        :param str config_name: The name of the test config requested. (required)
        :return: TestrunresultGetTestConfigResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id', 'config_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'test_run_id' is set
        if ('test_run_id' not in params or
                params['test_run_id'] is None):
            raise ValueError("Missing the required parameter `test_run_id` when calling `get_test_config`")  # noqa: E501
        # verify the required parameter 'config_name' is set
        if ('config_name' not in params or
                params['config_name'] is None):
            raise ValueError("Missing the required parameter `config_name` when calling `get_test_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_run_id' in params:
            path_params['testRunId'] = params['test_run_id']  # noqa: E501
        if 'config_name' in params:
            path_params['configName'] = params['config_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/test-runs/{testRunId}/test-config/{configName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultGetTestConfigResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_run(self, test_run_id, **kwargs):  # noqa: E501
        """GetTestRun  # noqa: E501

        Returns the test run result detail for a given Test Run ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_run(test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Uniquely specifies a test run. (required)
        :return: TestrunresultGetTestRunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_test_run_with_http_info(test_run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_test_run_with_http_info(test_run_id, **kwargs)  # noqa: E501
            return data

    def get_test_run_with_http_info(self, test_run_id, **kwargs):  # noqa: E501
        """GetTestRun  # noqa: E501

        Returns the test run result detail for a given Test Run ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_run_with_http_info(test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Uniquely specifies a test run. (required)
        :return: TestrunresultGetTestRunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_run" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'test_run_id' is set
        if ('test_run_id' not in params or
                params['test_run_id'] is None):
            raise ValueError("Missing the required parameter `test_run_id` when calling `get_test_run`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_run_id' in params:
            path_params['testRunId'] = params['test_run_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-runs/{testRunId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultGetTestRunResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_feature_results(self, **kwargs):  # noqa: E501
        """ListFeatureResults  # noqa: E501

        List all feature results from a test run.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_feature_results(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: The ID of the Test Run associated with feature results. Specify exactly one of the page_token field or this field.
        :param str page_token: A token representing one page from the list returned by a ListFeatureResults query. The ListFeatureResults query returns a page_token when there is more than one page of results. Specify exactly one of the testRunId field or this field.
        :param str page_size: The maximum number of Feature Result objects to return in a single page.
        :param bool show_display: A Boolean that specifies whether to return display HTML information.
        :return: TestrunresultListFeatureResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_feature_results_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_feature_results_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_feature_results_with_http_info(self, **kwargs):  # noqa: E501
        """ListFeatureResults  # noqa: E501

        List all feature results from a test run.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_feature_results_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: The ID of the Test Run associated with feature results. Specify exactly one of the page_token field or this field.
        :param str page_token: A token representing one page from the list returned by a ListFeatureResults query. The ListFeatureResults query returns a page_token when there is more than one page of results. Specify exactly one of the testRunId field or this field.
        :param str page_size: The maximum number of Feature Result objects to return in a single page.
        :param bool show_display: A Boolean that specifies whether to return display HTML information.
        :return: TestrunresultListFeatureResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id', 'page_token', 'page_size', 'show_display']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_feature_results" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'test_run_id' in params:
            query_params.append(('testRunId', params['test_run_id']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'show_display' in params:
            query_params.append(('showDisplay', params['show_display']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/feature-results', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultListFeatureResultsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_monitor_categories(self, **kwargs):  # noqa: E501
        """ListMonitorCategories  # noqa: E501

        Returns test categories belongs to monitor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_monitor_categories(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TestrunresultListMonitorCategoriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_monitor_categories_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_monitor_categories_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_monitor_categories_with_http_info(self, **kwargs):  # noqa: E501
        """ListMonitorCategories  # noqa: E501

        Returns test categories belongs to monitor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_monitor_categories_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TestrunresultListMonitorCategoriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_monitor_categories" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/test-runs/test-category/monitor', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultListMonitorCategoriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_summary_tests(self, **kwargs):  # noqa: E501
        """ListSummaryTests  # noqa: E501

        Returns a paginated list of the summary tests of a test run. DEPRECATED: Use GetCategoryResults instead, the API request and response are the same. This method will be removed in the future.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_summary_tests(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query_test_run_id: The ID of the test run associated with summary tests. Specify exactly one of the page_token field or this field.
        :param str page_token: A token representing one page from the list returned by a ListSummaryTests query. The ListSummaryTests query returns a page_token when there is more than one page of results. Specify exactly one of the query.testRunId field or this field.
        :param str page_size: The maximum number of Summary Test objects to return in a single page.
        :return: TestrunresultListSummaryTestsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_summary_tests_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_summary_tests_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_summary_tests_with_http_info(self, **kwargs):  # noqa: E501
        """ListSummaryTests  # noqa: E501

        Returns a paginated list of the summary tests of a test run. DEPRECATED: Use GetCategoryResults instead, the API request and response are the same. This method will be removed in the future.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_summary_tests_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query_test_run_id: The ID of the test run associated with summary tests. Specify exactly one of the page_token field or this field.
        :param str page_token: A token representing one page from the list returned by a ListSummaryTests query. The ListSummaryTests query returns a page_token when there is more than one page of results. Specify exactly one of the query.testRunId field or this field.
        :param str page_size: The maximum number of Summary Test objects to return in a single page.
        :return: TestrunresultListSummaryTestsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_test_run_id', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_summary_tests" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'query_test_run_id' in params:
            query_params.append(('query.testRunId', params['query_test_run_id']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/summary-tests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultListSummaryTestsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_test_cases(self, **kwargs):  # noqa: E501
        """ListTestCases  # noqa: E501

        Returns a paginated list of the test cases in a test run. Specify a set of test types to filter the list by test types.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_test_cases(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_test_cases_query_test_run_id: Uniquely specifies a Test Run associated with test cases. Specify exactly one of the page_token field or this field.
        :param list[str] list_test_cases_query_test_types: Optional filter for test types.
        :param list[str] list_test_cases_query_url_safe_feature_ids: Optional filter for features.
        :param str page_token: A token representing one page from the list returned by a ListTestCases query. The ListTestCases query returns a page_token when there is more than one page of results. Specify exactly one of the ListTestCasesQuery.testRunId field or this field.
        :param str page_size: The maximum number of Test Case objects to return in a single page.
        :param bool show_display: A Boolean flag that specifies whether to return display HTML information with the message.
        :return: TestrunresultListTestCasesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_test_cases_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_test_cases_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_test_cases_with_http_info(self, **kwargs):  # noqa: E501
        """ListTestCases  # noqa: E501

        Returns a paginated list of the test cases in a test run. Specify a set of test types to filter the list by test types.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_test_cases_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_test_cases_query_test_run_id: Uniquely specifies a Test Run associated with test cases. Specify exactly one of the page_token field or this field.
        :param list[str] list_test_cases_query_test_types: Optional filter for test types.
        :param list[str] list_test_cases_query_url_safe_feature_ids: Optional filter for features.
        :param str page_token: A token representing one page from the list returned by a ListTestCases query. The ListTestCases query returns a page_token when there is more than one page of results. Specify exactly one of the ListTestCasesQuery.testRunId field or this field.
        :param str page_size: The maximum number of Test Case objects to return in a single page.
        :param bool show_display: A Boolean flag that specifies whether to return display HTML information with the message.
        :return: TestrunresultListTestCasesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_test_cases_query_test_run_id', 'list_test_cases_query_test_types', 'list_test_cases_query_url_safe_feature_ids', 'page_token', 'page_size', 'show_display']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_test_cases" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'list_test_cases_query_test_run_id' in params:
            query_params.append(('listTestCasesQuery.testRunId', params['list_test_cases_query_test_run_id']))  # noqa: E501
        if 'list_test_cases_query_test_types' in params:
            query_params.append(('listTestCasesQuery.testTypes', params['list_test_cases_query_test_types']))  # noqa: E501
            collection_formats['listTestCasesQuery.testTypes'] = 'multi'  # noqa: E501
        if 'list_test_cases_query_url_safe_feature_ids' in params:
            query_params.append(('listTestCasesQuery.urlSafeFeatureIds', params['list_test_cases_query_url_safe_feature_ids']))  # noqa: E501
            collection_formats['listTestCasesQuery.urlSafeFeatureIds'] = 'multi'  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'show_display' in params:
            query_params.append(('showDisplay', params['show_display']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-cases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultListTestCasesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_test_runs(self, **kwargs):  # noqa: E501
        """ListTestRuns  # noqa: E501

        Lists all test runs belonging to a project.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_test_runs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: The field is deprecated in v2.2. Use first_page_query.project_id instead. The field will be removed after v2.3. The ID of the project containing the requested test runs. Specify exactly one of the page_token field or this field.
        :param str page_token: A token representing one page from the list returned by a ListTestRuns query. The ListTestRuns query returns a page_token when there is more than one page of results. Specify exactly one of the projectId field or this field.
        :param str first_page_query_project_id_uuid: Unique object ID.
        :param str first_page_query_testing_type: The test type of Test Runs to request. Defaults to Stress Testing.   - TEST_TYPE_STRESS_TESTING_UNSPECIFIED: Default type as stress testing
        :param str first_page_query_schedule_id_uuid: Unique object ID.
        :param str page_size: The maximum number of Test Run objects to return in a single page.
        :return: TestrunresultListTestRunsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_test_runs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_test_runs_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_test_runs_with_http_info(self, **kwargs):  # noqa: E501
        """ListTestRuns  # noqa: E501

        Lists all test runs belonging to a project.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_test_runs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: The field is deprecated in v2.2. Use first_page_query.project_id instead. The field will be removed after v2.3. The ID of the project containing the requested test runs. Specify exactly one of the page_token field or this field.
        :param str page_token: A token representing one page from the list returned by a ListTestRuns query. The ListTestRuns query returns a page_token when there is more than one page of results. Specify exactly one of the projectId field or this field.
        :param str first_page_query_project_id_uuid: Unique object ID.
        :param str first_page_query_testing_type: The test type of Test Runs to request. Defaults to Stress Testing.   - TEST_TYPE_STRESS_TESTING_UNSPECIFIED: Default type as stress testing
        :param str first_page_query_schedule_id_uuid: Unique object ID.
        :param str page_size: The maximum number of Test Run objects to return in a single page.
        :return: TestrunresultListTestRunsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'page_token', 'first_page_query_project_id_uuid', 'first_page_query_testing_type', 'first_page_query_schedule_id_uuid', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_test_runs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'project_id' in params:
            query_params.append(('projectId', params['project_id']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'first_page_query_project_id_uuid' in params:
            query_params.append(('firstPageQuery.projectId.uuid', params['first_page_query_project_id_uuid']))  # noqa: E501
        if 'first_page_query_testing_type' in params:
            query_params.append(('firstPageQuery.testingType', params['first_page_query_testing_type']))  # noqa: E501
        if 'first_page_query_schedule_id_uuid' in params:
            query_params.append(('firstPageQuery.scheduleId.uuid', params['first_page_query_schedule_id_uuid']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-runs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultListTestRunsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_validation_categories(self, **kwargs):  # noqa: E501
        """ListValidationCategories  # noqa: E501

        Returns test categories belongs to validation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_validation_categories(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TestrunresultListValidationCategoriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_validation_categories_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_validation_categories_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_validation_categories_with_http_info(self, **kwargs):  # noqa: E501
        """ListValidationCategories  # noqa: E501

        Returns test categories belongs to validation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_validation_categories_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TestrunresultListValidationCategoriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_validation_categories" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/test-runs/test-category/validation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultListValidationCategoriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rename_test_run(self, body, test_run_id, **kwargs):  # noqa: E501
        """RenameTestRun  # noqa: E501

        Updates the name of a test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_test_run(body, test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RenameTestRunIdBody body: (required)
        :param str test_run_id: Uniquely specifies a Test Run to rename. (required)
        :return: TestrunresultRenameTestRunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.rename_test_run_with_http_info(body, test_run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.rename_test_run_with_http_info(body, test_run_id, **kwargs)  # noqa: E501
            return data

    def rename_test_run_with_http_info(self, body, test_run_id, **kwargs):  # noqa: E501
        """RenameTestRun  # noqa: E501

        Updates the name of a test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_test_run_with_http_info(body, test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RenameTestRunIdBody body: (required)
        :param str test_run_id: Uniquely specifies a Test Run to rename. (required)
        :return: TestrunresultRenameTestRunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'test_run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rename_test_run" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `rename_test_run`")  # noqa: E501
        # verify the required parameter 'test_run_id' is set
        if ('test_run_id' not in params or
                params['test_run_id'] is None):
            raise ValueError("Missing the required parameter `test_run_id` when calling `rename_test_run`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_run_id' in params:
            path_params['testRunId'] = params['test_run_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-runs/rename/{testRunId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultRenameTestRunResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def results_reader_list_batch_results(self, **kwargs):  # noqa: E501
        """ListBatchResults  # noqa: E501

        Returns a paginated list of batch results from a test run.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_list_batch_results(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: The ID of the Test Run associated with batch results. Specify exactly one of the pageToken field or this field.
        :param str page_token: A token representing one page from the list returned by a ListBatchResults query. The ListBatchResults query returns a page_token when there is more than one page of results. Specify exactly one of the testRunId field or this field.
        :param str page_size: The maximum number of Batch Result objects to return in a single page.
        :param bool show_display: A Boolean that toggles whether to return display html info.
        :return: TestrunresultListBatchResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.results_reader_list_batch_results_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.results_reader_list_batch_results_with_http_info(**kwargs)  # noqa: E501
            return data

    def results_reader_list_batch_results_with_http_info(self, **kwargs):  # noqa: E501
        """ListBatchResults  # noqa: E501

        Returns a paginated list of batch results from a test run.  #### Python pagination example:  ```python all_objects = [] # Required for authentication to all methods in the API. headers = {\"rime-api-key\": \"INSERT_API_TOKEN\"} # TODO page_token = \"\" # Initialize query parameters in a dictionary params = {\"INSERT_QUERY_PARAMETER\": \"INSERT_QUERY_VALUE\"} # TODO # Make requests until all results have been returned. while True:     # If the page_token from a previous response is not empty, we need to specify this     # token as a parameter to the next request in order to return the next page.     if page_token != \"\":         params = {\"page_token\": page_token}     res = requests.get(\"INSERT_METHOD_URI\", params=params, headers=headers) # TODO     if res.status_code != 200 :         raise ValueError(res)     res_json = res.json()     all_objects.extend(res_json['INSERT_OBJECT_KEY']) # TODO     page_token = res_json['nextPageToken']     # If all results have been returned, res_json['hasMore'] is false.     if not res_json[\"hasMore\"]:         break ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_list_batch_results_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: The ID of the Test Run associated with batch results. Specify exactly one of the pageToken field or this field.
        :param str page_token: A token representing one page from the list returned by a ListBatchResults query. The ListBatchResults query returns a page_token when there is more than one page of results. Specify exactly one of the testRunId field or this field.
        :param str page_size: The maximum number of Batch Result objects to return in a single page.
        :param bool show_display: A Boolean that toggles whether to return display html info.
        :return: TestrunresultListBatchResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id', 'page_token', 'page_size', 'show_display']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method results_reader_list_batch_results" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'test_run_id' in params:
            query_params.append(('testRunId', params['test_run_id']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'show_display' in params:
            query_params.append(('showDisplay', params['show_display']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/batch-results', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultListBatchResultsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
