# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class ScheduleServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_schedule(self, body, **kwargs):  # noqa: E501
        """CreateSchedule creates a schedule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_schedule(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateScheduleRequest body: (required)
        :return: RimeCreateScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_schedule_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_schedule_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_schedule_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateSchedule creates a schedule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_schedule_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateScheduleRequest body: (required)
        :return: RimeCreateScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/schedules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateScheduleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_schedule(self, schedule_id_uuid, **kwargs):  # noqa: E501
        """DeleteSchedule deletes a schedule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_schedule(schedule_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str schedule_id_uuid: Unique object ID. (required)
        :return: RimeDeleteScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_schedule_with_http_info(schedule_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_schedule_with_http_info(schedule_id_uuid, **kwargs)  # noqa: E501
            return data

    def delete_schedule_with_http_info(self, schedule_id_uuid, **kwargs):  # noqa: E501
        """DeleteSchedule deletes a schedule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_schedule_with_http_info(schedule_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str schedule_id_uuid: Unique object ID. (required)
        :return: RimeDeleteScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'schedule_id_uuid' is set
        if ('schedule_id_uuid' not in params or
                params['schedule_id_uuid'] is None):
            raise ValueError("Missing the required parameter `schedule_id_uuid` when calling `delete_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'schedule_id_uuid' in params:
            path_params['scheduleId.uuid'] = params['schedule_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/schedules/{scheduleId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteScheduleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_schedule(self, schedule_id_uuid, **kwargs):  # noqa: E501
        """GetSchedule gets a schedule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_schedule(schedule_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str schedule_id_uuid: Unique object ID. (required)
        :return: RimeGetScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_schedule_with_http_info(schedule_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_schedule_with_http_info(schedule_id_uuid, **kwargs)  # noqa: E501
            return data

    def get_schedule_with_http_info(self, schedule_id_uuid, **kwargs):  # noqa: E501
        """GetSchedule gets a schedule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_schedule_with_http_info(schedule_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str schedule_id_uuid: Unique object ID. (required)
        :return: RimeGetScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'schedule_id_uuid' is set
        if ('schedule_id_uuid' not in params or
                params['schedule_id_uuid'] is None):
            raise ValueError("Missing the required parameter `schedule_id_uuid` when calling `get_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'schedule_id_uuid' in params:
            path_params['scheduleId.uuid'] = params['schedule_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/schedules/{scheduleId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetScheduleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_schedule(self, body, mask, schedule_schedule_id_uuid, **kwargs):  # noqa: E501
        """UpdateSchedule updates a schedule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_schedule(body, mask, schedule_schedule_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SchedulesScheduleScheduleIdUuidBody body: (required)
        :param str mask: Update mask specifies the fields in the config that will be updated. Any values not in the mask will be ignored. Currently only updated the frequency of the schedule is supported. (required)
        :param str schedule_schedule_id_uuid: Unique object ID. (required)
        :return: RimeUpdateScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_schedule_with_http_info(body, mask, schedule_schedule_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_schedule_with_http_info(body, mask, schedule_schedule_id_uuid, **kwargs)  # noqa: E501
            return data

    def update_schedule_with_http_info(self, body, mask, schedule_schedule_id_uuid, **kwargs):  # noqa: E501
        """UpdateSchedule updates a schedule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_schedule_with_http_info(body, mask, schedule_schedule_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SchedulesScheduleScheduleIdUuidBody body: (required)
        :param str mask: Update mask specifies the fields in the config that will be updated. Any values not in the mask will be ignored. Currently only updated the frequency of the schedule is supported. (required)
        :param str schedule_schedule_id_uuid: Unique object ID. (required)
        :return: RimeUpdateScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'mask', 'schedule_schedule_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_schedule`")  # noqa: E501
        # verify the required parameter 'mask' is set
        if ('mask' not in params or
                params['mask'] is None):
            raise ValueError("Missing the required parameter `mask` when calling `update_schedule`")  # noqa: E501
        # verify the required parameter 'schedule_schedule_id_uuid' is set
        if ('schedule_schedule_id_uuid' not in params or
                params['schedule_schedule_id_uuid'] is None):
            raise ValueError("Missing the required parameter `schedule_schedule_id_uuid` when calling `update_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'schedule_schedule_id_uuid' in params:
            path_params['schedule.scheduleId.uuid'] = params['schedule_schedule_id_uuid']  # noqa: E501

        query_params = []
        if 'mask' in params:
            query_params.append(('mask', params['mask']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/schedules/{schedule.scheduleId.uuid}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateScheduleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
