# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class SecurityDBApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_model_security_report(self, repo_id, **kwargs):  # noqa: E501
        """GetModelSecurityReport  # noqa: E501

        Returns the supply chain risk report for a Hugging Face model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_security_report(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The ID of the model repository on Hugging Face. (required)
        :param str repo_type:  - REPO_TYPE_HUGGING_FACE_UNSPECIFIED: protolint:disable:next ENUM_FIELD_NAMES_ZERO_VALUE_END_WITH
        :return: RimeGetModelSecurityReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_security_report_with_http_info(repo_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_model_security_report_with_http_info(repo_id, **kwargs)  # noqa: E501
            return data

    def get_model_security_report_with_http_info(self, repo_id, **kwargs):  # noqa: E501
        """GetModelSecurityReport  # noqa: E501

        Returns the supply chain risk report for a Hugging Face model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_security_report_with_http_info(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The ID of the model repository on Hugging Face. (required)
        :param str repo_type:  - REPO_TYPE_HUGGING_FACE_UNSPECIFIED: protolint:disable:next ENUM_FIELD_NAMES_ZERO_VALUE_END_WITH
        :return: RimeGetModelSecurityReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'repo_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model_security_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_model_security_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'repo_id' in params:
            query_params.append(('repoId', params['repo_id']))  # noqa: E501
        if 'repo_type' in params:
            query_params.append(('repoType', params['repo_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/security-report/model', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetModelSecurityReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_model_security_reports(self, **kwargs):  # noqa: E501
        """ListModelSecurityReports  # noqa: E501

        Returns all supply chain risk reports for the workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_model_security_reports(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_token: A token representing one page from the list returned by a ListModelSecurityReports API. The ListModelSecurityReports API returns a page_token when there is more than one page of results.
        :param str page_size: The maximum number of objects to return in a single page. Maximum page size is 1000.
        :return: RimeListModelSecurityReportsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_model_security_reports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_model_security_reports_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_model_security_reports_with_http_info(self, **kwargs):  # noqa: E501
        """ListModelSecurityReports  # noqa: E501

        Returns all supply chain risk reports for the workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_model_security_reports_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_token: A token representing one page from the list returned by a ListModelSecurityReports API. The ListModelSecurityReports API returns a page_token when there is more than one page of results.
        :param str page_size: The maximum number of objects to return in a single page. Maximum page size is 1000.
        :return: RimeListModelSecurityReportsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_model_security_reports" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/security-report/models', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListModelSecurityReportsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
