# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class ValidationServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def validation_service_get_validate_dataset_task_status(self, job_id_uuid, **kwargs):  # noqa: E501
        """GetValidateDatasetTaskStatus returns the status of a dataset validation job.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validation_service_get_validate_dataset_task_status(job_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id_uuid: Unique object ID. (required)
        :return: RimeGetValidateDatasetTaskStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validation_service_get_validate_dataset_task_status_with_http_info(job_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.validation_service_get_validate_dataset_task_status_with_http_info(job_id_uuid, **kwargs)  # noqa: E501
            return data

    def validation_service_get_validate_dataset_task_status_with_http_info(self, job_id_uuid, **kwargs):  # noqa: E501
        """GetValidateDatasetTaskStatus returns the status of a dataset validation job.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validation_service_get_validate_dataset_task_status_with_http_info(job_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id_uuid: Unique object ID. (required)
        :return: RimeGetValidateDatasetTaskStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validation_service_get_validate_dataset_task_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_id_uuid' is set
        if ('job_id_uuid' not in params or
                params['job_id_uuid'] is None):
            raise ValueError("Missing the required parameter `job_id_uuid` when calling `validation_service_get_validate_dataset_task_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id_uuid' in params:
            path_params['jobId.uuid'] = params['job_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/validation/dataset/{jobId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetValidateDatasetTaskStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validation_service_get_validate_model_task_status(self, job_id_uuid, **kwargs):  # noqa: E501
        """GetValidateModelTaskStatus returns the status of a model validation job.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validation_service_get_validate_model_task_status(job_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id_uuid: Unique object ID. (required)
        :return: RimeGetValidateModelTaskStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validation_service_get_validate_model_task_status_with_http_info(job_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.validation_service_get_validate_model_task_status_with_http_info(job_id_uuid, **kwargs)  # noqa: E501
            return data

    def validation_service_get_validate_model_task_status_with_http_info(self, job_id_uuid, **kwargs):  # noqa: E501
        """GetValidateModelTaskStatus returns the status of a model validation job.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validation_service_get_validate_model_task_status_with_http_info(job_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id_uuid: Unique object ID. (required)
        :return: RimeGetValidateModelTaskStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validation_service_get_validate_model_task_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_id_uuid' is set
        if ('job_id_uuid' not in params or
                params['job_id_uuid'] is None):
            raise ValueError("Missing the required parameter `job_id_uuid` when calling `validation_service_get_validate_model_task_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id_uuid' in params:
            path_params['jobId.uuid'] = params['job_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/validation/model/{jobId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetValidateModelTaskStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validation_service_get_validate_predictions_task_status(self, job_id_uuid, **kwargs):  # noqa: E501
        """GetValidatePredictionsTaskStatus returns the status of a predictions validation job.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validation_service_get_validate_predictions_task_status(job_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id_uuid: Unique object ID. (required)
        :return: RimeGetValidatePredictionsTaskStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validation_service_get_validate_predictions_task_status_with_http_info(job_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.validation_service_get_validate_predictions_task_status_with_http_info(job_id_uuid, **kwargs)  # noqa: E501
            return data

    def validation_service_get_validate_predictions_task_status_with_http_info(self, job_id_uuid, **kwargs):  # noqa: E501
        """GetValidatePredictionsTaskStatus returns the status of a predictions validation job.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validation_service_get_validate_predictions_task_status_with_http_info(job_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id_uuid: Unique object ID. (required)
        :return: RimeGetValidatePredictionsTaskStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validation_service_get_validate_predictions_task_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_id_uuid' is set
        if ('job_id_uuid' not in params or
                params['job_id_uuid'] is None):
            raise ValueError("Missing the required parameter `job_id_uuid` when calling `validation_service_get_validate_predictions_task_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id_uuid' in params:
            path_params['jobId.uuid'] = params['job_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/validation/predictions/{jobId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetValidatePredictionsTaskStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validation_service_start_validate_dataset_task(self, body, **kwargs):  # noqa: E501
        """StartValidateDatasetTask kicks off a new job that validates a dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validation_service_start_validate_dataset_task(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeStartValidateDatasetTaskRequest body: (required)
        :return: RimeStartValidateDatasetTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validation_service_start_validate_dataset_task_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.validation_service_start_validate_dataset_task_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def validation_service_start_validate_dataset_task_with_http_info(self, body, **kwargs):  # noqa: E501
        """StartValidateDatasetTask kicks off a new job that validates a dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validation_service_start_validate_dataset_task_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeStartValidateDatasetTaskRequest body: (required)
        :return: RimeStartValidateDatasetTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validation_service_start_validate_dataset_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `validation_service_start_validate_dataset_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/validation/dataset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeStartValidateDatasetTaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validation_service_start_validate_model_task(self, body, **kwargs):  # noqa: E501
        """StartValidateModelTask kicks off a new job that validates a model.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validation_service_start_validate_model_task(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeStartValidateModelTaskRequest body: (required)
        :return: RimeStartValidateModelTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validation_service_start_validate_model_task_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.validation_service_start_validate_model_task_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def validation_service_start_validate_model_task_with_http_info(self, body, **kwargs):  # noqa: E501
        """StartValidateModelTask kicks off a new job that validates a model.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validation_service_start_validate_model_task_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeStartValidateModelTaskRequest body: (required)
        :return: RimeStartValidateModelTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validation_service_start_validate_model_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `validation_service_start_validate_model_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/validation/model', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeStartValidateModelTaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validation_service_start_validate_predictions_task(self, body, **kwargs):  # noqa: E501
        """StartValidatePredictionsTask kicks off a new job that validates predictions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validation_service_start_validate_predictions_task(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeStartValidatePredictionsTaskRequest body: (required)
        :return: RimeStartValidatePredictionsTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validation_service_start_validate_predictions_task_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.validation_service_start_validate_predictions_task_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def validation_service_start_validate_predictions_task_with_http_info(self, body, **kwargs):  # noqa: E501
        """StartValidatePredictionsTask kicks off a new job that validates predictions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validation_service_start_validate_predictions_task_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeStartValidatePredictionsTaskRequest body: (required)
        :return: RimeStartValidatePredictionsTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validation_service_start_validate_predictions_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `validation_service_start_validate_predictions_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/validation/predictions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeStartValidatePredictionsTaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
