# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class WorkspaceServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_users_to_workspace(self, body, workspace_id_uuid, **kwargs):  # noqa: E501
        """AddUsersToWorkspace  # noqa: E501

        Grants Users permissions to a Workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_users_to_workspace(body, workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkspaceIdUuidUsersBody body: (required)
        :param str workspace_id_uuid: Unique object ID. (required)
        :return: RimeAddUsersToWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_users_to_workspace_with_http_info(body, workspace_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.add_users_to_workspace_with_http_info(body, workspace_id_uuid, **kwargs)  # noqa: E501
            return data

    def add_users_to_workspace_with_http_info(self, body, workspace_id_uuid, **kwargs):  # noqa: E501
        """AddUsersToWorkspace  # noqa: E501

        Grants Users permissions to a Workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_users_to_workspace_with_http_info(body, workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkspaceIdUuidUsersBody body: (required)
        :param str workspace_id_uuid: Unique object ID. (required)
        :return: RimeAddUsersToWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'workspace_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_users_to_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_users_to_workspace`")  # noqa: E501
        # verify the required parameter 'workspace_id_uuid' is set
        if ('workspace_id_uuid' not in params or
                params['workspace_id_uuid'] is None):
            raise ValueError("Missing the required parameter `workspace_id_uuid` when calling `add_users_to_workspace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace_id_uuid' in params:
            path_params['workspaceId.uuid'] = params['workspace_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workspace/{workspaceId.uuid}/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeAddUsersToWorkspaceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_workspace(self, body, **kwargs):  # noqa: E501
        """CreateWorkspace  # noqa: E501

        Create a new Workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_workspace(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateWorkspaceRequest body: (required)
        :return: RimeCreateWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_workspace_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_workspace_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_workspace_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateWorkspace  # noqa: E501

        Create a new Workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_workspace_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateWorkspaceRequest body: (required)
        :return: RimeCreateWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_workspace`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workspace', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateWorkspaceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_workspace(self, workspace_id_uuid, **kwargs):  # noqa: E501
        """DeleteWorkspace  # noqa: E501

        Deletes an existing Workspace by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_workspace(workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_workspace_with_http_info(workspace_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_workspace_with_http_info(workspace_id_uuid, **kwargs)  # noqa: E501
            return data

    def delete_workspace_with_http_info(self, workspace_id_uuid, **kwargs):  # noqa: E501
        """DeleteWorkspace  # noqa: E501

        Deletes an existing Workspace by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_workspace_with_http_info(workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace_id_uuid' is set
        if ('workspace_id_uuid' not in params or
                params['workspace_id_uuid'] is None):
            raise ValueError("Missing the required parameter `workspace_id_uuid` when calling `delete_workspace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace_id_uuid' in params:
            path_params['workspaceId.uuid'] = params['workspace_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workspace/{workspaceId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workspace(self, workspace_id_uuid, **kwargs):  # noqa: E501
        """GetWorkspace  # noqa: E501

        Return a Workspace by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workspace(workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID. (required)
        :return: RimeGetWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workspace_with_http_info(workspace_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workspace_with_http_info(workspace_id_uuid, **kwargs)  # noqa: E501
            return data

    def get_workspace_with_http_info(self, workspace_id_uuid, **kwargs):  # noqa: E501
        """GetWorkspace  # noqa: E501

        Return a Workspace by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workspace_with_http_info(workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID. (required)
        :return: RimeGetWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace_id_uuid' is set
        if ('workspace_id_uuid' not in params or
                params['workspace_id_uuid'] is None):
            raise ValueError("Missing the required parameter `workspace_id_uuid` when calling `get_workspace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace_id_uuid' in params:
            path_params['workspaceId.uuid'] = params['workspace_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workspace/{workspaceId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetWorkspaceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_project_tags_in_workspace(self, workspace_id_uuid, **kwargs):  # noqa: E501
        """ListProjectTagsInWorkspace  # noqa: E501

        List the union of all tags in all projects in the workspace  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_project_tags_in_workspace(workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID. (required)
        :return: RimeListProjectTagsInWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_project_tags_in_workspace_with_http_info(workspace_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_project_tags_in_workspace_with_http_info(workspace_id_uuid, **kwargs)  # noqa: E501
            return data

    def list_project_tags_in_workspace_with_http_info(self, workspace_id_uuid, **kwargs):  # noqa: E501
        """ListProjectTagsInWorkspace  # noqa: E501

        List the union of all tags in all projects in the workspace  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_project_tags_in_workspace_with_http_info(workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID. (required)
        :return: RimeListProjectTagsInWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_tags_in_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace_id_uuid' is set
        if ('workspace_id_uuid' not in params or
                params['workspace_id_uuid'] is None):
            raise ValueError("Missing the required parameter `workspace_id_uuid` when calling `list_project_tags_in_workspace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace_id_uuid' in params:
            path_params['workspaceId.uuid'] = params['workspace_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workspace/{workspaceId.uuid}/tags/project', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListProjectTagsInWorkspaceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_users_of_workspace(self, workspace_id_uuid, **kwargs):  # noqa: E501
        """ListUsersOfWorkspace  # noqa: E501

        Lists all Users that have permissions to a Workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_users_of_workspace(workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID. (required)
        :param str page_token: Specifies a page of the list returned by a ListUsersOfWorkspace query. The ListUsersOfWorkspace query returns a pageToken when there is more than one page of results.
        :param str page_size: The maximum number of User objects to return in a single page.
        :return: RimeListUsersOfWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_users_of_workspace_with_http_info(workspace_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_users_of_workspace_with_http_info(workspace_id_uuid, **kwargs)  # noqa: E501
            return data

    def list_users_of_workspace_with_http_info(self, workspace_id_uuid, **kwargs):  # noqa: E501
        """ListUsersOfWorkspace  # noqa: E501

        Lists all Users that have permissions to a Workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_users_of_workspace_with_http_info(workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID. (required)
        :param str page_token: Specifies a page of the list returned by a ListUsersOfWorkspace query. The ListUsersOfWorkspace query returns a pageToken when there is more than one page of results.
        :param str page_size: The maximum number of User objects to return in a single page.
        :return: RimeListUsersOfWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id_uuid', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_users_of_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace_id_uuid' is set
        if ('workspace_id_uuid' not in params or
                params['workspace_id_uuid'] is None):
            raise ValueError("Missing the required parameter `workspace_id_uuid` when calling `list_users_of_workspace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace_id_uuid' in params:
            path_params['workspaceId.uuid'] = params['workspace_id_uuid']  # noqa: E501

        query_params = []
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workspace/{workspaceId.uuid}/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListUsersOfWorkspaceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_workspaces(self, **kwargs):  # noqa: E501
        """ListWorkspaces  # noqa: E501

        List Workspaces with optional filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workspaces(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: The maximum number of Workspace objects to return in a single page.
        :param str page_token: Specifies a page of the list returned by a ListWorkspaces query. The ListWorkspaces query returns a pageToken when there is more than one page of results.
        :return: RimeListWorkspacesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_workspaces_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_workspaces_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_workspaces_with_http_info(self, **kwargs):  # noqa: E501
        """ListWorkspaces  # noqa: E501

        List Workspaces with optional filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workspaces_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: The maximum number of Workspace objects to return in a single page.
        :param str page_token: Specifies a page of the list returned by a ListWorkspaces query. The ListWorkspaces query returns a pageToken when there is more than one page of results.
        :return: RimeListWorkspacesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workspaces" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workspace', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListWorkspacesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_user_from_workspace(self, workspace_id_uuid, user_id_uuid, **kwargs):  # noqa: E501
        """RemoveUserFromWorkspace  # noqa: E501

        Removes a User from a Workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_user_from_workspace(workspace_id_uuid, user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID. (required)
        :param str user_id_uuid: Unique object ID. (required)
        :return: RimeRemoveUserFromWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_user_from_workspace_with_http_info(workspace_id_uuid, user_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_user_from_workspace_with_http_info(workspace_id_uuid, user_id_uuid, **kwargs)  # noqa: E501
            return data

    def remove_user_from_workspace_with_http_info(self, workspace_id_uuid, user_id_uuid, **kwargs):  # noqa: E501
        """RemoveUserFromWorkspace  # noqa: E501

        Removes a User from a Workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_user_from_workspace_with_http_info(workspace_id_uuid, user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID. (required)
        :param str user_id_uuid: Unique object ID. (required)
        :return: RimeRemoveUserFromWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id_uuid', 'user_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_user_from_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace_id_uuid' is set
        if ('workspace_id_uuid' not in params or
                params['workspace_id_uuid'] is None):
            raise ValueError("Missing the required parameter `workspace_id_uuid` when calling `remove_user_from_workspace`")  # noqa: E501
        # verify the required parameter 'user_id_uuid' is set
        if ('user_id_uuid' not in params or
                params['user_id_uuid'] is None):
            raise ValueError("Missing the required parameter `user_id_uuid` when calling `remove_user_from_workspace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace_id_uuid' in params:
            path_params['workspaceId.uuid'] = params['workspace_id_uuid']  # noqa: E501
        if 'user_id_uuid' in params:
            path_params['userId.uuid'] = params['user_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workspace/{workspaceId.uuid}/users/{userId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRemoveUserFromWorkspaceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_user_of_workspace(self, body, workspace_id_uuid, user_user_id_uuid, **kwargs):  # noqa: E501
        """UpdateUserOfWorkspace  # noqa: E501

        Updates the permission of a specified User for a Workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_of_workspace(body, workspace_id_uuid, user_user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UsersUserUserIdUuidBody1 body: (required)
        :param str workspace_id_uuid: Unique object ID. (required)
        :param str user_user_id_uuid: Unique object ID. (required)
        :return: RimeUpdateUserOfWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_user_of_workspace_with_http_info(body, workspace_id_uuid, user_user_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_user_of_workspace_with_http_info(body, workspace_id_uuid, user_user_id_uuid, **kwargs)  # noqa: E501
            return data

    def update_user_of_workspace_with_http_info(self, body, workspace_id_uuid, user_user_id_uuid, **kwargs):  # noqa: E501
        """UpdateUserOfWorkspace  # noqa: E501

        Updates the permission of a specified User for a Workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_of_workspace_with_http_info(body, workspace_id_uuid, user_user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UsersUserUserIdUuidBody1 body: (required)
        :param str workspace_id_uuid: Unique object ID. (required)
        :param str user_user_id_uuid: Unique object ID. (required)
        :return: RimeUpdateUserOfWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'workspace_id_uuid', 'user_user_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_of_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_user_of_workspace`")  # noqa: E501
        # verify the required parameter 'workspace_id_uuid' is set
        if ('workspace_id_uuid' not in params or
                params['workspace_id_uuid'] is None):
            raise ValueError("Missing the required parameter `workspace_id_uuid` when calling `update_user_of_workspace`")  # noqa: E501
        # verify the required parameter 'user_user_id_uuid' is set
        if ('user_user_id_uuid' not in params or
                params['user_user_id_uuid'] is None):
            raise ValueError("Missing the required parameter `user_user_id_uuid` when calling `update_user_of_workspace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace_id_uuid' in params:
            path_params['workspaceId.uuid'] = params['workspace_id_uuid']  # noqa: E501
        if 'user_user_id_uuid' in params:
            path_params['user.userId.uuid'] = params['user_user_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workspace/{workspaceId.uuid}/users/{user.userId.uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateUserOfWorkspaceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_workspace(self, body, workspace_workspace_id_uuid, **kwargs):  # noqa: E501
        """UpdateWorkspace  # noqa: E501

        Updates an existing Workspace by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workspace(body, workspace_workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkspaceWorkspaceWorkspaceIdUuidBody body: (required)
        :param str workspace_workspace_id_uuid: Unique object ID. (required)
        :return: RimeUpdateWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_workspace_with_http_info(body, workspace_workspace_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_workspace_with_http_info(body, workspace_workspace_id_uuid, **kwargs)  # noqa: E501
            return data

    def update_workspace_with_http_info(self, body, workspace_workspace_id_uuid, **kwargs):  # noqa: E501
        """UpdateWorkspace  # noqa: E501

        Updates an existing Workspace by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workspace_with_http_info(body, workspace_workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkspaceWorkspaceWorkspaceIdUuidBody body: (required)
        :param str workspace_workspace_id_uuid: Unique object ID. (required)
        :return: RimeUpdateWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'workspace_workspace_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_workspace`")  # noqa: E501
        # verify the required parameter 'workspace_workspace_id_uuid' is set
        if ('workspace_workspace_id_uuid' not in params or
                params['workspace_workspace_id_uuid'] is None):
            raise ValueError("Missing the required parameter `workspace_workspace_id_uuid` when calling `update_workspace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace_workspace_id_uuid' in params:
            path_params['workspace.workspaceId.uuid'] = params['workspace_workspace_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Firewall-Auth-Token', 'rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workspace/{workspace.workspaceId.uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateWorkspaceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
