# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class DatasetCTInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'firewall_id': 'RimeUUID',
        'start_time': 'datetime',
        'end_time': 'datetime',
        'ct_dataset_type': 'DatasetCTDatasetType'
    }

    attribute_map = {
        'firewall_id': 'firewallId',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'ct_dataset_type': 'ctDatasetType'
    }

    def __init__(self, firewall_id=None, start_time=None, end_time=None, ct_dataset_type=None):  # noqa: E501
        """DatasetCTInfo - a model defined in Swagger"""  # noqa: E501
        self._firewall_id = None
        self._start_time = None
        self._end_time = None
        self._ct_dataset_type = None
        self.discriminator = None
        if firewall_id is not None:
            self.firewall_id = firewall_id
        self.start_time = start_time
        self.end_time = end_time
        if ct_dataset_type is not None:
            self.ct_dataset_type = ct_dataset_type

    @property
    def firewall_id(self):
        """Gets the firewall_id of this DatasetCTInfo.  # noqa: E501


        :return: The firewall_id of this DatasetCTInfo.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._firewall_id

    @firewall_id.setter
    def firewall_id(self, firewall_id):
        """Sets the firewall_id of this DatasetCTInfo.


        :param firewall_id: The firewall_id of this DatasetCTInfo.  # noqa: E501
        :type: RimeUUID
        """

        self._firewall_id = firewall_id

    @property
    def start_time(self):
        """Gets the start_time of this DatasetCTInfo.  # noqa: E501

        Start and end time are the start and end time of this dataset.  # noqa: E501

        :return: The start_time of this DatasetCTInfo.  # noqa: E501
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this DatasetCTInfo.

        Start and end time are the start and end time of this dataset.  # noqa: E501

        :param start_time: The start_time of this DatasetCTInfo.  # noqa: E501
        :type: datetime
        """
        if start_time is None:
            raise ValueError("Invalid value for `start_time`, must not be `None`")  # noqa: E501

        self._start_time = start_time

    @property
    def end_time(self):
        """Gets the end_time of this DatasetCTInfo.  # noqa: E501


        :return: The end_time of this DatasetCTInfo.  # noqa: E501
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this DatasetCTInfo.


        :param end_time: The end_time of this DatasetCTInfo.  # noqa: E501
        :type: datetime
        """
        if end_time is None:
            raise ValueError("Invalid value for `end_time`, must not be `None`")  # noqa: E501

        self._end_time = end_time

    @property
    def ct_dataset_type(self):
        """Gets the ct_dataset_type of this DatasetCTInfo.  # noqa: E501


        :return: The ct_dataset_type of this DatasetCTInfo.  # noqa: E501
        :rtype: DatasetCTDatasetType
        """
        return self._ct_dataset_type

    @ct_dataset_type.setter
    def ct_dataset_type(self, ct_dataset_type):
        """Sets the ct_dataset_type of this DatasetCTInfo.


        :param ct_dataset_type: The ct_dataset_type of this DatasetCTInfo.  # noqa: E501
        :type: DatasetCTDatasetType
        """

        self._ct_dataset_type = ct_dataset_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DatasetCTInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DatasetCTInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
