# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class DatasetDataset(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'dataset_id': 'str',
        'project_ids': 'list[RimeUUID]',
        'creator_id': 'RimeUUID',
        'creation_time': 'datetime',
        'user_metadata': 'RegistryMetadata',
        'integration_id': 'RimeUUID',
        'data_info': 'RegistryDataInfo',
        'ct_info': 'DatasetCTInfo',
        'validity_status': 'RegistryValidityStatus',
        'marked_for_delete_at': 'datetime',
        'validity_status_message': 'str',
        'size_bytes': 'str'
    }

    attribute_map = {
        'name': 'name',
        'dataset_id': 'datasetId',
        'project_ids': 'projectIds',
        'creator_id': 'creatorId',
        'creation_time': 'creationTime',
        'user_metadata': 'userMetadata',
        'integration_id': 'integrationId',
        'data_info': 'dataInfo',
        'ct_info': 'ctInfo',
        'validity_status': 'validityStatus',
        'marked_for_delete_at': 'markedForDeleteAt',
        'validity_status_message': 'validityStatusMessage',
        'size_bytes': 'sizeBytes'
    }

    def __init__(self, name=None, dataset_id=None, project_ids=None, creator_id=None, creation_time=None, user_metadata=None, integration_id=None, data_info=None, ct_info=None, validity_status=None, marked_for_delete_at=None, validity_status_message=None, size_bytes=None):  # noqa: E501
        """DatasetDataset - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._dataset_id = None
        self._project_ids = None
        self._creator_id = None
        self._creation_time = None
        self._user_metadata = None
        self._integration_id = None
        self._data_info = None
        self._ct_info = None
        self._validity_status = None
        self._marked_for_delete_at = None
        self._validity_status_message = None
        self._size_bytes = None
        self.discriminator = None
        if name is not None:
            self.name = name
        if dataset_id is not None:
            self.dataset_id = dataset_id
        if project_ids is not None:
            self.project_ids = project_ids
        if creator_id is not None:
            self.creator_id = creator_id
        if creation_time is not None:
            self.creation_time = creation_time
        if user_metadata is not None:
            self.user_metadata = user_metadata
        if integration_id is not None:
            self.integration_id = integration_id
        if data_info is not None:
            self.data_info = data_info
        if ct_info is not None:
            self.ct_info = ct_info
        if validity_status is not None:
            self.validity_status = validity_status
        if marked_for_delete_at is not None:
            self.marked_for_delete_at = marked_for_delete_at
        if validity_status_message is not None:
            self.validity_status_message = validity_status_message
        if size_bytes is not None:
            self.size_bytes = size_bytes

    @property
    def name(self):
        """Gets the name of this DatasetDataset.  # noqa: E501

        Name and dataset_id are both enforced to be unique. Name is user specified. dataset_id is internally generated. It is semantically determined as firewall_id#start_time#end_time in the case the CTInfo is provided.  # noqa: E501

        :return: The name of this DatasetDataset.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DatasetDataset.

        Name and dataset_id are both enforced to be unique. Name is user specified. dataset_id is internally generated. It is semantically determined as firewall_id#start_time#end_time in the case the CTInfo is provided.  # noqa: E501

        :param name: The name of this DatasetDataset.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def dataset_id(self):
        """Gets the dataset_id of this DatasetDataset.  # noqa: E501


        :return: The dataset_id of this DatasetDataset.  # noqa: E501
        :rtype: str
        """
        return self._dataset_id

    @dataset_id.setter
    def dataset_id(self, dataset_id):
        """Sets the dataset_id of this DatasetDataset.


        :param dataset_id: The dataset_id of this DatasetDataset.  # noqa: E501
        :type: str
        """

        self._dataset_id = dataset_id

    @property
    def project_ids(self):
        """Gets the project_ids of this DatasetDataset.  # noqa: E501

        For now, a dataset will only have one project_id associated with it. We make this an array to allow dataset's to be shared in the future.  # noqa: E501

        :return: The project_ids of this DatasetDataset.  # noqa: E501
        :rtype: list[RimeUUID]
        """
        return self._project_ids

    @project_ids.setter
    def project_ids(self, project_ids):
        """Sets the project_ids of this DatasetDataset.

        For now, a dataset will only have one project_id associated with it. We make this an array to allow dataset's to be shared in the future.  # noqa: E501

        :param project_ids: The project_ids of this DatasetDataset.  # noqa: E501
        :type: list[RimeUUID]
        """

        self._project_ids = project_ids

    @property
    def creator_id(self):
        """Gets the creator_id of this DatasetDataset.  # noqa: E501


        :return: The creator_id of this DatasetDataset.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._creator_id

    @creator_id.setter
    def creator_id(self, creator_id):
        """Sets the creator_id of this DatasetDataset.


        :param creator_id: The creator_id of this DatasetDataset.  # noqa: E501
        :type: RimeUUID
        """

        self._creator_id = creator_id

    @property
    def creation_time(self):
        """Gets the creation_time of this DatasetDataset.  # noqa: E501


        :return: The creation_time of this DatasetDataset.  # noqa: E501
        :rtype: datetime
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this DatasetDataset.


        :param creation_time: The creation_time of this DatasetDataset.  # noqa: E501
        :type: datetime
        """

        self._creation_time = creation_time

    @property
    def user_metadata(self):
        """Gets the user_metadata of this DatasetDataset.  # noqa: E501


        :return: The user_metadata of this DatasetDataset.  # noqa: E501
        :rtype: RegistryMetadata
        """
        return self._user_metadata

    @user_metadata.setter
    def user_metadata(self, user_metadata):
        """Sets the user_metadata of this DatasetDataset.


        :param user_metadata: The user_metadata of this DatasetDataset.  # noqa: E501
        :type: RegistryMetadata
        """

        self._user_metadata = user_metadata

    @property
    def integration_id(self):
        """Gets the integration_id of this DatasetDataset.  # noqa: E501


        :return: The integration_id of this DatasetDataset.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._integration_id

    @integration_id.setter
    def integration_id(self, integration_id):
        """Sets the integration_id of this DatasetDataset.


        :param integration_id: The integration_id of this DatasetDataset.  # noqa: E501
        :type: RimeUUID
        """

        self._integration_id = integration_id

    @property
    def data_info(self):
        """Gets the data_info of this DatasetDataset.  # noqa: E501


        :return: The data_info of this DatasetDataset.  # noqa: E501
        :rtype: RegistryDataInfo
        """
        return self._data_info

    @data_info.setter
    def data_info(self, data_info):
        """Sets the data_info of this DatasetDataset.


        :param data_info: The data_info of this DatasetDataset.  # noqa: E501
        :type: RegistryDataInfo
        """

        self._data_info = data_info

    @property
    def ct_info(self):
        """Gets the ct_info of this DatasetDataset.  # noqa: E501


        :return: The ct_info of this DatasetDataset.  # noqa: E501
        :rtype: DatasetCTInfo
        """
        return self._ct_info

    @ct_info.setter
    def ct_info(self, ct_info):
        """Sets the ct_info of this DatasetDataset.


        :param ct_info: The ct_info of this DatasetDataset.  # noqa: E501
        :type: DatasetCTInfo
        """

        self._ct_info = ct_info

    @property
    def validity_status(self):
        """Gets the validity_status of this DatasetDataset.  # noqa: E501


        :return: The validity_status of this DatasetDataset.  # noqa: E501
        :rtype: RegistryValidityStatus
        """
        return self._validity_status

    @validity_status.setter
    def validity_status(self, validity_status):
        """Sets the validity_status of this DatasetDataset.


        :param validity_status: The validity_status of this DatasetDataset.  # noqa: E501
        :type: RegistryValidityStatus
        """

        self._validity_status = validity_status

    @property
    def marked_for_delete_at(self):
        """Gets the marked_for_delete_at of this DatasetDataset.  # noqa: E501

        If marked_for_delete_at is set, the document will be deleted after a TTL.  # noqa: E501

        :return: The marked_for_delete_at of this DatasetDataset.  # noqa: E501
        :rtype: datetime
        """
        return self._marked_for_delete_at

    @marked_for_delete_at.setter
    def marked_for_delete_at(self, marked_for_delete_at):
        """Sets the marked_for_delete_at of this DatasetDataset.

        If marked_for_delete_at is set, the document will be deleted after a TTL.  # noqa: E501

        :param marked_for_delete_at: The marked_for_delete_at of this DatasetDataset.  # noqa: E501
        :type: datetime
        """

        self._marked_for_delete_at = marked_for_delete_at

    @property
    def validity_status_message(self):
        """Gets the validity_status_message of this DatasetDataset.  # noqa: E501

        Information about the validity status of the dataset, such as why it is invalid.  A Case where this would be populated is when the ValidityStatus is not explicitly set to valid by the XP validation task and additional details are required to convey to the user why the dataset is not valid.  # noqa: E501

        :return: The validity_status_message of this DatasetDataset.  # noqa: E501
        :rtype: str
        """
        return self._validity_status_message

    @validity_status_message.setter
    def validity_status_message(self, validity_status_message):
        """Sets the validity_status_message of this DatasetDataset.

        Information about the validity status of the dataset, such as why it is invalid.  A Case where this would be populated is when the ValidityStatus is not explicitly set to valid by the XP validation task and additional details are required to convey to the user why the dataset is not valid.  # noqa: E501

        :param validity_status_message: The validity_status_message of this DatasetDataset.  # noqa: E501
        :type: str
        """

        self._validity_status_message = validity_status_message

    @property
    def size_bytes(self):
        """Gets the size_bytes of this DatasetDataset.  # noqa: E501


        :return: The size_bytes of this DatasetDataset.  # noqa: E501
        :rtype: str
        """
        return self._size_bytes

    @size_bytes.setter
    def size_bytes(self, size_bytes):
        """Sets the size_bytes of this DatasetDataset.


        :param size_bytes: The size_bytes of this DatasetDataset.  # noqa: E501
        :type: str
        """

        self._size_bytes = size_bytes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DatasetDataset, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DatasetDataset):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
