# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class FirewallinstanceRequestBody(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'agent_id': 'object',
        'config': 'GenerativefirewallFirewallRuleConfig',
        'description': 'str',
        'spec': 'GenerativefirewallFirewallInstanceDeploymentConfig'
    }

    attribute_map = {
        'agent_id': 'agentId',
        'config': 'config',
        'description': 'description',
        'spec': 'spec'
    }

    def __init__(self, agent_id=None, config=None, description=None, spec=None):  # noqa: E501
        """FirewallinstanceRequestBody - a model defined in Swagger"""  # noqa: E501
        self._agent_id = None
        self._config = None
        self._description = None
        self._spec = None
        self.discriminator = None
        if agent_id is not None:
            self.agent_id = agent_id
        if config is not None:
            self.config = config
        if description is not None:
            self.description = description
        if spec is not None:
            self.spec = spec

    @property
    def agent_id(self):
        """Gets the agent_id of this FirewallinstanceRequestBody.  # noqa: E501

        ID of the agent that will create the firewall instance.  # noqa: E501

        :return: The agent_id of this FirewallinstanceRequestBody.  # noqa: E501
        :rtype: object
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """Sets the agent_id of this FirewallinstanceRequestBody.

        ID of the agent that will create the firewall instance.  # noqa: E501

        :param agent_id: The agent_id of this FirewallinstanceRequestBody.  # noqa: E501
        :type: object
        """

        self._agent_id = agent_id

    @property
    def config(self):
        """Gets the config of this FirewallinstanceRequestBody.  # noqa: E501


        :return: The config of this FirewallinstanceRequestBody.  # noqa: E501
        :rtype: GenerativefirewallFirewallRuleConfig
        """
        return self._config

    @config.setter
    def config(self, config):
        """Sets the config of this FirewallinstanceRequestBody.


        :param config: The config of this FirewallinstanceRequestBody.  # noqa: E501
        :type: GenerativefirewallFirewallRuleConfig
        """

        self._config = config

    @property
    def description(self):
        """Gets the description of this FirewallinstanceRequestBody.  # noqa: E501

        Optional human-readable description of the firewall instance.  # noqa: E501

        :return: The description of this FirewallinstanceRequestBody.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this FirewallinstanceRequestBody.

        Optional human-readable description of the firewall instance.  # noqa: E501

        :param description: The description of this FirewallinstanceRequestBody.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def spec(self):
        """Gets the spec of this FirewallinstanceRequestBody.  # noqa: E501


        :return: The spec of this FirewallinstanceRequestBody.  # noqa: E501
        :rtype: GenerativefirewallFirewallInstanceDeploymentConfig
        """
        return self._spec

    @spec.setter
    def spec(self, spec):
        """Sets the spec of this FirewallinstanceRequestBody.


        :param spec: The spec of this FirewallinstanceRequestBody.  # noqa: E501
        :type: GenerativefirewallFirewallInstanceDeploymentConfig
        """

        self._spec = spec

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FirewallinstanceRequestBody, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FirewallinstanceRequestBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
