# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GenerativeTestingResultExample(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'attack_prompt': 'str',
        'model_output': 'str'
    }

    attribute_map = {
        'attack_prompt': 'attackPrompt',
        'model_output': 'modelOutput'
    }

    def __init__(self, attack_prompt=None, model_output=None):  # noqa: E501
        """GenerativeTestingResultExample - a model defined in Swagger"""  # noqa: E501
        self._attack_prompt = None
        self._model_output = None
        self.discriminator = None
        if attack_prompt is not None:
            self.attack_prompt = attack_prompt
        if model_output is not None:
            self.model_output = model_output

    @property
    def attack_prompt(self):
        """Gets the attack_prompt of this GenerativeTestingResultExample.  # noqa: E501

        RI attack prompt to elicit issues.  # noqa: E501

        :return: The attack_prompt of this GenerativeTestingResultExample.  # noqa: E501
        :rtype: str
        """
        return self._attack_prompt

    @attack_prompt.setter
    def attack_prompt(self, attack_prompt):
        """Sets the attack_prompt of this GenerativeTestingResultExample.

        RI attack prompt to elicit issues.  # noqa: E501

        :param attack_prompt: The attack_prompt of this GenerativeTestingResultExample.  # noqa: E501
        :type: str
        """

        self._attack_prompt = attack_prompt

    @property
    def model_output(self):
        """Gets the model_output of this GenerativeTestingResultExample.  # noqa: E501

        Output from the generative model on the given prompt.  # noqa: E501

        :return: The model_output of this GenerativeTestingResultExample.  # noqa: E501
        :rtype: str
        """
        return self._model_output

    @model_output.setter
    def model_output(self, model_output):
        """Sets the model_output of this GenerativeTestingResultExample.

        Output from the generative model on the given prompt.  # noqa: E501

        :param model_output: The model_output of this GenerativeTestingResultExample.  # noqa: E501
        :type: str
        """

        self._model_output = model_output

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GenerativeTestingResultExample, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GenerativeTestingResultExample):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
