# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GenerativefirewallFirewallRuleConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'language': 'RimeLanguage',
        'selected_rules': 'list[GenerativefirewallFirewallRuleType]',
        'individual_rules_config': 'GenerativefirewallIndividualRulesConfig'
    }

    attribute_map = {
        'language': 'language',
        'selected_rules': 'selectedRules',
        'individual_rules_config': 'individualRulesConfig'
    }

    def __init__(self, language=None, selected_rules=None, individual_rules_config=None):  # noqa: E501
        """GenerativefirewallFirewallRuleConfig - a model defined in Swagger"""  # noqa: E501
        self._language = None
        self._selected_rules = None
        self._individual_rules_config = None
        self.discriminator = None
        if language is not None:
            self.language = language
        if selected_rules is not None:
            self.selected_rules = selected_rules
        if individual_rules_config is not None:
            self.individual_rules_config = individual_rules_config

    @property
    def language(self):
        """Gets the language of this GenerativefirewallFirewallRuleConfig.  # noqa: E501


        :return: The language of this GenerativefirewallFirewallRuleConfig.  # noqa: E501
        :rtype: RimeLanguage
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this GenerativefirewallFirewallRuleConfig.


        :param language: The language of this GenerativefirewallFirewallRuleConfig.  # noqa: E501
        :type: RimeLanguage
        """

        self._language = language

    @property
    def selected_rules(self):
        """Gets the selected_rules of this GenerativefirewallFirewallRuleConfig.  # noqa: E501

        If this list is empty, all available firewall rules will be run. Otherwise, only the rules specified here will be run.  # noqa: E501

        :return: The selected_rules of this GenerativefirewallFirewallRuleConfig.  # noqa: E501
        :rtype: list[GenerativefirewallFirewallRuleType]
        """
        return self._selected_rules

    @selected_rules.setter
    def selected_rules(self, selected_rules):
        """Sets the selected_rules of this GenerativefirewallFirewallRuleConfig.

        If this list is empty, all available firewall rules will be run. Otherwise, only the rules specified here will be run.  # noqa: E501

        :param selected_rules: The selected_rules of this GenerativefirewallFirewallRuleConfig.  # noqa: E501
        :type: list[GenerativefirewallFirewallRuleType]
        """

        self._selected_rules = selected_rules

    @property
    def individual_rules_config(self):
        """Gets the individual_rules_config of this GenerativefirewallFirewallRuleConfig.  # noqa: E501


        :return: The individual_rules_config of this GenerativefirewallFirewallRuleConfig.  # noqa: E501
        :rtype: GenerativefirewallIndividualRulesConfig
        """
        return self._individual_rules_config

    @individual_rules_config.setter
    def individual_rules_config(self, individual_rules_config):
        """Sets the individual_rules_config of this GenerativefirewallFirewallRuleConfig.


        :param individual_rules_config: The individual_rules_config of this GenerativefirewallFirewallRuleConfig.  # noqa: E501
        :type: GenerativefirewallIndividualRulesConfig
        """

        self._individual_rules_config = individual_rules_config

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GenerativefirewallFirewallRuleConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GenerativefirewallFirewallRuleConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
