# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GenerativefirewallRuleOutput(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'rule_name': 'str',
        'action': 'GenerativefirewallFirewallAction',
        'risk_category': 'RiskscoreRiskCategoryType',
        'pii_detection_details': 'GenerativefirewallPiiDetectionDetails',
        'language_detection_details': 'GenerativefirewallLanguageDetectionDetails',
        'prompt_injection_details': 'GenerativefirewallPromptInjectionDetails',
        'toxicity_detection_details': 'GenerativefirewallToxicityDetectionDetails',
        'code_detection_details': 'GenerativefirewallCodeDetectionDetails',
        'rule_eval_metadata': 'RuleOutputRuleEvaluationMetadata',
        'security_standards': 'list[ApigenerativefirewallStandardInfo]'
    }

    attribute_map = {
        'rule_name': 'ruleName',
        'action': 'action',
        'risk_category': 'riskCategory',
        'pii_detection_details': 'piiDetectionDetails',
        'language_detection_details': 'languageDetectionDetails',
        'prompt_injection_details': 'promptInjectionDetails',
        'toxicity_detection_details': 'toxicityDetectionDetails',
        'code_detection_details': 'codeDetectionDetails',
        'rule_eval_metadata': 'ruleEvalMetadata',
        'security_standards': 'securityStandards'
    }

    def __init__(self, rule_name=None, action=None, risk_category=None, pii_detection_details=None, language_detection_details=None, prompt_injection_details=None, toxicity_detection_details=None, code_detection_details=None, rule_eval_metadata=None, security_standards=None):  # noqa: E501
        """GenerativefirewallRuleOutput - a model defined in Swagger"""  # noqa: E501
        self._rule_name = None
        self._action = None
        self._risk_category = None
        self._pii_detection_details = None
        self._language_detection_details = None
        self._prompt_injection_details = None
        self._toxicity_detection_details = None
        self._code_detection_details = None
        self._rule_eval_metadata = None
        self._security_standards = None
        self.discriminator = None
        if rule_name is not None:
            self.rule_name = rule_name
        if action is not None:
            self.action = action
        if risk_category is not None:
            self.risk_category = risk_category
        if pii_detection_details is not None:
            self.pii_detection_details = pii_detection_details
        if language_detection_details is not None:
            self.language_detection_details = language_detection_details
        if prompt_injection_details is not None:
            self.prompt_injection_details = prompt_injection_details
        if toxicity_detection_details is not None:
            self.toxicity_detection_details = toxicity_detection_details
        if code_detection_details is not None:
            self.code_detection_details = code_detection_details
        if rule_eval_metadata is not None:
            self.rule_eval_metadata = rule_eval_metadata
        if security_standards is not None:
            self.security_standards = security_standards

    @property
    def rule_name(self):
        """Gets the rule_name of this GenerativefirewallRuleOutput.  # noqa: E501


        :return: The rule_name of this GenerativefirewallRuleOutput.  # noqa: E501
        :rtype: str
        """
        return self._rule_name

    @rule_name.setter
    def rule_name(self, rule_name):
        """Sets the rule_name of this GenerativefirewallRuleOutput.


        :param rule_name: The rule_name of this GenerativefirewallRuleOutput.  # noqa: E501
        :type: str
        """

        self._rule_name = rule_name

    @property
    def action(self):
        """Gets the action of this GenerativefirewallRuleOutput.  # noqa: E501


        :return: The action of this GenerativefirewallRuleOutput.  # noqa: E501
        :rtype: GenerativefirewallFirewallAction
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this GenerativefirewallRuleOutput.


        :param action: The action of this GenerativefirewallRuleOutput.  # noqa: E501
        :type: GenerativefirewallFirewallAction
        """

        self._action = action

    @property
    def risk_category(self):
        """Gets the risk_category of this GenerativefirewallRuleOutput.  # noqa: E501


        :return: The risk_category of this GenerativefirewallRuleOutput.  # noqa: E501
        :rtype: RiskscoreRiskCategoryType
        """
        return self._risk_category

    @risk_category.setter
    def risk_category(self, risk_category):
        """Sets the risk_category of this GenerativefirewallRuleOutput.


        :param risk_category: The risk_category of this GenerativefirewallRuleOutput.  # noqa: E501
        :type: RiskscoreRiskCategoryType
        """

        self._risk_category = risk_category

    @property
    def pii_detection_details(self):
        """Gets the pii_detection_details of this GenerativefirewallRuleOutput.  # noqa: E501


        :return: The pii_detection_details of this GenerativefirewallRuleOutput.  # noqa: E501
        :rtype: GenerativefirewallPiiDetectionDetails
        """
        return self._pii_detection_details

    @pii_detection_details.setter
    def pii_detection_details(self, pii_detection_details):
        """Sets the pii_detection_details of this GenerativefirewallRuleOutput.


        :param pii_detection_details: The pii_detection_details of this GenerativefirewallRuleOutput.  # noqa: E501
        :type: GenerativefirewallPiiDetectionDetails
        """

        self._pii_detection_details = pii_detection_details

    @property
    def language_detection_details(self):
        """Gets the language_detection_details of this GenerativefirewallRuleOutput.  # noqa: E501


        :return: The language_detection_details of this GenerativefirewallRuleOutput.  # noqa: E501
        :rtype: GenerativefirewallLanguageDetectionDetails
        """
        return self._language_detection_details

    @language_detection_details.setter
    def language_detection_details(self, language_detection_details):
        """Sets the language_detection_details of this GenerativefirewallRuleOutput.


        :param language_detection_details: The language_detection_details of this GenerativefirewallRuleOutput.  # noqa: E501
        :type: GenerativefirewallLanguageDetectionDetails
        """

        self._language_detection_details = language_detection_details

    @property
    def prompt_injection_details(self):
        """Gets the prompt_injection_details of this GenerativefirewallRuleOutput.  # noqa: E501


        :return: The prompt_injection_details of this GenerativefirewallRuleOutput.  # noqa: E501
        :rtype: GenerativefirewallPromptInjectionDetails
        """
        return self._prompt_injection_details

    @prompt_injection_details.setter
    def prompt_injection_details(self, prompt_injection_details):
        """Sets the prompt_injection_details of this GenerativefirewallRuleOutput.


        :param prompt_injection_details: The prompt_injection_details of this GenerativefirewallRuleOutput.  # noqa: E501
        :type: GenerativefirewallPromptInjectionDetails
        """

        self._prompt_injection_details = prompt_injection_details

    @property
    def toxicity_detection_details(self):
        """Gets the toxicity_detection_details of this GenerativefirewallRuleOutput.  # noqa: E501


        :return: The toxicity_detection_details of this GenerativefirewallRuleOutput.  # noqa: E501
        :rtype: GenerativefirewallToxicityDetectionDetails
        """
        return self._toxicity_detection_details

    @toxicity_detection_details.setter
    def toxicity_detection_details(self, toxicity_detection_details):
        """Sets the toxicity_detection_details of this GenerativefirewallRuleOutput.


        :param toxicity_detection_details: The toxicity_detection_details of this GenerativefirewallRuleOutput.  # noqa: E501
        :type: GenerativefirewallToxicityDetectionDetails
        """

        self._toxicity_detection_details = toxicity_detection_details

    @property
    def code_detection_details(self):
        """Gets the code_detection_details of this GenerativefirewallRuleOutput.  # noqa: E501


        :return: The code_detection_details of this GenerativefirewallRuleOutput.  # noqa: E501
        :rtype: GenerativefirewallCodeDetectionDetails
        """
        return self._code_detection_details

    @code_detection_details.setter
    def code_detection_details(self, code_detection_details):
        """Sets the code_detection_details of this GenerativefirewallRuleOutput.


        :param code_detection_details: The code_detection_details of this GenerativefirewallRuleOutput.  # noqa: E501
        :type: GenerativefirewallCodeDetectionDetails
        """

        self._code_detection_details = code_detection_details

    @property
    def rule_eval_metadata(self):
        """Gets the rule_eval_metadata of this GenerativefirewallRuleOutput.  # noqa: E501


        :return: The rule_eval_metadata of this GenerativefirewallRuleOutput.  # noqa: E501
        :rtype: RuleOutputRuleEvaluationMetadata
        """
        return self._rule_eval_metadata

    @rule_eval_metadata.setter
    def rule_eval_metadata(self, rule_eval_metadata):
        """Sets the rule_eval_metadata of this GenerativefirewallRuleOutput.


        :param rule_eval_metadata: The rule_eval_metadata of this GenerativefirewallRuleOutput.  # noqa: E501
        :type: RuleOutputRuleEvaluationMetadata
        """

        self._rule_eval_metadata = rule_eval_metadata

    @property
    def security_standards(self):
        """Gets the security_standards of this GenerativefirewallRuleOutput.  # noqa: E501

        Standards encodes which regulatory standards (MITRE, OWASP) are addressed by this firewall rule.  # noqa: E501

        :return: The security_standards of this GenerativefirewallRuleOutput.  # noqa: E501
        :rtype: list[ApigenerativefirewallStandardInfo]
        """
        return self._security_standards

    @security_standards.setter
    def security_standards(self, security_standards):
        """Sets the security_standards of this GenerativefirewallRuleOutput.

        Standards encodes which regulatory standards (MITRE, OWASP) are addressed by this firewall rule.  # noqa: E501

        :param security_standards: The security_standards of this GenerativefirewallRuleOutput.  # noqa: E501
        :type: list[ApigenerativefirewallStandardInfo]
        """

        self._security_standards = security_standards

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GenerativefirewallRuleOutput, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GenerativefirewallRuleOutput):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
