# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GenerativevalidationBody(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'body_object': 'object',
        'prompt_key': 'str',
        'prompt_key_role': 'str'
    }

    attribute_map = {
        'body_object': 'bodyObject',
        'prompt_key': 'promptKey',
        'prompt_key_role': 'promptKeyRole'
    }

    def __init__(self, body_object=None, prompt_key=None, prompt_key_role=None):  # noqa: E501
        """GenerativevalidationBody - a model defined in Swagger"""  # noqa: E501
        self._body_object = None
        self._prompt_key = None
        self._prompt_key_role = None
        self.discriminator = None
        if body_object is not None:
            self.body_object = body_object
        if prompt_key is not None:
            self.prompt_key = prompt_key
        if prompt_key_role is not None:
            self.prompt_key_role = prompt_key_role

    @property
    def body_object(self):
        """Gets the body_object of this GenerativevalidationBody.  # noqa: E501


        :return: The body_object of this GenerativevalidationBody.  # noqa: E501
        :rtype: object
        """
        return self._body_object

    @body_object.setter
    def body_object(self, body_object):
        """Sets the body_object of this GenerativevalidationBody.


        :param body_object: The body_object of this GenerativevalidationBody.  # noqa: E501
        :type: object
        """

        self._body_object = body_object

    @property
    def prompt_key(self):
        """Gets the prompt_key of this GenerativevalidationBody.  # noqa: E501

        The key of the message that is being sent to the model. For example, \"text\" in the example for the object_body. Case sensitive.  # noqa: E501

        :return: The prompt_key of this GenerativevalidationBody.  # noqa: E501
        :rtype: str
        """
        return self._prompt_key

    @prompt_key.setter
    def prompt_key(self, prompt_key):
        """Sets the prompt_key of this GenerativevalidationBody.

        The key of the message that is being sent to the model. For example, \"text\" in the example for the object_body. Case sensitive.  # noqa: E501

        :param prompt_key: The prompt_key of this GenerativevalidationBody.  # noqa: E501
        :type: str
        """

        self._prompt_key = prompt_key

    @property
    def prompt_key_role(self):
        """Gets the prompt_key_role of this GenerativevalidationBody.  # noqa: E501

        The role that the prompt key should look for. If there is only one role, this can be omitted. Case sensitive.  # noqa: E501

        :return: The prompt_key_role of this GenerativevalidationBody.  # noqa: E501
        :rtype: str
        """
        return self._prompt_key_role

    @prompt_key_role.setter
    def prompt_key_role(self, prompt_key_role):
        """Sets the prompt_key_role of this GenerativevalidationBody.

        The role that the prompt key should look for. If there is only one role, this can be omitted. Case sensitive.  # noqa: E501

        :param prompt_key_role: The prompt_key_role of this GenerativevalidationBody.  # noqa: E501
        :type: str
        """

        self._prompt_key_role = prompt_key_role

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GenerativevalidationBody, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GenerativevalidationBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
