# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GenerativevalidationGenerativeTestingResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'RimeUUID',
        'job_id': 'RimeUUID',
        'attack_technique': 'str',
        'attack_objective': 'RimeAttackObjective',
        'objective_sub_category': 'GenerativevalidationObjectiveSubCategory',
        'failing_examples': 'list[GenerativeTestingResultExample]',
        'severity': 'LibgenerativeSeverity',
        'owasp_standards': 'list[GenerativevalidationGenerativeTestingResultStandardInfo]',
        'nist_standards': 'list[GenerativevalidationGenerativeTestingResultStandardInfo]',
        'mitre_standards': 'list[GenerativevalidationGenerativeTestingResultStandardInfo]',
        'attacks_attempted': 'int',
        'threat': 'GenerativevalidationThreat',
        'successful_attacks': 'int',
        'skipped_reason': 'str',
        'generative_validation_test_run_id': 'RimeUUID'
    }

    attribute_map = {
        'id': 'id',
        'job_id': 'jobId',
        'attack_technique': 'attackTechnique',
        'attack_objective': 'attackObjective',
        'objective_sub_category': 'objectiveSubCategory',
        'failing_examples': 'failingExamples',
        'severity': 'severity',
        'owasp_standards': 'owaspStandards',
        'nist_standards': 'nistStandards',
        'mitre_standards': 'mitreStandards',
        'attacks_attempted': 'attacksAttempted',
        'threat': 'threat',
        'successful_attacks': 'successfulAttacks',
        'skipped_reason': 'skippedReason',
        'generative_validation_test_run_id': 'generativeValidationTestRunId'
    }

    def __init__(self, id=None, job_id=None, attack_technique=None, attack_objective=None, objective_sub_category=None, failing_examples=None, severity=None, owasp_standards=None, nist_standards=None, mitre_standards=None, attacks_attempted=None, threat=None, successful_attacks=None, skipped_reason=None, generative_validation_test_run_id=None):  # noqa: E501
        """GenerativevalidationGenerativeTestingResult - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._job_id = None
        self._attack_technique = None
        self._attack_objective = None
        self._objective_sub_category = None
        self._failing_examples = None
        self._severity = None
        self._owasp_standards = None
        self._nist_standards = None
        self._mitre_standards = None
        self._attacks_attempted = None
        self._threat = None
        self._successful_attacks = None
        self._skipped_reason = None
        self._generative_validation_test_run_id = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if job_id is not None:
            self.job_id = job_id
        if attack_technique is not None:
            self.attack_technique = attack_technique
        if attack_objective is not None:
            self.attack_objective = attack_objective
        if objective_sub_category is not None:
            self.objective_sub_category = objective_sub_category
        if failing_examples is not None:
            self.failing_examples = failing_examples
        if severity is not None:
            self.severity = severity
        if owasp_standards is not None:
            self.owasp_standards = owasp_standards
        if nist_standards is not None:
            self.nist_standards = nist_standards
        if mitre_standards is not None:
            self.mitre_standards = mitre_standards
        if attacks_attempted is not None:
            self.attacks_attempted = attacks_attempted
        if threat is not None:
            self.threat = threat
        if successful_attacks is not None:
            self.successful_attacks = successful_attacks
        if skipped_reason is not None:
            self.skipped_reason = skipped_reason
        if generative_validation_test_run_id is not None:
            self.generative_validation_test_run_id = generative_validation_test_run_id

    @property
    def id(self):
        """Gets the id of this GenerativevalidationGenerativeTestingResult.  # noqa: E501


        :return: The id of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this GenerativevalidationGenerativeTestingResult.


        :param id: The id of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: RimeUUID
        """

        self._id = id

    @property
    def job_id(self):
        """Gets the job_id of this GenerativevalidationGenerativeTestingResult.  # noqa: E501


        :return: The job_id of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """Sets the job_id of this GenerativevalidationGenerativeTestingResult.


        :param job_id: The job_id of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: RimeUUID
        """

        self._job_id = job_id

    @property
    def attack_technique(self):
        """Gets the attack_technique of this GenerativevalidationGenerativeTestingResult.  # noqa: E501

        The attack technique used in the prompt. This is a string because the types of attacks changes frequently over time depending on our threat intelligence.  # noqa: E501

        :return: The attack_technique of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: str
        """
        return self._attack_technique

    @attack_technique.setter
    def attack_technique(self, attack_technique):
        """Sets the attack_technique of this GenerativevalidationGenerativeTestingResult.

        The attack technique used in the prompt. This is a string because the types of attacks changes frequently over time depending on our threat intelligence.  # noqa: E501

        :param attack_technique: The attack_technique of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: str
        """

        self._attack_technique = attack_technique

    @property
    def attack_objective(self):
        """Gets the attack_objective of this GenerativevalidationGenerativeTestingResult.  # noqa: E501


        :return: The attack_objective of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: RimeAttackObjective
        """
        return self._attack_objective

    @attack_objective.setter
    def attack_objective(self, attack_objective):
        """Sets the attack_objective of this GenerativevalidationGenerativeTestingResult.


        :param attack_objective: The attack_objective of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: RimeAttackObjective
        """

        self._attack_objective = attack_objective

    @property
    def objective_sub_category(self):
        """Gets the objective_sub_category of this GenerativevalidationGenerativeTestingResult.  # noqa: E501


        :return: The objective_sub_category of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: GenerativevalidationObjectiveSubCategory
        """
        return self._objective_sub_category

    @objective_sub_category.setter
    def objective_sub_category(self, objective_sub_category):
        """Sets the objective_sub_category of this GenerativevalidationGenerativeTestingResult.


        :param objective_sub_category: The objective_sub_category of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: GenerativevalidationObjectiveSubCategory
        """

        self._objective_sub_category = objective_sub_category

    @property
    def failing_examples(self):
        """Gets the failing_examples of this GenerativevalidationGenerativeTestingResult.  # noqa: E501

        List of failing examples to demonstrate failures in this category.  # noqa: E501

        :return: The failing_examples of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: list[GenerativeTestingResultExample]
        """
        return self._failing_examples

    @failing_examples.setter
    def failing_examples(self, failing_examples):
        """Sets the failing_examples of this GenerativevalidationGenerativeTestingResult.

        List of failing examples to demonstrate failures in this category.  # noqa: E501

        :param failing_examples: The failing_examples of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: list[GenerativeTestingResultExample]
        """

        self._failing_examples = failing_examples

    @property
    def severity(self):
        """Gets the severity of this GenerativevalidationGenerativeTestingResult.  # noqa: E501


        :return: The severity of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: LibgenerativeSeverity
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this GenerativevalidationGenerativeTestingResult.


        :param severity: The severity of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: LibgenerativeSeverity
        """

        self._severity = severity

    @property
    def owasp_standards(self):
        """Gets the owasp_standards of this GenerativevalidationGenerativeTestingResult.  # noqa: E501

        List of the OWASP AI risk standards associated with the attacks in these results.  # noqa: E501

        :return: The owasp_standards of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: list[GenerativevalidationGenerativeTestingResultStandardInfo]
        """
        return self._owasp_standards

    @owasp_standards.setter
    def owasp_standards(self, owasp_standards):
        """Sets the owasp_standards of this GenerativevalidationGenerativeTestingResult.

        List of the OWASP AI risk standards associated with the attacks in these results.  # noqa: E501

        :param owasp_standards: The owasp_standards of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: list[GenerativevalidationGenerativeTestingResultStandardInfo]
        """

        self._owasp_standards = owasp_standards

    @property
    def nist_standards(self):
        """Gets the nist_standards of this GenerativevalidationGenerativeTestingResult.  # noqa: E501

        List of the NIST AI risk standards associated with the attacks in these results.  # noqa: E501

        :return: The nist_standards of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: list[GenerativevalidationGenerativeTestingResultStandardInfo]
        """
        return self._nist_standards

    @nist_standards.setter
    def nist_standards(self, nist_standards):
        """Sets the nist_standards of this GenerativevalidationGenerativeTestingResult.

        List of the NIST AI risk standards associated with the attacks in these results.  # noqa: E501

        :param nist_standards: The nist_standards of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: list[GenerativevalidationGenerativeTestingResultStandardInfo]
        """

        self._nist_standards = nist_standards

    @property
    def mitre_standards(self):
        """Gets the mitre_standards of this GenerativevalidationGenerativeTestingResult.  # noqa: E501

        List of the MITRE AI risk standards associated with the attacks in these results.  # noqa: E501

        :return: The mitre_standards of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: list[GenerativevalidationGenerativeTestingResultStandardInfo]
        """
        return self._mitre_standards

    @mitre_standards.setter
    def mitre_standards(self, mitre_standards):
        """Sets the mitre_standards of this GenerativevalidationGenerativeTestingResult.

        List of the MITRE AI risk standards associated with the attacks in these results.  # noqa: E501

        :param mitre_standards: The mitre_standards of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: list[GenerativevalidationGenerativeTestingResultStandardInfo]
        """

        self._mitre_standards = mitre_standards

    @property
    def attacks_attempted(self):
        """Gets the attacks_attempted of this GenerativevalidationGenerativeTestingResult.  # noqa: E501

        The number of attacks attempted for these results.  # noqa: E501

        :return: The attacks_attempted of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: int
        """
        return self._attacks_attempted

    @attacks_attempted.setter
    def attacks_attempted(self, attacks_attempted):
        """Sets the attacks_attempted of this GenerativevalidationGenerativeTestingResult.

        The number of attacks attempted for these results.  # noqa: E501

        :param attacks_attempted: The attacks_attempted of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: int
        """

        self._attacks_attempted = attacks_attempted

    @property
    def threat(self):
        """Gets the threat of this GenerativevalidationGenerativeTestingResult.  # noqa: E501


        :return: The threat of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: GenerativevalidationThreat
        """
        return self._threat

    @threat.setter
    def threat(self, threat):
        """Sets the threat of this GenerativevalidationGenerativeTestingResult.


        :param threat: The threat of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: GenerativevalidationThreat
        """

        self._threat = threat

    @property
    def successful_attacks(self):
        """Gets the successful_attacks of this GenerativevalidationGenerativeTestingResult.  # noqa: E501

        The number of successful attacks completed for these results.  # noqa: E501

        :return: The successful_attacks of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: int
        """
        return self._successful_attacks

    @successful_attacks.setter
    def successful_attacks(self, successful_attacks):
        """Sets the successful_attacks of this GenerativevalidationGenerativeTestingResult.

        The number of successful attacks completed for these results.  # noqa: E501

        :param successful_attacks: The successful_attacks of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: int
        """

        self._successful_attacks = successful_attacks

    @property
    def skipped_reason(self):
        """Gets the skipped_reason of this GenerativevalidationGenerativeTestingResult.  # noqa: E501

        Indicates that the test was skipped and provides a reason. If the test was not skipped this will be the empty string.  # noqa: E501

        :return: The skipped_reason of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: str
        """
        return self._skipped_reason

    @skipped_reason.setter
    def skipped_reason(self, skipped_reason):
        """Sets the skipped_reason of this GenerativevalidationGenerativeTestingResult.

        Indicates that the test was skipped and provides a reason. If the test was not skipped this will be the empty string.  # noqa: E501

        :param skipped_reason: The skipped_reason of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: str
        """

        self._skipped_reason = skipped_reason

    @property
    def generative_validation_test_run_id(self):
        """Gets the generative_validation_test_run_id of this GenerativevalidationGenerativeTestingResult.  # noqa: E501


        :return: The generative_validation_test_run_id of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._generative_validation_test_run_id

    @generative_validation_test_run_id.setter
    def generative_validation_test_run_id(self, generative_validation_test_run_id):
        """Sets the generative_validation_test_run_id of this GenerativevalidationGenerativeTestingResult.


        :param generative_validation_test_run_id: The generative_validation_test_run_id of this GenerativevalidationGenerativeTestingResult.  # noqa: E501
        :type: RimeUUID
        """

        self._generative_validation_test_run_id = generative_validation_test_run_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GenerativevalidationGenerativeTestingResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GenerativevalidationGenerativeTestingResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
